<?php
session_start();
include '../db.php'; // Database connection

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Get the application ID from the URL
if (isset($_GET['id'])) {
    $appId = intval($_GET['id']); // Sanitize the input

    // Fetch application details
    $stmt = $conn->prepare("SELECT * FROM applications WHERE id = ?");
    $stmt->bind_param("i", $appId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $application = $result->fetch_assoc();
    } else {
        // Application not found, display an error or redirect
        die("Application not found.");
    }
} else {
    // No ID provided, redirect or show an error
    die("No application ID specified.");
}

// Helper to show images safely in detail view
function showFullImage($file) {
    if (!empty($file) && file_exists("../uploads/$file")) {
        // Display larger images for detail view
        return "<img src='../uploads/$file' class='img-fluid' style='max-width: 300px;'>";
    }
    return "<span class='text-danger'>Missing</span>";
}

// You might want to fetch user details here as well if needed for the detail page
$userId = $_SESSION['user_id'];
$userStmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$userStmt->bind_param("i", $userId);
$userStmt->execute();
$userResult = $userStmt->get_result();
$user = $userResult->fetch_assoc();

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <title>Itca Dashboard - View Application</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-4Q6Gf2aSP4eDXB8Miphtr37CMZZQ5oXLH2yaXMJ2w8e2ZtHTl7GptT4jmndRuHDT" crossorigin="anonymous">

  <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <!-- If you use DataTables here, include its CSS -->
  <!-- <link rel="stylesheet" href="https://cdn.datatables.net/2.3.2/css/dataTables.dataTables.css" /> -->

  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="stylesheet" href="assets/css/responsive.css" />
  <style>
    /* Add styles specific to detail view if needed */
    .section { margin-bottom: 25px; padding: 15px; border: 1px solid #eee; border-radius: 5px; }
    .section h4 { margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 5px; }
    .value { margin-bottom: 10px; }
    .label { font-weight: 600; color: #333; display: block; margin-bottom: 5px; }
    .output { color: #555; }
    .uploaded-images-wrap .value img { max-width: 200px; margin-top: 10px; }
    .dl-images > div { margin-right: 20px; }
  </style>
</head>

<body>
  <div class="dashboard_wrapper">
    <div class="left_panel">
      <div class="logo_box">
        <img src="assets/images/logo.png" alt="logo" class="img-fluid full_logo">
        <img src="assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        <div class="button_wrapper">
          <button class="btn mobile_btn" id="mobile_btn_wrap">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-x">
              <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
              <path d="M18 6l-12 12"></path>
              <path d="M6 6l12 12"></path>
            </svg>
          </button>
        </div>
      </div>
   <?php include 'menu.php'; ?>
    </div>

    <div class="right_body_panel">
      <div class="right_header_panel">
        <div class="left_toggle_button">
          <button class="btn toggle_btn" type="button"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" viewBox="0 0 20 14" fill="currentColor">
              <path d="M0 0.995C0 0.445 0.446 0 0.995 0H9.005C9.26889 7.86455e-09 9.52197 0.10483 9.70857 0.291429C9.89517 0.478027 10 0.731109 10 0.995C10 1.25889 9.89517 1.51197 9.70857 1.69857C9.52197 1.88517 9.26889 1.99 9.005 1.99H0.995C0.731109 1.99 0.478028 1.88517 0.291429 1.69857C0.10483 1.51197 0 1.25889 0 0.995ZM0 7C0 6.45 0.446 6.005 0.995 6.005H19.005C19.2689 6.005 19.522 6.10983 19.7086 6.29643C19.8952 6.48303 20 6.73611 20 7C20 7.26389 19.8952 7.51697 19.7086 7.70357C19.522 7.89017 19.2689 7.995 19.005 7.995H0.995C0.731109 7.995 0.478028 7.89017 0.291429 7.70357C0.10483 7.51697 0 7.26389 0 7ZM0.995 12.01C0.731109 12.01 0.478028 12.1148 0.291429 12.3014C0.10483 12.488 0 12.7411 0 13.005C0 13.2689 0.10483 13.522 0.291429 13.7086C0.478028 13.8952 0.731109 14 0.995 14H13.005C13.2689 14 13.522 13.8952 13.7086 13.7086C13.8952 13.522 14 13.2689 14 13.005C14 12.7411 13.8952 12.488 13.7086 12.3014C13.522 12.1148 13.2689 12.01 13.005 12.01H0.995Z" fill="currentColor" />
            </svg>
          </button>
        </div>

        <div class="right_user_box">
          <div class="user_box_warp">
            <span class="circle-name"><?php echo strtoupper(substr($user['full_name'], 0, 2)); ?></span>
            <div class="user_name">
              <h4><?php echo htmlspecialchars($user['full_name']); ?></h4>
            </div>
          </div>
        </div>
      </div>

      <!-- Body box wrapper start here -->
      <div class="body_wrapper_section">
        <div class="body_wrap">
          <!-- Display Application ID dynamically -->
          <h3>Application ID: <?php echo htmlspecialchars($application['id']); ?></h3>
          <div class="inner-wrapper">
            <div class="review">

              <!-- Step 1: Applicant Details -->
              <div class="section">
                <h4>Applicant’s Details</h4>
                <div class="value"><span class="label">Full Name:</span> <span class="output"><?php echo htmlspecialchars($application['full_name']); ?></span> </div>
                <div class="value"><span class="label">DOB:</span> <span class="output"><?php echo htmlspecialchars($application['dob']); ?></span></div>
                <div class="value"><span class="label">Gender:</span><span class="output"><?php echo htmlspecialchars($application['gender']); ?></span></div>
                <div class="value"><span class="label">Email:</span> <span class="output"><?php echo htmlspecialchars($application['email']); ?></span>
                </div>
                <div class="value"><span class="label">Phone:</span><span class="output"><?php echo htmlspecialchars($application['phone']); ?></span> </div>
                <div class="value"><span class="label">Nationality:</span> <span class="output"><?php echo htmlspecialchars($application['nationality']); ?></span> </div>
                
                 <div class="value"><span class="label">Street:</span> <span class="output"><?php echo htmlspecialchars($application['perm_street']); ?></span>
                </div>
                 <div class="value"><span class="label">State:</span> <span class="output"><?php echo htmlspecialchars($application['perm_state']); ?></span>
                </div>
                 <div class="value"><span class="label">City:</span> <span class="output"><?php echo htmlspecialchars($application['perm_city']); ?></span>
                </div>
                <div class="value"><span class="label">License Number:</span> <span class="output"><?php echo htmlspecialchars($application['license_number']); ?></span>
                </div>
              </div>

              <!-- Step 2: Plan Details -->
              <div class="section">
                <h4>Selected Plan</h4>
                <div class="value"><span class="label">Plan:</span> <span class="output"><?php echo htmlspecialchars($application['plan']); ?></span> </div>
                <div class="value"><span class="label">Type:</span> <span class="output"><?php echo htmlspecialchars($application['type']); ?></span></div>
                <div class="value"><span class="label">License Country:</span> <span class="output"><?php echo htmlspecialchars($application['license_country']); ?></span></div>
                <div class="value"><span class="label">Drive Country:</span> <span class="output"><?php echo htmlspecialchars($application['drive_country']); ?></span></div>
                <div class="value"><span class="label">License Class:</span><span class="output"><?php echo htmlspecialchars($application['license_class']); ?></span> </div>
                 <div class="value"><span class="label">Add-ons:</span> <span class="output">Product 1, Product
                                2</span>
                            </div>
                <div class="value"><span class="label">Promo Code:</span> <span class="output"><?php echo htmlspecialchars($application['promo']); ?></span></div>
              </div>

              <!-- Step 3: Documents -->
           <div class="section uploaded-images-wrap">
  <div class="d-flex justify-content-between align-items-start">
    <h4>Uploaded Documents</h4> 
 
  </div>

  <div class="uploaded-images">
      <div class="d-flex dl-images">
    
      <span class="label">Passport Photo:</span>
      <?php
        $passportUrl = '/dhl/uploads/' . $application['passport_photo'];
      ?>
      <a href="<?php echo $passportUrl; ?>" download>
        <img src="<?php echo $passportUrl; ?>" alt="Passport Photo" class="img-thumbnail" width="150" />
      </a>
    </div> 

    <div class="d-flex dl-images">
       
        <span class="label">License Front:</span>
        <?php
          $frontUrl = '/dhl/uploads/' . $application['license_front'];
        ?>
        <a href="<?php echo $frontUrl; ?>" download>
          <img src="<?php echo $frontUrl; ?>" alt="License Front" class="img-thumbnail" width="150" />
        </a>
      
</div>
<div class="d-flex dl-images">
      
        <span class="label">License Back:</span>
        <?php
          $backUrl = '/dhl/uploads/' . $application['license_back'];
        ?>
        <a href="<?php echo $backUrl; ?>" download>
          <img src="<?php echo $backUrl; ?>" alt="License Back" class="img-thumbnail" width="150" />
        </a>
      
      </div>
    </div>
  
</div>

              <!-- Step 4: Shipping Address -->
              <div class="section">
                <h4>Shipping Address</h4>
                <div class="value"><span class="label">Name:</span><span class="output"><?php echo htmlspecialchars($application['ship_fname'] . ' ' . $application['ship_lname']); ?></span> </div>
                <div class="value"><span class="label">Street:</span><span class="output"><?php echo htmlspecialchars($application['street']); ?></span> </div>
                <div class="value"><span class="label">City:</span> <span class="output"><?php echo htmlspecialchars($application['city']); ?></span></div>
                <div class="value"><span class="label">State:</span><span class="output"><?php echo htmlspecialchars($application['state']); ?></span> </div>
                <div class="value"><span class="label">ZIP:</span> <span class="output"><?php echo htmlspecialchars($application['zip']); ?></span></div>
                <div class="value"><span class="label">Country:</span><span class="output"><?php echo htmlspecialchars($application['country']); ?></span> </div>
              </div>

              <!-- Other Details -->
              <div class="section">
                <h4>Other Details</h4>
                <div class="value"><span class="label">Product:</span> <span class="output"><?php echo htmlspecialchars($application['product']); ?></span></div>
                <div class="value"><span class="label">Validity:</span> <span class="output"><?php echo htmlspecialchars($application['validity']); ?></span></div>
                <div class="value"><span class="label">Tracking ID:</span> <span class="output"><?php echo htmlspecialchars($application['order_id']); ?></span></div>
                <div class="value"><span class="label">Total Price:</span> <span class="output">£<?php echo htmlspecialchars($application['total_price']); ?></span></div>
                <div class="value"><span class="label">Created At:</span> <span class="output"><?php echo htmlspecialchars($application['created_at']); ?></span></div>
              </div>

              <!-- Action Section (for status updates, etc.) -->
              <div class="section detail-action">
                
                  <button class="btn btn-primary mt-3" type="button" onclick="history.back()">Back</button>

                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- Body box wrapper end here -->
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js" integrity="sha384-j1CDi7MgGQ12Z7Qab0qlWQ/Qqz24Gc6BM0thvEMVjHnfYGF0rmFCozFSxQBxwHKO" crossorigin="anonymous"></script>
  <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
  <!-- If you use DataTables here, include its JS -->
  <!-- <script src="https://cdn.datatables.net/2.3.2/js/dataTables.js"></script> -->

  <script src="assets/js/script.js"></script>
  <script>
    // JavaScript for toggling the left panel if you have it
    document.addEventListener('DOMContentLoaded', function() {
        const toggleBtn = document.querySelector('.toggle_btn');
        const dashboardWrapper = document.querySelector('.dashboard_wrapper');
        const leftPanel = document.querySelector('.left_panel');

        if (toggleBtn && dashboardWrapper && leftPanel) {
            toggleBtn.addEventListener('click', function() {
                dashboardWrapper.classList.toggle('collapsed');
            });
        }

        // Mobile button for left panel
        const mobileBtn = document.getElementById('mobile_btn_wrap');
        if (mobileBtn && dashboardWrapper) {
            mobileBtn.addEventListener('click', function() {
                dashboardWrapper.classList.toggle('mobile-collapsed');
            });
        }
    });
  </script>
</body>

</html>