<?php
include '../db.php';
$conn->set_charset("utf8mb4");
session_start();
if(!isset($_SESSION['user_id'])){
    header('Location: login.php');
    exit;
} 


// Handle Validity
if(isset($_POST['add_validity'])){
    $validity = trim($_POST['validity']);
    $price = trim($_POST['validity_price']);
    if($validity && $price && is_numeric($price) && $price>0){
        $stmt = $conn->prepare("INSERT INTO addon_validity (validity, price) VALUES (?, ?)");
        $stmt->bind_param("sd", $validity, $price);
        $stmt->execute();
        $successValidity = "Validity added successfully!";
    } else {
        $errorValidity = "Enter valid name and price!";
    }
}

// Handle Promo
if(isset($_POST['add_promo'])){
    $promo = trim($_POST['promo']);
    $discount_type = $_POST['discount_type'];
    $discount_value = floatval($_POST['discount_value']);
    $expiry_date = !empty($_POST['expiry_date']) ? $_POST['expiry_date'] : NULL;
    $usage_limit = !empty($_POST['usage_limit']) ? intval($_POST['usage_limit']) : NULL;

    if($promo && $discount_value > 0){
        $stmt = $conn->prepare("INSERT INTO addon_promo 
            (promo, discount_type, discount_value, expiry_date, usage_limit) 
            VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("ssdsi", $promo, $discount_type, $discount_value, $expiry_date, $usage_limit);
        $stmt->execute();
        $successPromo = "Promo added successfully!";
    } else {
        $errorPromo = "Enter valid promo details!";
    }
}

// Delete actions
if(isset($_GET['delete_addon'])) $conn->query("DELETE FROM addon_products WHERE id=".intval($_GET['delete_addon']));
if(isset($_GET['delete_validity'])) $conn->query("DELETE FROM addon_validity WHERE id=".intval($_GET['delete_validity']));
if(isset($_GET['delete_promo'])) $conn->query("DELETE FROM addon_promo WHERE id=".intval($_GET['delete_promo']));

// Fetch all
$addons = $conn->query("SELECT * FROM addon_products ORDER BY id DESC");
$validities = $conn->query("SELECT * FROM addon_validity ORDER BY id DESC");
$promos = $conn->query("SELECT * FROM addon_promo ORDER BY id DESC");


$uploadDir = 'uploads/';

if (isset($_POST['add_addon'])) {
    $name = trim($_POST['addon_name']);
    $price = filter_var($_POST['addon_price'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

    if ($name && $price && is_numeric($price) && $price > 0) {
        // Check if file is uploaded without errors
        if (isset($_FILES['addon_image']) && $_FILES['addon_image']['error'] === UPLOAD_ERR_OK) {
            $file = $_FILES['addon_image'];
            $fileTmpPath = $file['tmp_name'];
            $fileName = $file['name'];
            $fileSize = $file['size'];
            $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            $allowedExt = ['jpg', 'jpeg', 'png', 'gif'];

            if (in_array($fileExt, $allowedExt) && $fileSize <= 300 * 1024) { // 300 KB max
                $newFileName = uniqid('addon_', true) . '.' . $fileExt;
                $destPath = $uploadDir . $newFileName;

                if (move_uploaded_file($fileTmpPath, $destPath)) {
                    $currentTimestamp = date('Y-m-d H:i:s');

                    $stmt = $conn->prepare("INSERT INTO addon_products (name, price, image, created_at) VALUES (?, ?, ?, ?)");
                    if ($stmt) {
                        $stmt->bind_param("sdss", $name, $price, $newFileName, $currentTimestamp);
                        if ($stmt->execute()) {
                            $successAddon = "Add-on added successfully!";
                            $stmt->close();
                            header("Location: " . $_SERVER['PHP_SELF']);
                            exit();
                        } else {
                            $errorAddon = "Database error: " . $stmt->error;
                            if (file_exists($destPath)) unlink($destPath);
                        }
                    } else {
                        $errorAddon = "Prepare failed: " . $conn->error;
                    }
                } else {
                    $errorAddon = "Failed to move uploaded file.";
                }
            } else {
                $errorAddon = "Invalid file type or size exceeds 300 KB.";
            }
        } else {
            $uploadError = $_FILES['addon_image']['error'];

            switch ($uploadError) {
                case UPLOAD_ERR_INI_SIZE:
                case UPLOAD_ERR_FORM_SIZE:
                    $errorAddon = "The uploaded file exceeds the maximum allowed size.";
                    break;
                case UPLOAD_ERR_PARTIAL:
                    $errorAddon = "The uploaded file was only partially uploaded.";
                    break;
                case UPLOAD_ERR_NO_FILE:
                    $errorAddon = "No file was uploaded.";
                    break;
                case UPLOAD_ERR_NO_TMP_DIR:
                    $errorAddon = "Missing a temporary folder.";
                    break;
                case UPLOAD_ERR_CANT_WRITE:
                    $errorAddon = "Failed to write file to disk.";
                    break;
                case UPLOAD_ERR_EXTENSION:
                    $errorAddon = "A PHP extension stopped the file upload.";
                    break;
                default:
                    $errorAddon = "An unknown error occurred.";
                    break;
            }
        }
    } else {
        $errorAddon = "Enter valid name and price.";
    }
}
 

?>




<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Addon Options Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
    .circle-name { 
        width: 40px; height: 40px; 
        border-radius: 50%; background: #007bff; 
        color: #fff; text-align: center; line-height: 40px; 
        font-weight: bold; margin-right: 10px;
    }
    .table-style img { max-height: 50px; }
</style>
<script>
function generatePromo() {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    let code = "";
    for (let i = 0; i < 8; i++) {
        code += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById("promoInput").value = code;
}
</script>
</head>
<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
        <?php include 'menu.php'; ?>
    </div>

    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button">
                <button class="btn toggle_btn" type="button"></button>
            </div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?php echo strtoupper(substr($user['full_name'], 0, 2)); ?></span>
                    <div class="user_name"><h4><?php echo htmlspecialchars($user['full_name']); ?></h4></div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
   <div class="mb-4 p-3 border">
    <h4>Add Add-on</h4>

    <!-- Success/Error Messages -->
    <?php if (!empty($successAddon)): ?>
        <div class="alert alert-success"><?= htmlspecialchars($successAddon) ?></div>
    <?php endif; ?>

    <?php if (!empty($errorAddon)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($errorAddon) ?></div>
    <?php endif; ?>

    <!-- Add-on Form -->
    <form method="post" enctype="multipart/form-data" class="d-flex gap-2 mb-2">
        <input type="text" name="addon_name" class="form-control" placeholder="Addon Name" required>
        <input type="text" name="addon_price" class="form-control" placeholder="Price" required>
        <input type="file" name="addon_image" class="form-control" accept="image/*" required>
        <button type="submit" name="add_addon" class="btn btn-primary">Add</button>
    </form>

    <!-- Add-ons Table -->
    <table class="table table-bordered">
        <thead>
            <tr><th>ID</th><th>Name</th><th>Price</th><th>Image</th><th>Action</th></tr>
        </thead>
        <tbody>
            <?php if ($addons && $addons->num_rows > 0): ?>
                <?php while ($row = $addons->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= number_format($row['price'], 2) ?></td>
                        <td>
                            <?php if (!empty($row['image']) && file_exists("uploads/{$row['image']}")): ?>
                                <img src="uploads/<?= htmlspecialchars($row['image']) ?>" alt="Addon Image" style="height: 50px;">
                            <?php else: ?>
                                <span class="text-muted">No image</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="?delete_addon=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this addon?')">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="5" class="text-center">No add-ons found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>




<!-- Validity Section -->
<div class="mb-4 p-3 border">
    <h4>Add Validity</h4>
    <?php if(isset($successValidity)) echo "<div class='alert alert-success'>$successValidity</div>"; ?>
    <?php if(isset($errorValidity)) echo "<div class='alert alert-danger'>$errorValidity</div>"; ?>
    <form method="post" class="d-flex gap-2 mb-2">
        <input type="text" name="validity" class="form-control" placeholder="Validity Name" required>
        <input type="text" name="validity_price" class="form-control" placeholder="Price" required>
        <button type="submit" name="add_validity" class="btn btn-primary">Add</button>
    </form>
    <table class="table table-bordered">
        <thead><tr><th>ID</th><th>Name</th><th>Price</th><th>Action</th></tr></thead>
        <tbody>
        <?php while($row=$validities->fetch_assoc()): ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['validity']) ?></td>
                <td><?= number_format($row['price'],2) ?></td>
                <td><a href="?delete_validity=<?= $row['id'] ?>" class="btn btn-danger btn-sm">Delete</a></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>

<!-- Promo Section -->
<div class="mb-4 p-3 border">
    <h4>Add Promo Code</h4>
    <?php if(isset($successPromo)) echo "<div class='alert alert-success'>$successPromo</div>"; ?>
    <?php if(isset($errorPromo)) echo "<div class='alert alert-danger'>$errorPromo</div>"; ?>
 <form method="post" class="row g-2 mb-2">

    <!-- Promo Code -->
    <div class="col-md-3">
        <label for="promoInput" class="form-label">Promo Code</label>
        <div class="d-flex">
            <input type="text" id="promoInput" name="promo" class="form-control" placeholder="Promo Code" required>
            <button type="button" class="btn btn-danger btn-sm" onclick="generatePromo()">Generate</button>
        </div>
    </div>

    <!-- Discount Type -->
    <div class="col-md-3">
        <label for="discount_type" class="form-label">Discount Type</label>
        <select name="discount_type" id="discount_type" class="form-control">
            <option value="percent">Percent (%)</option>
            <option value="fixed">Fixed Amount</option>
        </select>
    </div>

    <!-- Discount Value -->
    <div class="col-md-2">
        <label for="discount_value" class="form-label">Discount Value</label>
        <input type="number" step="0.01" id="discount_value" name="discount_value" class="form-control" placeholder="Value" required>
    </div>

    <!-- Expiry Date -->
    <div class="col-md-2">
        <label for="expiry_date" class="form-label">Expiry Date</label>
        <input type="date" id="expiry_date" name="expiry_date" class="form-control">
    </div>

    
    <!-- Submit -->
    <div class="col-md-12 mt-2">
        <button type="submit" name="add_promo" class="btn btn-primary">Add</button>
    </div>
</form>

<!-- Promo List Table -->
<table class="table table-bordered mt-3">
    <thead>
        <tr>
            <th>ID</th>
            <th>Promo Code</th>
            <th>Discount Type</th>
            <th>Discount Value</th>
            <th>Expiry Date</th> 
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
    <?php while($row=$promos->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= htmlspecialchars($row['promo']) ?></td>
            <td><?= ucfirst($row['discount_type']) ?></td>
            <td>
                <?php if($row['discount_type']=='percent'): ?>
                    <?= $row['discount_value'] ?>%
                <?php else: ?>
                    $<?= number_format($row['discount_value'],2) ?>
                <?php endif; ?>
            </td>
            <td><?= $row['expiry_date'] ? htmlspecialchars($row['expiry_date']) : '-' ?></td>
           
            <td>
                <a href="?delete_promo=<?= $row['id'] ?>" class="btn btn-danger btn-sm">Delete</a>
            </td>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>

</div>
        </div>
    </div>
</div>
</body>
</html>
