<?php
include '../db.php';  // Include database connection

// Fetch applications from the database
$sql = "SELECT * FROM applications";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Itca Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="assets/css/style.css" />
</head>
<body>
    <div class="dashboard_wrapper">
        <div class="left_panel">
            <div class="logo_box">
                <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo" />
                <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon" />
                <div class="button_wrapper">
                    <button class="btn mobile_btn" id="mobile_btn_wrap">
                        <!-- Mobile Toggle Button -->
                    </button>
                </div>
            </div>
            <div class="menu_link">
                <ul>
                    <li><a href="index.php" class="active">Permit Request</a></li>
                    <li><a href="#">Form Controller</a></li>
                    <li><a href="#">Profile Setting</a></li>
                    <li><a href="#">Log Out</a></li>
                </ul>
            </div>
        </div>

        <div class="right_body_panel">
            <div class="right_header_panel">
                <div class="left_toggle_button">
                    <button class="btn toggle_btn" type="button">
                        <!-- Toggle button for sidebar -->
                    </button>
                </div>
                <div class="right_user_box">
                    <div class="user_box_warp">
                        <span class="circle-name">Ad</span>
                        <div class="user_name">
                            <h4>Admin</h4>
                        </div>
                    </div>
                </div>
            </div>

            <div class="body_wrapper_section">
                <div class="body_wrap">
                    <h3>Permit Request(s)</h3>
                    <div class="table-wrapper inner-wrapper">
                        <table id="myTable" class="display table-style">
                            <thead>
                                <tr>
                                    <th>Application ID</th>
                                    <th>Full Name</th>
                                    <th>DOB</th>
                                    <th>Gender</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Nationality</th>
                                    <th>License Number</th>
                                    <th>Plan</th>
                                    <th>Type</th>
                                    <th>License Country</th>
                                    <th>Drive Country</th>
                                    <th>License Class</th>
                                    <th>Addons</th>
                                    <th>Promo Code</th>
                                    <th>Passport Photo</th>
                                    <th>License Front</th>
                                    <th>License Back</th>
                                    <th>Shipping First Name</th>
                                    <th>Shipping Last Name</th>
                                    <th>Street</th>
                                    <th>State</th>
                                    <th>ZIP</th>
                                    <th>City</th>
                                    <th>Country</th>
                                    <th>Created At</th>
                                    <th>Product</th>
                                    <th>Validity</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="applicationData">
                                <?php
                                if ($result->num_rows > 0) {
                                    // Output data of each row
                                    while ($row = $result->fetch_assoc()) {
                                        echo "<tr>";
                                        echo "<td>" . $row['id'] . "</td>";
                                        echo "<td>" . $row['full_name'] . "</td>";
                                        echo "<td>" . $row['dob'] . "</td>";
                                        echo "<td>" . $row['gender'] . "</td>";
                                        echo "<td>" . $row['email'] . "</td>";
                                        echo "<td>" . $row['phone'] . "</td>";
                                        echo "<td>" . $row['nationality'] . "</td>";
                                        echo "<td>" . $row['license_number'] . "</td>";
                                        echo "<td>" . $row['plan'] . "</td>";
                                        echo "<td>" . $row['type'] . "</td>";
                                        echo "<td>" . $row['license_country'] . "</td>";
                                        echo "<td>" . $row['drive_country'] . "</td>"; 
                                        echo "<td>" . (file_exists("../uploads/{$row['license_class']}") && !empty($row['license_class']) 
                                            ? "<img src='../uploads/{$row['license_class']}' alt='License Class' width='50' height='50'>" 
                                            : "<span class='text-danger'>Missing</span>") . "</td>";
                                        
                                        echo "<td>" . htmlspecialchars($row['addons']) . "</td>";
                                        echo "<td>" . htmlspecialchars($row['promo']) . "</td>";
                                        
                                        echo "<td>" . (file_exists("../uploads/{$row['passport_photo']}") && !empty($row['passport_photo']) 
                                            ? "<img src='../uploads/{$row['passport_photo']}' alt='Passport Photo' width='50' height='50'>" 
                                            : "<span class='text-danger'>Missing</span>") . "</td>";
                                        
                                        echo "<td>" . (file_exists("../uploads/{$row['license_front']}") && !empty($row['license_front']) 
                                            ? "<img src='../uploads/{$row['license_front']}' alt='License Front' width='50' height='50'>" 
                                            : "<span class='text-danger'>Missing</span>") . "</td>";
                                        
                                        echo "<td>" . (file_exists("../uploads/{$row['license_back']}") && !empty($row['license_back']) 
                                            ? "<img src='../uploads/{$row['license_back']}' alt='License Back' width='50' height='50'>" 
                                            : "<span class='text-danger'>Missing</span>") . "</td>";

                                        echo "<td>" . $row['ship_fname'] . "</td>";
                                        echo "<td>" . $row['ship_lname'] . "</td>";
                                        echo "<td>" . $row['street'] . "</td>";
                                        echo "<td>" . $row['state'] . "</td>";
                                        echo "<td>" . $row['zip'] . "</td>";
                                        echo "<td>" . $row['city'] . "</td>";
                                        echo "<td>" . $row['country'] . "</td>";
                                        echo "<td>" . $row['created_at'] . "</td>";
                                        echo "<td>" . $row['product'] . "</td>";
                                        echo "<td>" . $row['validity'] . "</td>";
                                        echo "<td>" . $row['status'] . "</td>";
                                        echo "<td>
                                                <a href='view_details.php?id=" . $row['id'] . "' class='btn btn-warning'>Edit</a>
                                              </td>";
                                        echo "</tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='9'>No records found</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Application Detail Modal -->
            <div class="modal fade" id="applicationModal" tabindex="-1" aria-labelledby="applicationModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="applicationModalLabel">Application ID: <span id="modalAppId"></span></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <div class="modal-body">
                            <div class="review">
                                <div class="section">
                                    <h4>Applicant’s Details</h4>
                                    <div class="value"><span class="label">Full Name:</span> <span id="modalFullName"></span></div>
                                    <div class="value"><span class="label">DOB:</span> <span id="modalDOB"></span></div>
                                    <div class="value"><span class="label">Gender:</span> <span id="modalGender"></span></div>
                                    <div class="value"><span class="label">Email:</span> <span id="modalEmail"></span></div>
                                    <div class="value"><span class="label">Phone:</span> <span id="modalPhone"></span></div>
                                    <div class="value"><span class="label">Nationality:</span> <span id="modalNationality"></span></div>
                                    <div class="value"><span class="label">License Number:</span> <span id="modalLicense"></span></div>
                                </div>

                                <div class="section">
                                    <h4>Plan and License Details</h4>
                                    <div class="value"><span class="label">Plan:</span> <span id="modalPlan"></span></div>
                                    <div class="value"><span class="label">Type:</span> <span id="modalType"></span></div>
                                    <div class="value"><span class="label">License Country:</span> <span id="modalLicenseCountry"></span></div>
                                    <div class="value"><span class="label">Drive Country:</span> <span id="modalDriveCountry"></span></div>
                                    <div class="value"><span class="label">License Class:</span> <span id="modalLicenseClass"></span></div>
                                    <div class="value"><span class="label">Addons:</span> <span id="modalAddons"></span></div>
                                    <div class="value"><span class="label">Promo Code:</span> <span id="modalPromo"></span></div>
                                </div>

                                <div class="section">
                                    <h4>Documents</h4>
                                    <div class="value"><span class="label">Passport Photo:</span>
                                        <img id="modalPassportPhoto" src="" style="max-width: 150px;">
                                    </div>
                                    <div class="value"><span class="label">License Front:</span>
                                        <img id="modalLicenseFront" src="" style="max-width: 150px;">
                                    </div>
                                    <div class="value"><span class="label">License Back:</span>
                                        <img id="modalLicenseBack" src="" style="max-width: 150px;">
                                    </div>
                                </div>

                                <div class="section">
                                    <h4>Shipping Address</h4>
                                    <div class="value"><span class="label">Name:</span> <span id="modalName"></span></div>
                                    <div class="value"><span class="label">Street:</span> <span id="modalStreet"></span></div>
                                    <div class="value"><span class="label">City:</span> <span id="modalCity"></span></div>
                                    <div class="value"><span class="label">State:</span> <span id="modalState"></span></div>
                                    <div class="value"><span class="label">ZIP:</span> <span id="modalZip"></span></div>
                                    <div class="value"><span class="label">Country:</span> <span id="modalCountry"></span></div>
                                </div>

                                <div class="section">
                                    <h4>Other Information</h4>
                                    <div class="value"><span class="label">Created At:</span> <span id="modalCreatedAt"></span></div>
                                    <div class="value"><span class="label">Product:</span> <span id="modalProduct"></span></div>
                                    <div class="value"><span class="label">Validity:</span> <span id="modalValidity"></span></div>
                                    <div class="value"><span class="label">Status:</span> <span id="modalStatus"></span></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const modal = new bootstrap.Modal(document.getElementById('applicationModal'));
            document.querySelectorAll('button[data-bs-target="#applicationModal"]').forEach(function (button) {
                button.addEventListener('click', function () {
                    const appId = this.getAttribute('data-id');
                    // Fetch application details by appId via AJAX or a similar method
                    fetchApplicationDetails(appId);
                });
            });
        });

        function fetchApplicationDetails(appId) {
            // You can make an AJAX request here to fetch application details using appId
            // For simplicity, let's assume this is an example data:
            document.getElementById('modalAppId').textContent = appId;
            document.getElementById('modalFullName').textContent = "John Doe";
            document.getElementById('modalDOB').textContent = "01/01/1980";
            document.getElementById('modalGender').textContent = "Male";
            document.getElementById('modalEmail').textContent = "john@example.com";
            document.getElementById('modalPhone').textContent = "123456789";
            document.getElementById('modalNationality').textContent = "American";
            document.getElementById('modalLicense').textContent = "ABC12345";
            document.getElementById('modalPlan').textContent = "Premium";
            document.getElementById('modalType').textContent = "Type A";
            document.getElementById('modalLicenseCountry').textContent = "USA";
            document.getElementById('modalDriveCountry').textContent = "UK";
            document.getElementById('modalLicenseClass').textContent = "B";
            document.getElementById('modalAddons').textContent = "GPS, Insurance";
            document.getElementById('modalPromo').textContent = "SAVE10";
            
            document.getElementById('modalPassportPhoto').src = "path/to/passport_photo.jpg";
            document.getElementById('modalLicenseFront').src = "path/to/license_front.jpg";
            document.getElementById('modalLicenseBack').src = "path/to/license_back.jpg";
            
            document.getElementById('modalName').textContent = "John Doe";
            document.getElementById('modalStreet').textContent = "123 Main St";
            document.getElementById('modalCity').textContent = "New York";
            document.getElementById('modalState').textContent = "NY";
            document.getElementById('modalZip').textContent = "10001";
            document.getElementById('modalCountry').textContent = "USA";
            
            document.getElementById('modalCreatedAt').textContent = "2025-01-01";
            document.getElementById('modalProduct').textContent = "Booklet + Card";
            document.getElementById('modalValidity').textContent = "1 Year";
            document.getElementById('modalStatus').textContent = "Active";
            
            modal.show();
        }
    </script>
</body>
</html>
