<?php
include 'session.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  $_SESSION['step4'] = $_POST;
  header('Location: step5.php');
  exit;
}

// echo '<pre>';
// print_r($_SESSION);
// die;
?>
<!DOCTYPE html>
<html>

<head>
  <title>Step 4 - Shipping Address</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php include('link.php'); ?>
</head>

<body>


  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step ">
        <span class="number">01</span>
        <span class="label">Applicant’s Details</span>
      </div>
      <div class="step ">
        <span class="number">02</span>
        <span class="label">Choose Plan</span>
      </div>
      <div class="step ">
        <span class="number">03</span>
        <span class="label">Add Document</span>
      </div>
      <div class="step active">
        <span class="number">04</span>
        <span class="label">Shipping</span>
      </div>
      <div class="step">
        <span class="number">05</span>
        <span class="label">Review</span>
      </div>
      <div class="step">
        <span class="number">06</span>
        <span class="label">Payment</span>
      </div>
    </div>
  </section>

  <div class="licenceform">
    <div class="container">

      <div class="main-form-container">
        <div class="form-container">
          <h2>Shipping Address</h2>
          <form method="post" action="">
            <!-- First Name / Last Name -->
            <div class="formfield step-four" style="display: flex; gap: 10px;">
              <div style="flex: 1;">
                <label>First Name *</label><br>
                <input type="text" name="first_name" required>
              </div>
              <div style="flex: 1;">
                <label>Last Name *</label><br>
                <input type="text" name="last_name" required>
              </div>
            </div><br>

            <!-- Country -->
            <label>Country *</label><br>
            <select name="country" required>
              <option value="">Select Country</option>
              <option value="Ind">India</option>
              <option value="USA">USA</option>
              <option value="DE">Germany</option>
              <option value="SG">Singapore</option>
              <option value="FR">France</option>
            </select><br><br>

            <!-- Street Address -->
            <label>Street Address *</label><br>
            <input type="text" name="street" required><br><br>

            <!-- State / Region -->
            <label>State/Region/Province *</label><br>
            <input type="text" name="state" required><br><br>

            <!-- ZIP & City -->
            <div class="formfield" style="display: flex; gap: 10px;">
              <div style="flex: 1;">
                <label>ZIP *</label><br>
                <input type="text" name="zip" required>
              </div>
              <div style="flex: 1;">
                <label>City *</label><br>
                <input type="text" name="city" required>
              </div>
            </div><br>


            <!-- Buttons -->
            <div class="back-continue-button-wrap">
              <a href="step3.php"><button type="button" class="first-btn-cicle">Back</button></a>
              <button type="submit" id="getRatesBtn" class="btn secondary-btn-circle">Verify & Continue</button>
            </div>
          </form>
        </div>
        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>
      </div>

    </div>
  </div>


  <?php include('footer.php'); ?>



  <script>
    // Hamburger Toggle
    document.addEventListener('DOMContentLoaded', function() {
      const hamburger = document.querySelector('.hamburger');
      const navLinks = document.querySelector('.nav-links');

      if (hamburger && navLinks) {
        hamburger.addEventListener('click', function() {
          navLinks.classList.toggle('active');
        });
      }
    });




    document.getElementById("getRatesBtn").addEventListener("click", function(event) {
      event.preventDefault();
      alert('Button clicked');
      let recPostalCode = document.querySelector("input[name='zip']").value;
      let recCityName = document.querySelector("input[name='city']").value;
      let recCountryCode = document.querySelector("select[name='country']").value;
      let recAddress = document.querySelector("input[name='street']").value;
      let recState = document.querySelector("input[name='state']").value;

      let requestData = {
        receiverDetails: {
          postalCode: recPostalCode,
          cityName: recCityName,
          countryCode: recCountryCode,
          addressLine1: recAddress
        }
      };

      fetch("dhl_rate.php", {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: JSON.stringify(requestData)
        })
        .then(response => response.json())
        .then(data => {
          console.log("DHL Response:", data);

          // find the billing currency (BILLC)
          let billcRate = null;
          if (data.products && data.products.length > 0) {
            let totalPrices = data.products[0].totalPrice;
            billcRate = totalPrices.find(p => p.currencyType === "BILLC");
          }

          if (billcRate) {
            localStorage.setItem("dhl_rate", JSON.stringify(billcRate));
          } else {
            alert("No Billing Currency (BILLC) found in response");
          }

          // redirect dynamically
          let baseUrl = window.location.origin + "/drive/";
          window.location.href = baseUrl + "step5.php";
        })
        .catch(err => console.error("Error fetching DHL rates:", err));

    });
  </script>

</body>

</html>