<?php
include('step2_logic.php');

date_default_timezone_set('Europe/London'); // UK time

$ukHour = (int)date('G'); // 0-23
$ukDay  = (int)date('w'); // 0=Sun, 6=Sat
$ukDateTime = date('Y-m-d H:i:s'); // current UK date and time

// Get weekend price from database
$formControll = $conn->query("SELECT * FROM form_controll ORDER BY id DESC LIMIT 1")->fetch_assoc();

$prices['weekend_type_price'] = $formControll['weekend_type_price'] ?? $prices['urgent_type_price'];
$prices['base_urgent_type_price'] = $prices['urgent_type_price']; // keep original urgent price



?>

<!-- Echo UK date & time -->
<div>Current UK Date & Time: <?= $ukDateTime ?></div>

<script>
window.ukHour = <?= $ukHour ?>;
window.ukDay = <?= $ukDay ?>;
window.ukDateTime = "<?= $ukDateTime ?>"; // pass to JS if needed
window.prices = <?= json_encode($prices) ?>;
window.promoInfo = <?= json_encode([
  'code' => $_SESSION['step2']['promo'] ?? '',
  'type' => $_SESSION['step2']['promo_type'] ?? '',
  'value' => $_SESSION['step2']['promo_value'] ?? 0,
  'promo_id' => $_SESSION['step2']['promo_id'] ?? null,
  'error' => $_SESSION['step2']['promo_error'] ?? ''
]) ?>;

// Pass add-ons data to JavaScript
window.addons = <?= json_encode($_SESSION['step2']['addons'] ?? []) ?>;
</script>

<script src="step2.js" defer></script>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Step 2 - Choose Plan</title>
  <?php include('link.php'); ?>

  <!-- Pass PHP prices & promo info to JS -->
  <script>
    window.prices = <?= json_encode($prices) ?>;
    window.promoInfo = <?= json_encode([
        'code' => $_SESSION['step2']['promo'] ?? '',
        'type' => $_SESSION['step2']['promo_type'] ?? '',
        'value' => $_SESSION['step2']['promo_value'] ?? 0,
        'promo_id' => $_SESSION['step2']['promo_id'] ?? null,
        'error' => $_SESSION['step2']['promo_error'] ?? ''
    ]) ?>;
  </script>
 
  <style>
    .price-breakdown { border: 1px solid #eee; padding: 15px; margin-bottom: 20px; border-radius: 8px; background-color: #f9f9f9; }
    .price-breakdown h4 { margin-top: 0; color: #333; border-bottom: 1px solid #ddd; padding-bottom: 10px; }
    .price-breakdown ul { list-style: none; padding: 0; margin: 0; }
    .price-breakdown li { display: flex; justify-content: space-between; padding: 5px 0; font-size: 15px; }
    .price-breakdown li span { color: #555; }
    input[type="radio"]:disabled + label { color: #999; }
    input[type="radio"]:disabled ~ div label { color: #999; }
    .promo-error { color: red; font-size: 13px; margin-top: 5px; }
  </style>
</head>
<body>
<?php include('header.php'); ?> 

<section class="step-section steplicence">
  <div class="step-header">
    <h1>Apply for International Driving License</h1>
    <p>Most accepted at the global level & trusted by travellers all around the world</p>
  </div>
  <div class="step-progress">
    <div class="step"><span class="number">01</span><span class="label">Applicant's Details</span></div>
    <div class="step active"><span class="number">02</span><span class="label">Choose Plan</span></div>
    <div class="step"><span class="number">03</span><span class="label">Add Document</span></div>
    <div class="step"><span class="number">04</span><span class="label">Review</span></div>
    <div class="step"><span class="number">05</span><span class="label">Payment</span></div>
  </div>
</section>

<div class="licenceform">
  <div class="container">
    <div class="main-form-container">
      <div class="form-container">
        <h2>Choose Plan</h2>
        <form method="post" action="step2.php">

          <div class="formfield">
            <label class="softhard-copy">
              <div class="span-soft">
                <input type="radio" name="plan" value="Soft Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan']==='Soft Copy') ? 'checked' : '' ?> checked>
                <img src="/dhl/admin/uploads/<?= htmlspecialchars($prices['soft_copy_file']) ?>" alt="Soft Copy" width="100">
              </div>
              <div><b>Soft Copy</b><br><small>Email delivery</small></div>
            </label>

            <label class="softhard-copy">
              <div class="span-soft">
                <input type="radio" name="plan" value="Hard Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan']==='Hard Copy') ? 'checked' : '' ?>>
                <img src="/dhl/admin/uploads/<?= htmlspecialchars($prices['hard_copy_file']) ?>" alt="Hard Copy" width="100">
              </div>
              <div><b>Hard Copy</b><br><small>Home delivery</small></div>
            </label>
          </div>

          <div class="type_label">
            <label class="pillbtn">Type *</label>
          </div>
          <label class='type_label'>
            <input type="radio" name="type" value="Normal" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type']==='Normal') ? 'checked' : '' ?> checked>Normal
          </label>
          <label class='type_label'>
            <input type="radio" id="urgentRadio" name="type" value="Urgent" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type']==='Urgent') ? 'checked' : '' ?>>Urgent
          </label>
          <br><br>

          <label>Where your license was issued *</label>
          <select id="license_issue_label" name="license_country" required>
            <option value="">Select Country</option>
          </select><br><br>

          <label>Where do you intend to drive? *</label>
          <select id="drive_country" name="drive_country" required>
            <option value="">Select Country</option>
          </select><br><br>

          <div class="pillbtn-wrap">
            <label class="pillbtn">Classes of Driving License *</label>
            <?php
            $classesMap = [
                'A. Motorcycle' => 'Vector.svg',
                'B. Passenger car' => 'Vector-1.svg',
                'C. Vehicle over 7,000 Pound' => '7000.svg',
                'D. Vehicle over 10 seats' => 'Vector-2.svg',
                'E. B.C, or Class vehicle with trailer' => 'veh.svg',
            ];
            foreach ($classesMap as $label => $icon) {
                $checked = (isset($_SESSION['step2']['license_class']) && in_array($label, $_SESSION['step2']['license_class'] ?? [])) ? 'checked' : '';
                echo "<label><input type='checkbox' name='license_class[]' value='$label' $checked> <img src='assets/images/$icon' alt='$label'> $label</label>";
            }
            ?>
          </div><br>

          <div class="productcard">
            <label>Products</label>
            <div class="productcard-wrap">
              <label class="softhard-copy">
                <input type="radio" name="productbooklet" value="Booklet" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet']==='Booklet') ? 'checked' : 'checked' ?>>
                <img src="assets/card.png" height="200px" alt="Booklet">
                <div><b>Booklet</b></div>
              </label>

              <label class="softhard-copy">
                <input type="radio" name="productbooklet" value="Booklet + Card" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet']==='Booklet + Card') ? 'checked' : '' ?>>
                <img src="assets/slide.png" height="200px" alt="Booklet + Card">
                <div><b>Booklet + Card</b></div>
              </label>
            </div>
          </div>

          <div id="validitySection" class="productcard-validity">
                <label>Validity</label>
                <select id="validity" name="validity" required=""></select>
              </div><br>
              
              <div id="addonsSection">
                <label>Add-ons</label>
                <div id="addonsContainer" class="add-ons"></div>
              </div>

          <div class="mt-2 mb-4">
            <label>Apply Promo Code</label><br>
            <input type="text" name="promo" placeholder="Promo code" value="<?= htmlspecialchars($_SESSION['step2']['promo'] ?? '') ?>">
            <div id="promoError" class="promo-error"><?= htmlspecialchars($_SESSION['step2']['promo_error'] ?? '') ?></div>
          </div>

          <div class="price-breakdown">
            <h4>Price Summary</h4>
            <ul>
              <li style="display:none"><span>Copy Type (Soft/Hard):</span> <strong id="breakdown-copy-price">£0.00</strong></li>
              <li><span>Processing Type (Urgent):</span> <strong id="breakdown-type-price">£0.00</strong></li>
              <li style="display:none"><span>Classes of Driving License:</span> <strong id="breakdown-license-classes-price">£0.00</strong></li>
              <li style="display:none"><span>Product Booklet/Card:</span> <strong id="breakdown-product-price">£0.00</strong></li>
              <li><span>Validity:</span> <strong id="breakdown-validity-price">£0.00</strong></li>
              <li><span>Add-ons:</span> <strong id="breakdown-addons-price">£0.00</strong></li>
              <li><span>Discount:</span> <strong id="breakdown-discount">£0.00</strong></li>
            </ul>
            <div style="text-align: right; font-size: 22px; font-weight: bold; border-top: 2px solid #333; padding-top: 10px;">
              Total: <strong id="totalAmount">£0.00</strong>
            </div>
            <input type="hidden" id="totalInput" name="total" value="0">
          </div>

          <div class="back-continue-button-wrap">
            <a href="index.php"><button type="button" class="first-btn-cicle">Back</button></a>
            <button type="submit" name="step2_submit" class="btn secondary-btn-circle">Verify & Continue</button>
          </div>
        </form>
      </div>

      <div class="global-container">
        <?php include('stats-card.php'); ?>
      </div>
    </div>
  </div>
</div>

<?php include('footer.php'); ?>
<?php include('footerscript.php'); ?>
</body>
</html>
