<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include 'session.php';
include 'db.php';

// Generate order ID if not exists
if (!isset($_SESSION['order_id'])) {
    $_SESSION['order_id'] = 'GRN' . rand(100000, 999999);
}
$order_id = $_SESSION['order_id'];

// Ensure previous steps are completed
foreach (['step1', 'step2', 'step3'] as $step) {
    if (!isset($_SESSION[$step])) {
        header("Location: {$step}.php");
        exit;
    }
}
 

// Load steps data from session for display
$step1 = $_SESSION['step1'] ?? [];
$step2 = $_SESSION['step2'] ?? [];
$step3 = $_SESSION['step3'] ?? [];
$step4 = $_SESSION['step4'] ?? [];

$plan = $step2['plan'] ?? 'Soft Copy';

// Applicant details
$full_name       = $step1['full_name'] ?? '';
$dob             = $step1['dob'] ?? '';
$gender          = $step1['gender'] ?? '';
$email           = $step1['email'] ?? '';
$phone           = $step1['phone'] ?? '';
$nationality     = $step1['nationality'] ?? '';
$license_number  = $step1['license_number'] ?? '';
$birth_place     = $step1['birth_place'] ?? '';
$permanent_place = $step1['permanent_place'] ?? '';
$street          = $step1['street'] ?? ''; 
$state           = $step1['state'] ?? ''; 
$city            = $step1['city'] ?? ''; 

// Assigning permanent address details
$perm_street = $street;
$perm_state  = $state;
$perm_city   = $city;


// Plan & License
$type            = $step2['type'] ?? '';
$license_country = $step2['license_country'] ?? '';
$drive_country   = $step2['drive_country'] ?? '';
$license_class_arr = $step2['license_class'] ?? [];
$license_class_str = !empty($license_class_arr) ? implode(',', $license_class_arr) : '';
$addons_arr      = $step2['addons'] ?? [];
$addons_str      = !empty($addons_arr) ? implode(',', $addons_arr) : '';
$promo           = $step2['promo'] ?? '';
$product         = $step2['productbooklet'] ?? '';
$validity        = $step2['validity'] ?? '1 year';

// Uploaded documents
$passport_photo  = $step3['passport_photo'] ?? '';
$license_front   = $step3['license_front'] ?? '';
$license_back    = $step3['license_back'] ?? '';


// Shipping details - Load these based on step4 session data
if ($plan === 'Hard Copy') {
    // Reverted to original session keys for city, state, zip loading
    $ship_fname   = $step4['first_name'] ?? '';
    $ship_lname   = $step4['last_name'] ?? '';
    $ship_house   = $step4['ship_house'] ?? '';
    $ship_street  = $step4['ship_street'] ?? '';
    $ship_city    = $step4['city'] ?? '';       // Loaded from 'city' key
    $ship_state   = $step4['state'] ?? '';      // Loaded from 'state' key
    $ship_zip     = $step4['zip'] ?? '';        // Loaded from 'zip' key
    $ship_country = $step4['country_code'] ?? '';
    $shippingPrice = floatval($_SESSION['shipping_rate'] ?? 0);
} else {
    // Default values if not hard copy
    $ship_fname = $ship_lname = $ship_house = $ship_street = $ship_city = $ship_state = $ship_zip = $ship_country = '';
    $shippingPrice = 0;
}

// Product and total price
$productPrice = floatval($_SESSION['step2']['product_price'] ?? $_SESSION['step2']['total'] ?? 0);
$total = ($plan === 'Hard Copy') ? floatval($_SESSION['total_price'] ?? ($productPrice + $shippingPrice)) : $productPrice;


// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $copy_type = '';
    if ($plan === 'Hard Copy') {
        $copy_type = 'Physical';
    } elseif ($plan === 'Soft Copy') {
        $copy_type = 'Digital';
    }

    $product_price   = $productPrice;
    $total_price     = $total;

    if ($plan === 'Hard Copy') {
        $shipping_price = $shippingPrice;
    } else {
        $shipping_price = 0;
    }
 
    
    // Prepare the INSERT statement
    $stmt = $conn->prepare("
        INSERT INTO applications (
            order_id, full_name, dob, gender, email, phone, nationality,
            perm_state, perm_street, perm_city,
            license_number, plan, copy_type, type, license_country, drive_country,
            license_class, addons, promo,
            passport_photo, license_front, license_back,
            ship_fname, ship_lname, ship_house,
            street, state, zip, city, country, -- These columns refer to shipping address for Hard Copy
            product, validity, shipping_price, total_price
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?,
            ?, ?, ?,
            ?, ?, ?, ?, ?, ?,
            ?, ?, ?,
            ?, ?, ?,
            ?, ?, ?,
            ?, ?, ?, ?, ?,
            ?, ?, ?, ?
        )
    ");


    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    // Bind parameters. Corrected type string and variable mapping for shipping address.
    $stmt->bind_param(
        "ssssssssssssssssssssssssssssssssdd", // 32 's' for strings, 2 'd' for doubles
        $order_id, $full_name, $dob, $gender, $email, $phone, $nationality, // Applicant details (7)
        $perm_state, $perm_street, $perm_city, // Applicant's permanent address (3)
        $license_number, $plan, $copy_type, $type, $license_country, $drive_country, // Plan & License (6)
        $license_class_str, $addons_str, $promo, // Addons & Promo (3)
        $passport_photo, $license_front, $license_back, // Uploaded Documents (3)
        $ship_fname, $ship_lname, $ship_house, // Shipping recipient name & house (3)
        $ship_street, $ship_state, $ship_zip, $ship_city, $ship_country, // Shipping address (maps to DB columns: street, state, zip, city, country) (5)
        $product, $validity, $shipping_price, $total_price // Product & Pricing (4)
    );


    if ($stmt->execute()) {
        header("Location: thankyou.php");
        exit;
    } else {
        echo "Error: " . $stmt->error;
    }
}


?>





	<!DOCTYPE html>
	<html>

	<head>
	  <title>Step 5 - Review Details</title>
	  <meta name="viewport" content="width=device-width, initial-scale=1.0">

	  <?php include('link.php'); ?>

	  <style>
		.section {
			margin-bottom: 25px;
			padding: 15px;
			background-color: #f9f9f9;
			border: 1px solid #e0e0e0;
			border-radius: 8px;
		}
		.section h4 {
			margin-top: 0;
			color: #333;
			border-bottom: 2px solid #eee;
			padding-bottom: 5px;
			margin-bottom: 15px;
		}
		.section .value {
			margin-bottom: 12px;
			font-size: 15px;
			line-height: 1.5;
			color: #555;
		}
		.section .value .label {
			font-weight: bold;
			color: #222;
			margin-right: 8px;
			display: inline-block;
			min-width: 180px;
		}

		.uploaded-images img, .uploaded img {
			max-width: 100px;
			height: auto;
			border: 1px solid #ccc;
			border-radius: 4px;
			margin-top: 5px;
			margin-right: 10px;
			vertical-align: top;
		}
		.uploaded-images .value {
			display: flex;
			flex-direction: column;
		}
		.uploaded-images .label {
			 min-width: auto;
			 margin-bottom: 5px;
		}

		.suggestion-box {
		  margin-top: 30px;
		  padding: 20px;
		  background-color: #e0f7fa;
		  border-radius: 8px;
		  border-left: 5px solid #00bcd4;
		  text-align: center;
		}
		.suggestion-box img { margin-bottom: 15px; }
		.suggestion-box p { font-size: 16px; color: #333; margin-bottom: 20px; }
		.suggestion-box a {
		  display: inline-block;
		  padding: 12px 25px;
		  background-color: #007BFF;
		  color: white;
		  text-decoration: none;
		  border-radius: 5px;
		  font-weight: bold;
		  transition: background-color 0.3s ease;
		}
		.suggestion-box a:hover { background-color: #0056b3; }

		.stats-card.marg {
			margin-top: 20px;
			padding: 15px;
			font-size: 12px !important;
		}
		.stats-card.marg .uploaded {
			position: relative;
			text-align: left;
		}
	
 

		.review .value span.label { min-width: 150px; }
		.review .uploaded-images img { max-width: 120px; margin-right: 15px; }
		.review .uploaded-images .value { margin-bottom: 15px; }

		.order-summary-shipping-price {
			font-size: 15px;
			line-height: 1.5;
			color: #555;
			margin-bottom: 12px;
		}
		.order-summary-shipping-price .label {
			font-weight: bold;
			color: #222;
			margin-right: 8px;
			display: inline-block;
			min-width: 180px;
		}
	  </style>
	</head>

	<body>
	  <?php include('header.php'); ?>

	  <section class="step-section steplicence">
		<div class="step-header">
		  <h1>Apply for International Driving License</h1>
		  <p>Most accepted at the global level & trusted by travellers all around the world</p>
		</div>

		<div class="step-progress">
		  <div class="step ">
			<span class="number">01</span>
			<span class="label">Applicant’s Details</span>
		  </div>
		  <div class="step ">
			<span class="number">02</span>
			<span class="label">Choose Plan</span>
		  </div>
		  <div class="step ">
			<span class="number">03</span>
			<span class="label">Add Document</span>
		  </div>
		  <div class="step ">
			<span class="number">04</span>
			<span class="label">Shipping</span>
		  </div>
		  <div class="step active">
			<span class="number">05</span>
			<span class="label">Review</span>
		  </div>
		  <div class="step">
			<span class="number">06</span>
			<span class="label">Payment</span>
		  </div>
		</div>
	  </section>

	  <div class="licenceform">
		<div class="container">
		  <div class="main-form-container">
			<div class="form-container review">

			  <h2>Review Details</h2>
			  <p>Please confirm the information you entered before submitting.</p>

			  <div class="section">
				<h4>Applicant’s Details</h4>
				
				
				
				<div class="value"><span class="label">Full Name:</span> <?= htmlspecialchars($full_name) ?></div>
				<div class="value"><span class="label">Date of Birth:</span> <?= htmlspecialchars($dob) ?></div>
				<div class="value"><span class="label">Gender:</span> <?= htmlspecialchars($gender) ?></div>
				<div class="value"><span class="label">Email:</span> <?= htmlspecialchars($email) ?></div>
				<div class="value"><span class="label">Phone:</span> <?= htmlspecialchars($phone) ?></div>
				<div class="value"><span class="label">Nationality:</span> <?= htmlspecialchars($nationality) ?></div>
				<div class="value"><span class="label">License Number:</span> <?= htmlspecialchars($license_number) ?></div>
				<div class="value"><span class="label">Country of License:</span> <?= htmlspecialchars($license_country) ?></div>
				<div class="value"><span class="label">Permanent Place of Residence:</span> <?= htmlspecialchars($birth_place) ?></div>
				<div class="value"><span class="label">Street:</span> <?= htmlspecialchars($street) ?></div>
				<div class="value"><span class="label">State:</span> <?= htmlspecialchars($state) ?></div>
				<div class="value"><span class="label">City:</span> <?= htmlspecialchars($city) ?></div>
                 </div> 
			  <div class="section">
				<h4>Choose Plan</h4>
				<div class="value"><span class="label">Plan:</span> <?= htmlspecialchars($plan) ?></div>
				<div class="value"><span class="label">Type:</span> <?= htmlspecialchars($type) ?></div>
				<div class="value"><span class="label">Country of License Issuance:</span> <?= htmlspecialchars($license_country) ?></div>
				<div class="value"><span class="label">Intended Country to Drive:</span> <?= htmlspecialchars($drive_country) ?></div>

				<div class="value"><span class="label">License Classes:</span>
				  <?php
				  // Assuming $classesLabels and $iconsPath are defined elsewhere in your project or included files
				  // If not, you'll need to define them. For this example, they are used but not defined here.
				  // Example: $classesLabels = ['A' => 'Motorcycle', 'B' => 'Car']; $icons = ['A' => 'motorcycle.png']; $iconsPath = '/path/to/icons/';
				  if (!empty($license_class_arr)) {
					  $displayedClasses = [];
					  foreach ($license_class_arr as $cls) {
						  // Use placeholder values if $classesLabels, $icons, $iconsPath are not available
						  $label = isset($classesLabels[$cls]) ? $classesLabels[$cls] : $cls;
						  $iconFile = $icons[$cls] ?? '';
						  $iconHtml = '';
						  // Check if iconsPath is defined and file exists
						  if (isset($iconsPath) && $iconFile && file_exists($iconsPath . $iconFile)) {
							  $iconHtml = '<img src="' . htmlspecialchars($iconsPath . $iconFile) . '" alt="' . htmlspecialchars($label) . '" style="width: 24px; height: 24px; vertical-align: middle; margin-right: 5px;">';
						  }
						  $displayedClasses[] = $iconHtml . htmlspecialchars($label);
					  }
					  echo implode(' | ', $displayedClasses);
				  } else {
					  echo "N/A";
				  }
				  ?>
				</div>

		<div class="value"><span class="label">Add-ons:</span>
<?php
if (!empty($addons_arr)) {
    $addon_ids = array_map('intval', $addons_arr);
    $ids_str = implode(',', $addon_ids);

    $result = $conn->query("SELECT * FROM `addon_products` WHERE id IN ($ids_str)");

    if ($result && $result->num_rows > 0) {
        echo '<ul style="list-style: none; padding-left: 0;">';
        while ($row = $result->fetch_assoc()) {
            $image = !empty($row['soft_image']) ? $row['soft_image'] : $row['hard_image'];
            $imageHtml = $image ? '<img src="admin/uploads/' . htmlspecialchars($image) . '" alt="" style="width:50px;height:auto;margin-right:10px;vertical-align:middle;">' : '';

            // Conditional name based on plan
            if ($plan === 'Soft Copy' && !empty($row['addon_soft_product_name'])) {
                $addon_name = $row['addon_soft_product_name'];
            } else {
                $addon_name = $row['name'];
            }
            $name = htmlspecialchars($addon_name);

            // Conditional price based on plan
            if ($plan === 'Soft Copy') {
                if (!empty($row['addon_soft_booklet_card_price'])) {
                    $price = $row['addon_soft_booklet_card_price'];
                } elseif (!empty($row['addon_soft_booklet_only_price'])) {
                    $price = $row['addon_soft_booklet_only_price'];
                } else {
                    $price = 0;
                }
            } else { // Hard Copy
                if (!empty($row['addon_hard_booklet_card_price'])) {
                    $price = $row['addon_hard_booklet_card_price'];
                } elseif (!empty($row['addon_hard_booklet_only_price'])) {
                    $price = $row['addon_hard_booklet_only_price'];
                } else {
                    $price = 0;
                }
            }
            $price = number_format((float)$price, 2);

            echo '<li style="margin-bottom:10px;">' . $imageHtml . $name . ' - $' . $price . '</li>';
        }
        echo '</ul>';
    } else {
        echo 'None';
    }
} else {
    echo 'None';
}
?>
</div>


				<div class="value"><span class="label">Promo Code:</span> <?= htmlspecialchars($promo) ?></div>
				<div class="value"><span class="label">Product:</span> <?= htmlspecialchars($product) ?></div>
				<div class="value"><span class="label">Validity:</span> <?= htmlspecialchars($validity) ?></div>
			  
			  <div class="section uploaded-images-wrap">
				<h4>Uploaded Documents</h4>
				<div class="uploaded-images">
				  <div class="value">
					<span class="label">Passport Photo:</span>
					<?php if (!empty($passport_photo) && file_exists('uploads/' . $passport_photo)): ?>
					  <img src="uploads/<?= htmlspecialchars($passport_photo) ?>" alt="Passport Photo">
					<?php else: ?>
					  N/A
					<?php endif; ?>
				  </div>
				  <div class="value">
					<span class="label">License Front:</span>
					<?php if (!empty($license_front) && file_exists('uploads/' . $license_front)): ?>
					  <img src="uploads/<?= htmlspecialchars($license_front) ?>" alt="License Front">
					<?php else: ?>
					  N/A
					<?php endif; ?>
				  </div>
				  <div class="value">
					<span class="label">License Back:</span>
					<?php if (!empty($license_back) && file_exists('uploads/' . $license_back)): ?>
					  <img src="uploads/<?= htmlspecialchars($license_back) ?>" alt="License Back">
					<?php else: ?>
					  N/A
					<?php endif; ?>
				  </div>
				</div>
			  </div>
			  
			  <div class="section" style="display:none">
				<h4>Tracking ID</h4>
				<div class="value">
					<span class="label">Order ID:</span>
					<span class="order-id">
                        <?= htmlspecialchars($order_id) ?>
                    </span>
				</div>
			</div>
        
        			 <!-- Shipping Address: show only for Hard Copy -->
                <?php if ($plan === 'Hard Copy'): ?>
                <div class="section"> 
                    <h4>Shipping Address</h4>
                    <div class="value"><span class="label">Recipient Name:</span> <?= htmlspecialchars($ship_fname . ' ' . $ship_lname) ?></div>
                    <div class="value"><span class="label">House/Flat/Block No.:</span> <?= htmlspecialchars($ship_house) ?></div>
                    <div class="value"><span class="label">Street/Area:</span> <?= htmlspecialchars($ship_street) ?></div>
                    <div class="value"><span class="label">City:</span> <?= htmlspecialchars($ship_city) ?></div>
                    <div class="value"><span class="label">State/Region/Province:</span> <?= htmlspecialchars($ship_state) ?></div>
                    <div class="value"><span class="label">ZIP/Postal Code:</span> <?= htmlspecialchars($ship_zip) ?></div>
                    <div class="value"><span class="label">Country:</span> <?= htmlspecialchars($ship_country) ?></div>
                </div>
                <?php endif; ?>
                
               
                
                <!-- Order Summary -->
                <div class="section">
                    <h4>Order Summary</h4>
                    <div class="order-summary-shipping-price">
                        <span class="label">Product Price:</span> £<?= number_format($productPrice, 2) ?>
                    </div>
                    <?php if ($plan === 'Hard Copy'): ?>
                        <div class="order-summary-shipping-price">
                            <span class="label">Shipping Price:</span> £<?= number_format($shippingPrice, 2) ?>
                        </div>
                    <?php endif; ?>
                    <div class="order-summary-shipping-price">
                        <strong><span class="label">Total Amount:</span> £<?= number_format($total, 2) ?></strong>
                    </div>
                </div>


			  <form method="post" action="">
				<div class="back-continue-button-wrap">
				  <button type="button" class="first-btn-cicle" onclick="window.location.href='step4.php'">Back</button>

				  <input type="hidden" name="product_price_hidden" value="<?= number_format($productPrice, 2, '.', '') ?>">
				  <input type="hidden" name="shipping_price_hidden" value="<?= number_format($shippingPrice, 2, '.', '') ?>">
				  <input type="hidden" name="total_price_hidden" value="<?= number_format($total, 2, '.', '') ?>">

				  <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
				</div>
			  </form>

			</div>
 </div>
			<div class="global-container">
			  <?php include('stats-card.php'); ?>

			  <?php if (($step2['productbooklet'] ?? '') === 'Booklet') : ?>
				<div class="suggestion-box">
				  <img src="assets/slide.png" alt="Upgrade offer" width="70%">
				  <p>Want more value? Switch to our premium <strong>Booklet + Card</strong> combo for a complete experience!</p>
				  <a href="step2.php?upgrade=booklet">Upgrade Your Product</a>
				</div>
			  <?php endif; ?>

			  <div class="stats-card marg uploaded-images-wrap name_flex">
				<h4>Uploaded Documents</h4>
				<div class="uploaded">
				    
				<div class="user_data_flex">
				  <div class="username"><?= htmlspecialchars($step1['full_name'] ?? '') ?></div>
				  
				  <div class="username2"><?= htmlspecialchars($step1['nationality'] ?? '') ?></div>
				  
				  <div class="username3"><?= htmlspecialchars($step1['dob'] ?? '') ?></div>
				  </div>
				  
				  
				  <div class="user_image_box">
				  <?php if (!empty($passport_photo) && file_exists('uploads/' . $passport_photo)): ?>
					<img src="uploads/<?= htmlspecialchars($passport_photo) ?>" alt="Passport Photo Preview">
				  <?php endif; ?>
				  
				  <img src="certificate.jpg" alt="Sample Certificate" width="100%">
				  </div>
				</div>
			  </div>

			
			  
			  
			</div>
		  </div>
		</div>
	  </div>
</div>
</div>
	  <?php include('footer.php'); ?>
	  <?php include('footerscript.php'); ?>

	  <script>
		document.addEventListener("DOMContentLoaded", function () {
			const productPriceValue = parseFloat("<?= $productPrice ?>") || 0;
			let shippingPriceValue = parseFloat("<?= $shippingPrice ?>") || 0;

			const shippingInput = document.querySelector('input[name="shipping_price_hidden"]');
			const totalInput = document.querySelector('input[name="total_price_hidden"]');

			if (shippingInput) shippingInput.value = shippingPriceValue.toFixed(2);
			if (totalInput) totalInput.value = (productPriceValue + shippingPriceValue).toFixed(2);
		});
	  </script>
	</body>
	</html>