<?php
include 'session.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // File names only for preview, actual file save will be handled separately
    $_SESSION['step3'] = [
        'passport_photo' => $_FILES['passport_photo']['name'],
        'license_front' => $_FILES['license_front']['name'],
        'license_back' => $_FILES['license_back']['name']
    ];
    // Move files (for actual saving, make sure /uploads/ exists and is writable)
    move_uploaded_file($_FILES['passport_photo']['tmp_name'], 'uploads/' . $_FILES['passport_photo']['name']);
    move_uploaded_file($_FILES['license_front']['tmp_name'], 'uploads/' . $_FILES['license_front']['name']);
    move_uploaded_file($_FILES['license_back']['tmp_name'], 'uploads/' . $_FILES['license_back']['name']);

    header('Location: step4.php');
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Step 3 - Upload Document</title>

    
<link rel="stylesheet" href="styles.css">
</head>
<body>


<div class="topbar">
    <div class="topbar-left">
      UN Convention Approved | Urgent 15 -30 Mins Processing (Business Hours Only) | Recognized worldwide | No Test Required
    </div>
    <div class="topbar-right">
      <img src="https://flagcdn.com/gb.svg" alt="UK Flag" class="flag-icon">
      <span>English</span>
      <span class="arrow">&#9662;</span>
    </div>
  </div>

  <header class="navbar">
    <div class="navbar-container">
      <div class="logo">
        <img src="logo.png" alt="ITCA Logo">
      </div>

      <button class="hamburger" id="hamburger">
        ☰
      </button>

      <nav class="nav-links" id="navLinks">
        <a href="#">Home</a>
        <a href="#">Shipping & Fees</a>
        <a href="#">Countries</a>
        <a href="#">About</a>
        <a href="#">Contact Us</a>
        <a href="#">FAQ</a>
        <a href="#">Travel Guides</a>
        <div class="nav-buttons-mobile disable">
          <a href="#" class="btn orange">Get 20% Off</a>
          <a href="#" class="btn blue">Get Your IDP - €39</a>
        </div>
      </nav>

      <div class="nav-buttons desktop-only">
        <a href="#" class="btn orange">Get 20% Off</a>
        <a href="#" class="btn blue">Get Your IDP - €39</a>
      </div>
    </div>
  </header>
  <section class="step-section">
  <div class="step-header">
    <h1>Apply for International Driving License</h1>
    <p>Most accepted at the global level & trusted by travellers all around the world</p>
  </div>

  <div class="step-progress">
    <div class="step active">
      <span class="number">01</span>
      <span class="label">Applicant’s Details</span>
    </div>
    <div class="step">
      <span class="number">02</span>
      <span class="label">Choose Plan</span>
    </div>
    <div class="step">
      <span class="number">03</span>
      <span class="label">Add Document</span>
    </div>
    <div class="step">
      <span class="number">04</span>
      <span class="label">Shipping</span>
    </div>
    <div class="step">
      <span class="number">05</span>
      <span class="label">Review</span>
    </div>
    <div class="step">
      <span class="number">06</span>
      <span class="label">Payment</span>
    </div>
  </div>
</section>
<div class="container-fluid">
    <h2>Upload Document</h2>
    <p>Please upload the document. These are required for verification of your application.</p>
    <form method="post" action="" enctype="multipart/form-data">

        <!-- Passport Photo -->
        <label><strong>01. Passport Size Photo *</strong></label><br>
        <div style="border: 1px dashed #ccc; padding: 20px; border-radius: 8px; text-align: center;">
            <img src="assets/img/avatar-placeholder.png" width="80"><br><br>
            <input type="file" name="passport_photo" required>
            <p><a href="#">Check photo guideline</a></p>
        </div>
        <br>

        <!-- Driving License -->
        <label><strong>02. Driving License *</strong></label><br>
        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
            <div style="flex: 1; border: 1px dashed #ccc; padding: 20px; border-radius: 8px; text-align: center;">
                <p>Front side</p>
                <img src="assets/img/license-front.png" width="100"><br><br>
                <input type="file" name="license_front" required>
            </div>
            <div style="flex: 1; border: 1px dashed #ccc; padding: 20px; border-radius: 8px; text-align: center;">
                <p>Back side</p>
                <img src="assets/img/license-back.png" width="100"><br><br>
                <input type="file" name="license_back" required>
            </div>
        </div>
        <br>

        <!-- Buttons -->
        <div style="display: flex; justify-content: space-between;">
            <a href="step2.php"><button type="button" style="background:#00264d;">⬅ Back</button></a>
            <button type="submit">Save & Continue ➜</button>
        </div>
    </form>
</div>

<footer class="footer">
  <div class="footer-container">
    <div class="footer-top">
      <div class="footer-brand">
        <img src="https://i.ibb.co/3rgXfnf/itca-logo.png" alt="ITCA Logo">
        <p>Specialized in Translating Driver's Licenses</p>
        <p><span class="footer-icon">✉️</span> Email: support@e-itca.org</p>
      </div>

      <div class="footer-contact">
        <h4>CONTACT</h4>
        <ul>
          <li><img src="https://flagcdn.com/in.svg" alt=""> India: +91 98676 22637</li>
          <li><img src="https://flagcdn.com/us.svg" alt=""> USA: +1-587-288-3761</li>
          <li><img src="https://flagcdn.com/my.svg" alt=""> Malaysia: +60 102225401</li>
          <li><img src="https://flagcdn.com/tr.svg" alt=""> Turkey: +90 5385437764</li>
          <li><img src="https://flagcdn.com/mt.svg" alt=""> Malta: +356 9959 2634</li>
          <li><img src="https://flagcdn.com/fr.svg" alt=""> France: +33 758738498</li>
          <li><img src="https://flagcdn.com/ca.svg" alt=""> Canada: +1-587-288-3761</li>
        </ul>
        <div class="social-icons">
          <a href="#"><i>🌐</i></a>
          <a href="#"><i>📸</i></a>
          <a href="#"><i>💬</i></a>
          <a href="#"><i>🕊️</i></a>
          <a href="#"><i>▶️</i></a>
        </div>
      </div>

      <div class="footer-agents">
        <h4>AGENTS</h4>
        <ul>
          <li>USA</li>
          <li>Australia</li>
          <li>Canada</li>
          <li>Turkey</li>
          <li>Bulgaria</li>
          <li>UAE</li>
          <li>Chile</li>
          <li>Lithuania</li>
          <li>Thailand</li>
          <li>Russia</li>
          <li>India</li>
          <li>Italy</li>
        </ul>
      </div>

      <div class="footer-affiliates">
        <h4>OUR AFFILIATES</h4>
        <div class="affiliate-logos">
          <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Visa.svg" alt="Visa">
          <img src="https://upload.wikimedia.org/wikipedia/commons/b/b5/MasterCard_Logo.svg" alt="MasterCard">
          <img src="https://upload.wikimedia.org/wikipedia/commons/3/39/Paypal_logo.svg" alt="PayPal">
          <img src="https://1000logos.net/wp-content/uploads/2021/04/UPS-logo.png" alt="UPS">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1d/DHL_Logo.svg/2560px-DHL_Logo.svg.png" alt="DHL">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Hertz-Logo.png" alt="Hertz">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Alamo_Rent_A_Car_logo.svg/1280px-Alamo_Rent_A_Car_logo.svg.png" alt="Alamo">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Avis-logo.png" alt="Avis">
        </div>
        <div class="qr-section">
          <img src="https://i.ibb.co/fN8h6Lh/qr.png" alt="QR Code">
          <p>📱 SCAN TO CHAT</p>
        </div>
      </div>
    </div>

    <div class="footer-bottom">
      <p class="disclaimer">
        <strong>Disclaimer:</strong> International Driving Permit issued by ITCA is a translation of your driver’s license into 15 languages and we make no claim to be a government agency. An International Driving Permit is not a replacement for a driving license.
        The association issues the IDP based on the international united design of the UN Convention 1968 or 1949 to prevent any illegal situation while you are driving abroad.
      </p>
      <div class="footer-links">
        <a href="#">Terms of Use</a> |
        <a href="#">Privacy Policy</a> |
        <a href="#">Refund Policy</a> |
        <a href="#">Legal Notice</a>
      </div>
      <p>©2022 by ITCA - VAT NO 7690748865</p>
    </div>
  </div>
</footer>


<script>
  // Hamburger Toggle
  document.addEventListener('DOMContentLoaded', function () {
    const hamburger = document.querySelector('.hamburger');
    const navLinks = document.querySelector('.nav-links');

    if (hamburger && navLinks) {
      hamburger.addEventListener('click', function () {
        navLinks.classList.toggle('active');
      });
    }
  });
</script>

</body>
</html>
