<?php
session_start();
include '../db.php';  // Database connection

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}


$userId = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$userResult = $stmt->get_result();
$user = $userResult->fetch_assoc();

// Helper to show images safely
function showImage($file) {
    if (!empty($file) && file_exists("../uploads/$file")) {
        return "<img src='../uploads/$file' width='50'>";
    }
    return "<span class='text-danger'>Missing</span>";
}

// Fetch applications
$sql = "SELECT * FROM applications ORDER BY created_at DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Itca Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .circle-name { 
            width: 40px; height: 40px; 
            border-radius: 50%; background: #007bff; 
            color: #fff; text-align: center; line-height: 40px; 
            font-weight: bold; margin-right: 10px;
        }
        .table-style img { max-height: 50px; }
    </style>
</head>
<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
        <div class="menu_link">
            <ul>
                <li><a href="index.php" class="active">Permit Request</a></li>
                <li><a href="shipping_price.php">Shipping Price</a></li>
                <li><a href="profile.php">Profile Setting</a></li>
                <li><a href="logout.php">Log Out</a></li>
            </ul>
        </div>
    </div>

        <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button">
                <button class="btn toggle_btn" type="button"></button>
            </div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?php echo strtoupper(substr($user['full_name'], 0, 2)); ?></span>
                    <div class="user_name"><h4><?php echo htmlspecialchars($user['full_name']); ?></h4></div>
                </div>
            </div>
         
 </div>

        <div class="body_wrapper_section p-3">
            <h3>Permit Request(s)</h3>
            <div class="table-wrapper inner-wrapper">
                <table id="myTable" class="display table table-bordered table-striped table-style">
                    <thead>
                        <tr>
                            <th>ID</th><th>Full Name</th><th>DOB</th><th>Gender</th><th>Email</th>
                            <th>Phone</th><th>Nationality</th><th>License Number</th><th>Plan</th>
                            <th>Type</th><th>License Country</th><th>Drive Country</th><th>License Class</th>
                            <th>Addons</th><th>Promo</th><th>Passport</th><th>License Front</th><th>License Back</th>
                            <th>Ship First</th><th>Ship Last</th><th>Street</th><th>State</th>
                            <th>ZIP</th><th>City</th><th>Country</th><th>Created At</th>
                            <th>Product</th><th>Validity</th><th>Tracking ID:</th><th>Prices</th><th>Action</th><th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $licenseClassHtml = str_replace('src="assets/', 'src="../assets/', $row['license_class']);
                                $licenseClassHtml = str_replace('Â', '', $licenseClassHtml);
                                
                                // Add <br> before second <img>
                                $imgSplit = explode('<img', $licenseClassHtml);
                                if (count($imgSplit) > 2) {
                                    // Rebuild with <br> before second image
                                    $licenseClassHtml = $imgSplit[0] . '<img' . $imgSplit[1] . '<br><img' . $imgSplit[2];
                                
                                    // If there are more images, add them back
                                    for ($i = 3; $i < count($imgSplit); $i++) {
                                        $licenseClassHtml .= '<img' . $imgSplit[$i];
                                    }
                                }
                                echo "<tr>";
                                echo "<td>{$row['id']}</td>";
                                echo "<td>{$row['full_name']}</td>";
                                echo "<td>{$row['dob']}</td>";
                                echo "<td>{$row['gender']}</td>";
                                echo "<td>{$row['email']}</td>";
                                echo "<td>{$row['phone']}</td>";
                                echo "<td>{$row['nationality']}</td>";
                                echo "<td>{$row['license_number']}</td>";
                                echo "<td>{$row['plan']}</td>";
                                echo "<td>{$row['type']}</td>";
                                echo "<td>{$row['license_country']}</td>";
                                echo "<td>{$row['drive_country']}</td>";
                                echo "<td><div class='value'>$licenseClassHtml</div></td>";
                                echo "<td>" . htmlspecialchars($row['addons']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['promo']) . "</td>";
                                echo "<td>" . showImage($row['passport_photo']) . "</td>";
                                echo "<td>" . showImage($row['license_front']) . "</td>";
                                echo "<td>" . showImage($row['license_back']) . "</td>";
                                echo "<td>{$row['ship_fname']}</td>";
                                echo "<td>{$row['ship_lname']}</td>";
                                echo "<td>" . (!empty($row['street']) ? htmlspecialchars($row['street']) : "<span class='text-muted'>Not provided</span>") . "</td>";
                                echo "<td>{$row['state']}</td>";
                                echo "<td>{$row['zip']}</td>";
                                echo "<td>{$row['city']}</td>";
                                echo "<td>{$row['country']}</td>";
                                echo "<td>{$row['created_at']}</td>";
                                echo "<td>{$row['product']}</td>";
                                echo "<td>{$row['validity']}</td>";
                                echo "<td>{$row['order_id']}</td>";
                                echo "<td> £" . $row['total_price'] . "</td>";
                                echo "<td>
                                <a href='view_details.php?id=" . $row['id'] . "' class='btn btn-warning'>Edit</a> </td>";
                                 echo "<td>
                                <button class='btn btn-danger btn-sm removeBtn' data-id='{$row['id']}'>Remove</button>
                              </td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='32'>No records found</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="applicationModal" tabindex="-1">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Application ID: <span id="modalAppId"></span></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body" id="modalContent"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const modal = new bootstrap.Modal(document.getElementById('applicationModal'));

    // Handle View button
    document.querySelectorAll('.viewBtn').forEach(btn => {
        btn.addEventListener('click', function () {
            const row = this.closest('tr');
            const cells = row.querySelectorAll('td');
            let html = `
                <h4>Applicant Details</h4>
                <p><strong>Full Name:</strong> ${cells[1].innerHTML}</p>
                <p><strong>DOB:</strong> ${cells[2].innerHTML}</p>
                <p><strong>Gender:</strong> ${cells[3].innerHTML}</p>
                <p><strong>Email:</strong> ${cells[4].innerHTML}</p>
                <p><strong>Phone:</strong> ${cells[5].innerHTML}</p>
                <p><strong>Nationality:</strong> ${cells[6].innerHTML}</p>
                <p><strong>License Number:</strong> ${cells[7].innerHTML}</p>

                <h4>License & Plan</h4>
                <p><strong>Plan:</strong> ${cells[8].innerHTML}</p>
                <p><strong>Type:</strong> ${cells[9].innerHTML}</p>
                <p><strong>License Country:</strong> ${cells[10].innerHTML}</p>
                <p><strong>Drive Country:</strong> ${cells[11].innerHTML}</p>
                <p><strong>License Class:</strong> ${cells[12].innerHTML}</p>
                <p><strong>Addons:</strong> ${cells[13].innerHTML}</p>
                <p><strong>Promo:</strong> ${cells[14].innerHTML}</p>

                <h4>Documents</h4>
                <p><strong>Passport:</strong> ${cells[15].innerHTML}</p>
                <p><strong>License Front:</strong> ${cells[16].innerHTML}</p>
                <p><strong>License Back:</strong> ${cells[17].innerHTML}</p>

                <h4>Shipping Address</h4>
                <p><strong>Name:</strong> ${cells[18].innerHTML} ${cells[19].innerHTML}</p>
                <p><strong>Street:</strong> ${cells[20].innerHTML}</p>
                <p><strong>State:</strong> ${cells[21].innerHTML}</p>
                <p><strong>ZIP:</strong> ${cells[22].innerHTML}</p>
                <p><strong>City:</strong> ${cells[23].innerHTML}</p>
                <p><strong>Country:</strong> ${cells[24].innerHTML}</p>
                
                <h4>Other</h4>
                <p><strong>Created At:</strong> ${cells[25].innerHTML}</p>
                <p><strong>Product:</strong> ${cells[26].innerHTML}</p>
                <p><strong>Validity:</strong> ${cells[27].innerHTML}</p>
                <p><strong>Tracking:</strong> ${cells[2].innerHTML}</p>
                <p><strong>Prices:</strong> ${cells[31].innerHTML}</p>
            `;

            document.getElementById('modalAppId').textContent = cells[0].innerHTML;
            document.getElementById('modalContent').innerHTML = html;
            modal.show();
        });
    });

    // Handle Remove button
    document.querySelectorAll('.removeBtn').forEach(btn => {
        btn.addEventListener('click', function () {
            const id = this.dataset.id;
            if (confirm('Are you sure you want to remove this application?')) {
                fetch('delete_application.php?id=' + id, { method: 'GET' })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert('Application removed successfully.');
                            location.reload();
                        } else {
                            alert('Error: ' + data.message);
                        }
                    })
                    .catch(err => alert('Error: ' + err));
            }
        });
    });
});
</script>

</body>
</html>
