<?php
include '../db.php';
$conn->set_charset("utf8mb4");

// Handle AJAX price update
if(isset($_POST['update_price'])) {
    $id = $_POST['id'] ?? '';
    $option = $_POST['option'] ?? '';
    $price = $_POST['price'] ?? '';
    $duration = $_POST['duration'] ?? '';

    if($id && $option && $price && $duration) {
        $stmt = $conn->prepare("UPDATE shipping_rate SET `option` = ?, price = ?, duration = ? WHERE id = ?");
        $stmt->bind_param("sssi", $option, $price, $duration, $id);
        if($stmt->execute()) {
            echo json_encode(['success'=>true]);
        } else {
            echo json_encode(['success'=>false,'message'=>$stmt->error]);
        }
    } else {
        echo json_encode(['success'=>false,'message'=>'Invalid input']);
    }
    exit;
}

// Handle new shipping option submission
if(isset($_POST['add_option'])) {
    $option = $_POST['option'] ?? '';
    $price = $_POST['price'] ?? '';
    $duration = $_POST['duration'] ?? '';
    if($option && $price && $duration) {
        $stmt = $conn->prepare("INSERT INTO shipping_rate (`option`, price, duration) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $option, $price, $duration);
        $stmt->execute();
    }
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Handle removal of shipping option
if(isset($_POST['remove_option'])) {
    $id = $_POST['id'] ?? '';
    if($id) {
        $stmt = $conn->prepare("DELETE FROM shipping_rate WHERE id = ?");
        $stmt->bind_param("i", $id);
        if($stmt->execute()) {
            echo json_encode(['success'=>true]);
        } else {
            echo json_encode(['success'=>false,'message'=>$stmt->error]);
        }
    } else {
        echo json_encode(['success'=>false,'message'=>'Invalid ID']);
    }
    exit;
}

// Fetch all shipping options
$result = $conn->query("SELECT * FROM shipping_rate ORDER BY id ASC");
// Fetch logged-in user data
session_start();
if(!isset($_SESSION['user_id'])){
    header('Location: login.php');
    exit;
}

$userId = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$userResult = $stmt->get_result();
$user = $userResult->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Shipping Options Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
    .circle-name { 
        width: 40px; height: 40px; 
        border-radius: 50%; background: #007bff; 
        color: #fff; text-align: center; line-height: 40px; 
        font-weight: bold; margin-right: 10px;
    }
    .table-style img { max-height: 50px; }
</style>
</head>
<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
        <div class="menu_link">
            <ul>
                <li><a href="index.php" class="active">Permit Request</a></li>
                <li><a href="shipping_price.php">Shipping Price</a></li>
                <li><a href="profile.php">Profile Setting</a></li>
                <li><a href="logout.php">Log Out</a></li>
            </ul>
        </div>
    </div>

    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button">
                <button class="btn toggle_btn" type="button"></button>
            </div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?php echo strtoupper(substr($user['full_name'], 0, 2)); ?></span>
                    <div class="user_name"><h4><?php echo htmlspecialchars($user['full_name']); ?></h4></div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
            <h3>Shipping Options</h3>
            <div class="table-wrapper inner-wrapper">
                <table class="display table table-bordered table-striped table-style">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Option</th>
                            <th>Price</th>
                            <th>Duration</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                   <tbody>
                        <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td>
                                <input type="text" class="form-control optionInput" data-id="<?= $row['id'] ?>" value="<?= htmlspecialchars($row['option']) ?>">
                            </td>
                            <td>
                                <input type="text" class="form-control priceInput" data-id="<?= $row['id'] ?>" value="<?= $row['price'] ?>">
                            </td>
                            <td>
                                <input type="text" class="form-control durationInput" data-id="<?= $row['id'] ?>" value="<?= htmlspecialchars($row['duration']) ?>">
                            </td>
                            <td>
                                <button class="btn btn-success saveAllBtn" data-id="<?= $row['id'] ?>">Save</button>
                                    <button class="btn btn-danger removeBtn" data-id="<?= $row['id'] ?>">Remove</button>
                                </td>
                            
                        </tr>
                        <?php endwhile; ?>
                        </tbody>
            </div>

        <div style="margin-bottom: 15px;">
        <h4 class="mt-4">Add New Shipping Option</h4>
<form method="post" class="mb-4" style="display: flex; align-items: center; flex-wrap: nowrap;">
    <input type="hidden" name="add_option" value="1">
    
    <input type="text" name="option" class="form-control" placeholder="Option Name" required style="width: 200px; margin-right: 15px; display: inline-block;">
    
    <input type="text" name="price" class="form-control" placeholder="Price" required style="width: 100px; margin-right: 15px; display: inline-block;">
    
    <input type="text" name="duration" class="form-control" placeholder="Duration" required style="width: 150px; margin-right: 20px; display: inline-block;">
    
    <button type="submit" class="btn btn-primary" style="white-space: nowrap;">Add Option</button>
</form>
</div>  
        </div>
    </div>
</div>

<script>
document.querySelectorAll('.removeBtn').forEach(btn => {
    btn.addEventListener('click', function() {
        const id = this.dataset.id;
        if(!confirm('Are you sure you want to remove this option?')) return;

        fetch('', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: `remove_option=1&id=${id}`
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                alert('Option removed!');
                location.reload(); // refresh table
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(err => alert('AJAX error: ' + err));
    });
});
</script>
</body>
</html>
