<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include('db.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
    // Step 1 Submission
    if (!isset($_SESSION['step1']) && isset($_POST['first_name'])) {
        $_SESSION['step1'] = $_POST;

        $full_name = $_POST['first_name'] . ' ' . $_POST['last_name'];
        $email = $_POST['email'];
        $phone = $_POST['whatsapp'];
        $dob = $_POST['dob_year'] . '-' . $_POST['dob_month'] . '-' . $_POST['dob_day'];
        $gender = $_POST['gender'];
        $residence = $_POST['residence'];
        $place_of_birth = $_POST['birth_place'];

        // Basic validation to ensure essential fields are present before DB insert
        if (empty($full_name) || empty($email) || empty($phone) || empty($dob) || empty($gender) || empty($residence) || empty($place_of_birth)) {
            // Handle missing essential data for Step 1 if necessary
            // For now, assuming they are present due to POST check
        }

        $sql = "INSERT INTO applications (full_name, email, phone, dob, gender, place_of_birth, nationality)
                VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        // Ensure bind_param types match actual data types and order
        $stmt->bind_param("sssssss", $full_name, $email, $phone, $dob, $gender, $place_of_birth, $residence);
        $stmt->execute();

        $_SESSION['application_id'] = $stmt->insert_id; // This is crucial for order ID generation
        $stmt->close();
        
        
        // Generate order ID immediately after creating the application
        generateOrderId($conn, $_SESSION['application_id']);
    } elseif (isset($_SESSION['application_id']) && !isset($_SESSION['order_id'])) {
        // If we have an application ID but no order ID, generate one
        generateOrderId($conn, $_SESSION['application_id']);
    }

    // Step 2 Submission
        if (isset($_POST['step2_submit'])) {
    // Save form data to session
    $_SESSION['step2'] = $_POST;

    // Get the selected plan
    $copy_type_selected = $_POST['plan'] ?? '';

    // Get the prefix based on copy type
    $prefix = '';
    if ($copy_type_selected === 'Soft Copy') {
        $prefix = 'GRN200-569-';
    } elseif ($copy_type_selected === 'Hard Copy') {
        $prefix = 'GRN202-569-';
    }

    // Ensure prefix is valid before proceeding
    if (!empty($prefix)) {
        // Initialize order number tracker if not already set
        if (!isset($_SESSION['generated_order_ids'])) {
            $_SESSION['generated_order_ids'] = [];
        }

        // Generate a new sequence number based on count
        $next_sequence = count($_SESSION['generated_order_ids']) + 1;
        $sequence_str = str_pad($next_sequence, 4, '0', STR_PAD_LEFT);

        // Create full order ID
        $order_id = $prefix . $sequence_str;

        // Store in session
        $_SESSION['order_id'] = $order_id;

        // Optionally store it in an array if you want to track all generated IDs during session
        $_SESSION['generated_order_ids'][] = $order_id;
    } else {
        error_log("Invalid copy type selected. Cannot generate order ID.");
    }

    // Save other session values
    $_SESSION['copy_type'] = ($copy_type_selected === 'Soft Copy') ? 'soft' : 'hard';
    $_SESSION['totalAmount'] = $_POST['total'] ?? '0.00';

    // Convert validity (optional: update if using numeric code)
    $validityOptions = ['10'=>'1 year','20'=>'2 years','30'=>'3 years'];
    $_SESSION['step2']['validity'] = $validityOptions[$_POST['validity']] ?? '1 year';

    // Redirect to next step
    header("Location: step3.php");
    exit;
}

    // Get latest row for pricing
    $sql = "SELECT * FROM form_controll ORDER BY id DESC LIMIT 1";
    $result = $conn->query($sql);
    if ($result === false) {
        throw new mysqli_sql_exception("Failed to fetch pricing data.", $conn->error_list);
    }
    $prices = $result->fetch_assoc();
    if (!$prices) {
        // If no pricing data is found, throw an error or handle gracefully
        throw new Exception("Pricing data not found in form_controll table.");
    }

} catch (mysqli_sql_exception $e) {
    // Log the error for debugging
    error_log("Database error in step2.php: " . $e->getMessage());
    // Display a user-friendly error message
    echo "An unexpected database error occurred. Please try again later.";
    exit;
} catch (Exception $e) {
    // Log other exceptions
    error_log("General error in step2.php: " . $e->getMessage());
    echo "An unexpected error occurred. Please try again later.";
    exit;
}

// Function to generate order ID
function generateOrderId($conn, $application_id, $copy_type = null) {
    // Determine copy type from session if not explicitly passed
    if ($copy_type === null) {
        $copy_type = $_SESSION['step2']['plan'] ?? 'Soft Copy';
    }

    // Set prefix based on copy type
    $prefix = '';
    if ($copy_type === 'Soft Copy') {
        $prefix = 'GRN200-569-';
    } elseif ($copy_type === 'Hard Copy') {
        $prefix = 'GRN202-569-';
    } else {
        return false; // Invalid copy type
    }

    // Get how many existing orders of the same type exist
    $sql = "SELECT COUNT(*) AS count FROM applications WHERE copy_type = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $copy_type);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();

    $sequence_number = $row['count'] + 1;
    $sequence_str = str_pad($sequence_number, 4, '0', STR_PAD_LEFT);

    // Final order ID
    $order_id = $prefix . $sequence_str;

    // Save to DB
    $update = $conn->prepare("UPDATE applications SET order_id = ?, copy_type = ? WHERE id = ?");
    $update->bind_param("ssi", $order_id, $copy_type, $application_id);
    $update->execute();
    $update->close();

    // Store in session
    $_SESSION['order_id'] = $order_id;

    return $order_id;
}
?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title>Step 2 - Choose Plan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

<script>
// --- UPDATED: Price constants from PHP ---
// Ensure these keys exist in your $prices array fetched from DB
const prices = {
  normal_type_price: <?= (float)($prices['normal_type_price'] ?? 0) ?>,
  urgent_type_price: <?= (float)($prices['urgent_type_price'] ?? 0) ?>,
  soft_copy_price: <?= (float)($prices['soft_copy_price'] ?? 0) ?>,
  hard_copy_price: <?= (float)($prices['hard_copy_price'] ?? 0) ?>,
  motorcyle_price: <?= (float)($prices['motorcyle_price'] ?? 0) ?>,
  passenger_car_price: <?= (float)($prices['passenger_car_price'] ?? 0) ?>,
  vehicle_over_price: <?= (float)($prices['vehicle_over_price'] ?? 0) ?>,
  vehicle_over_seats_price: <?= (float)($prices['vehicle_over_seats_price'] ?? 0) ?>,
  ebc_price: <?= (float)($prices['ebc_price'] ?? 0) ?>
};

// Display the generated order ID if available
<?php if (isset($_SESSION['order_id'])): ?>
<div style="background: #f8f9fa; padding: 15px; border-radius: 5px; margin-bottom: 20px; border-left: 4px solid #007bff;">
    <strong>Your Order ID:</strong> <span style="color: #007bff; font-weight: bold;"><?php echo $_SESSION['order_id']; ?></span>
</div>
<?php endif; ?>

// --- NEW: Helper function to get current time information ---
function getUkTime() {
    try {
        // Attempt to get UK time
        const options = { timeZone: 'Europe/London', hour: 'numeric', hour12: false, weekday: 'long' };
        const formatter = new Intl.DateTimeFormat('en-GB', options);
        const parts = formatter.formatToParts(new Date());

        let hour = -1;
        let weekday = '';

        parts.forEach(part => {
            if (part.type === 'hour') hour = parseInt(part.value, 10);
            if (part.type === 'weekday') weekday = part.value;
        });
        
        const isWeekend = (weekday === 'Saturday' || weekday === 'Sunday');
        // Define business hours (e.g., 10 AM to 5 PM)
        const isBusinessHours = (hour >= 10 && hour < 17); 

        return { hour, weekday, isWeekend, isWeekday: !isWeekend, isBusinessHours };
    } catch (e) {
        console.error("Could not get UK time information. Using local time as fallback.", e);
        // Fallback to local time if Intl.DateTimeFormat is not supported or timezone fails
        const now = new Date();
        const day = now.getDay(); // 0 for Sunday, 6 for Saturday
        const hour = now.getHours();
        return {
            hour: hour,
            weekday: '', // Not available in fallback
            isWeekend: (day === 0 || day === 6),
            isWeekday: (day > 0 && day < 6),
            isBusinessHours: (hour >= 10 && hour < 17) // Assuming 10 AM to 5 PM local time
        };
    }
}

// --- NEW: Function to handle enabling/disabling Urgent option and updating styles ---
function checkUrgentAvailability() {
    const ukTime = getUkTime();
    const copyType = document.querySelector('input[name="plan"]:checked')?.value;
    const urgentRadio = document.getElementById('urgentRadio');
    const normalRadio = document.querySelector('input[name="type"][value="Normal"]');
    const urgentLabel = urgentRadio ? urgentRadio.closest('label') : null; // Get label parent

    if (!urgentRadio || !normalRadio) return; 

    // Rule: Urgent Hard Copy available only on weekdays, 10am-5pm UK time.
    if (copyType === 'Hard Copy' && (ukTime.isWeekend || !ukTime.isBusinessHours)) {
        urgentRadio.disabled = true;
        if(urgentLabel) urgentLabel.style.color = '#999'; // Dim the label
        if (urgentRadio.checked) {
            normalRadio.checked = true; // Auto-select Normal if Urgent was disabled
        }
    } else {
        // Urgent Soft Copy is always available (but price might change if you add weekend logic)
        urgentRadio.disabled = false;
        if(urgentLabel) urgentLabel.style.color = ''; // Reset color
    }
    
    // Recalculate total after potentially changing selection or enabling/disabling options
    updateTotal();
}

// --- REWRITTEN: updateTotal function to handle price breakdown and new urgent rules ---
function updateTotal() {
  // Initialize price components
  let typePrice = 0;
  let validityPrice = 0;
  let copyTypePrice = 0;
  let productPrice = 0;
  let addOnsPrice = 0;
  let shippingPrice = 0; // Placeholder for future shipping costs

  const ukTime = getUkTime();

  // 1. Plan (Copy Type) - Soft or Hard
  let copyType = document.querySelector('input[name="plan"]:checked')?.value;
  copyTypePrice = (copyType === 'Soft Copy') ? prices.soft_copy_price : prices.hard_copy_price;
    
  // 2. Type (Urgent/Normal)
  let type = document.querySelector('input[name="type"]:checked')?.value;
  if (type === 'Urgent') {
      typePrice = prices.urgent_type_price; 
  } else { // 'Normal'
      typePrice = prices.normal_type_price;
  }

  // 3. Validity
  validityPrice = parseInt(document.getElementById('validity')?.value || 0);

  // 4. Product Booklet
  let product = document.querySelector('input[name="productbooklet"]:checked')?.value;
  productPrice = (product === 'Booklet') ? prices.motorcyle_price : prices.passenger_car_price;

  // 5. Addons
  let addOns = document.querySelectorAll('input[name="addons[]"]:checked');
  addOnsPrice = addOns.length * prices.ebc_price;

  // 6. Calculate Total
  let total = typePrice + validityPrice + copyTypePrice + productPrice + addOnsPrice + shippingPrice;

  // Update price breakdown display (NEW)
  document.getElementById("breakdown-type-price").innerText = "$" + typePrice.toFixed(2);
  document.getElementById("breakdown-copy-price").innerText = "$" + copyTypePrice.toFixed(2);
  document.getElementById("breakdown-product-price").innerText = "$" + productPrice.toFixed(2);
  document.getElementById("breakdown-validity-price").innerText = "$" + validityPrice.toFixed(2);
  document.getElementById("breakdown-addons-price").innerText = "$" + addOnsPrice.toFixed(2);
  document.getElementById("breakdown-shipping-price").innerText = "$" + shippingPrice.toFixed(2); // Placeholder

  // Update total display
  document.getElementById("totalAmount").innerText = "$" + total.toFixed(2);

  // Update hidden input for form submission
  const totalInput = document.getElementById("totalInput");
  if (totalInput) {
    totalInput.value = total.toFixed(2);
  }

  // Save in localStorage
  localStorage.setItem("totalAmount", total.toFixed(2));
  localStorage.setItem("plan", copyType);
}

document.addEventListener('DOMContentLoaded', function() {
  // Bind events to all inputs that affect the price calculation
  document.querySelectorAll('input[name="type"]').forEach(e => e.addEventListener('change', updateTotal));
  const validitySelect = document.getElementById('validity');
  if (validitySelect) validitySelect.addEventListener('change', updateTotal);
  
  // When plan (copy type) changes, we first check urgent availability, which then calls updateTotal
  document.querySelectorAll('input[name="plan"]').forEach(e => e.addEventListener('change', checkUrgentAvailability)); 
  
  document.querySelectorAll('input[name="productbooklet"]').forEach(e => e.addEventListener('change', updateTotal));
  document.querySelectorAll('input[name="addons[]"]').forEach(e => e.addEventListener('change', updateTotal));

  // Initial checks on page load
  checkUrgentAvailability(); // Sets up correct urgent radio state and calls updateTotal
});
</script>

  <?php include('link.php'); ?>
  <style>
    .price-breakdown { border: 1px solid #eee; padding: 15px; margin-bottom: 20px; border-radius: 8px; background-color: #f9f9f9; }
    .price-breakdown h4 { margin-top: 0; color: #333; border-bottom: 1px solid #ddd; padding-bottom: 10px; }
    .price-breakdown ul { list-style: none; padding: 0; margin: 0; }
    .price-breakdown li { display: flex; justify-content: space-between; padding: 5px 0; font-size: 15px; }
    .price-breakdown li span { color: #555; }
    input[type="radio"]:disabled + label { color: #999; }
    input[type="radio"]:disabled ~ div label { color: #999; }
  </style>
</head>

<body>
  <?php include('header.php'); ?>
 
  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>
    <div class="step-progress">
      <div class="step"><span class="number">01</span><span class="label">Applicant's Details</span></div>
      <div class="step active"><span class="number">02</span><span class="label">Choose Plan</span></div>
      <div class="step"><span class="number">03</span><span class="label">Add Document</span></div>
      <div class="step"><span class="number">04</span><span class="label">Review</span></div>
      <div class="step"><span class="number">05</span><span class="label">Payment</span></div>
    </div>
  </section>

  <div class="licenceform">
    <div class="container">
      <div class="main-form-container">
        <div class="form-container">
          <h2>Choose Plan</h2>
          <form method="post" action="step2.php">

            <!-- Copy Type -->
            <div class="productcard-wrap">
              <div class="formfield">
                <label class="softhard-copy">
                  <div class="span-soft">
                    <input type="radio" name="plan" value="Soft Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan'] === 'Soft Copy') ? 'checked' : 'checked' ?>>
                    <img src="assets/images/back.svg" alt="Soft">
                  </div>
                  <div><b>Soft Copy</b><br><small>Email delivery</small></div>
                </label>
              </div>
              <div class="formfield">
                <label class="softhard-copy">
                  <div class="span-soft">
                    <input type="radio" name="plan" value="Hard Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan'] === 'Hard Copy') ? 'checked' : '' ?>>
                    <img src="assets/images/back.svg" alt="Hard">
                  </div>
                  <div><b>Hard Copy</b><br><small>Home delivery</small></div>
                </label>
              </div>
            </div>

            <!-- Type -->
            <label>Type *</label><br>
            <label><input type="radio" name="type" value="Normal" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type'] === 'Normal') ? 'checked' : 'checked' ?>> Normal</label>
            <label><input type="radio" id="urgentRadio" name="type" value="Urgent" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type'] === 'Urgent') ? 'checked' : '' ?>> Urgent</label>
            <br><br>

            <!-- Country -->
            <label>Where your license was issued *</label>
            <select id="license_issue_label" name="license_country" required>
                 <option value="">Select Country</option>
            </select><br><br>
            
            <!-- Driving Destination -->
            <label>Where do you intend to drive? *</label>
            <select id="drive_country" name="drive_country" required>
                 <option value="">Select Country</option>
            </select><br><br>

            <!-- License Class -->
            <div class="pillbtn-wrap">
              <label class="pillbtn">Classes of Driving License *</label>
              <?php
              $classesMap = [
                  'A. Motorcycle' => ['icon' => 'Vector.svg', 'label' => 'A. Motorcycle'],
                  'B. Passenger car' => ['icon' => 'Vector-1.svg', 'label' => 'B. Passenger car'],
                  'C. Vehicle over 7,000 Pound' => ['icon' => '7000.svg', 'label' => 'C. Vehicle over 7,000 Pound'],
                  'D. Vehicle over 10 seats' => ['icon' => 'Vector-2.svg', 'label' => 'D. Vehicle over 10 seats'],
                  'E. B.C, or Class vehicle with trailer' => ['icon' => 'veh.svg', 'label' => 'E. B.C, or Class vehicle with trailer'],
              ];
              foreach ($classesMap as $key => $details) {
                  $checked = '';
                  if (isset($_SESSION['step2']['license_class']) && is_array($_SESSION['step2']['license_class'])) {
                      if (in_array($details['label'], $_SESSION['step2']['license_class'])) {
                          $checked = 'checked';
                      }
                  }
                  echo "<label><input type='checkbox' name='license_class[]' value='{$details['label']}' {$checked}> <img src='assets/images/{$details['icon']}' alt='{$details['label']}' style='vertical-align: middle; margin-right: 5px;'>&nbsp;{$details['label']}</label>";
              }
              ?>
            </div><br>

            <!-- Product -->
            <div class="productcard">
              <label>Products</label>
              <div class="productcard-wrap">
                <div class="formfield">
                  <label class="softhard-copy">
                    <div class="span-soft">
                      <input type="radio" name="productbooklet" value="Booklet" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet'] === 'Booklet') ? 'checked' : 'checked' ?>>
                      <img src="assets/card.png" height="200px" alt="Booklet">
                    </div>
                    <div><b>Booklet</b></div>
                  </label>
                </div>
                <div class="formfield">
                  <label class="softhard-copy">
                    <div class="span-soft">
                      <input type="radio" name="productbooklet" value="Booklet + Card" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet'] === 'Booklet + Card') ? 'checked' : '' ?>>
                      <img src="assets/slide.png" height="200px" alt="Booklet Plus Card">
                    </div>
                    <div><b>Booklet + Card</b></div>
                  </label>
                </div>
              </div>
            </div>

            <!-- Validity -->
            <div class="productcard-validity">
              <div class="col-lg-12">
                <label>Validity</label>
                <select id="validity" name="validity">
                  <option value="10" <?= (isset($_SESSION['step2']['validity']) && $_SESSION['step2']['validity'] === '1 year') ? 'selected' : 'selected' ?>>Validity 1 Year</option>
                  <option value="20" <?= (isset($_SESSION['step2']['validity']) && $_SESSION['step2']['validity'] === '2 years') ? 'selected' : '' ?>>Validity 2 Years</option>
                  <option value="30" <?= (isset($_SESSION['step2']['validity']) && $_SESSION['step2']['validity'] === '3 years') ? 'selected' : '' ?>>Validity 3 Years</option>
                </select>
              </div>
            </div><br>

            <!-- Add-ons -->
            <label>Add-ons</label>
            <div class="add-ons">
              <?php
              for ($i = 1; $i <= 4; $i++) {
                $addon_value = "Product $i";
                $checked = '';
                if (isset($_SESSION['step2']['addons']) && is_array($_SESSION['step2']['addons'])) {
                    if (in_array($addon_value, $_SESSION['step2']['addons'])) {
                        $checked = 'checked';
                    }
                }
                echo "<label><input type='checkbox' name='addons[]' value='{$addon_value}' {$checked}> Product $i - $24</label>";
              }
              ?>
            </div><br>

            <!-- Promo -->
            <label>Apply Promo Code</label><br>
            <input type="text" name="promo" placeholder="Promo code" value="<?= isset($_SESSION['step2']['promo']) ? htmlspecialchars($_SESSION['step2']['promo']) : '' ?>"><br><br>

            <!-- Price Breakdown Section -->
            <div class="price-breakdown">
              <h4>Price Summary</h4>
              <ul>
                <li><span>Copy Type (Soft/Hard):</span> <strong id="breakdown-copy-price">$0.00</strong></li>
                <li><span>Processing Type (Normal/Urgent):</span> <strong id="breakdown-type-price">$0.00</strong></li>
                <li><span>Product Booklet/Card:</span> <strong id="breakdown-product-price">$0.00</strong></li>
                <li><span>Validity:</span> <strong id="breakdown-validity-price">$0.00</strong></li>
                <li><span>Add-ons:</span> <strong id="breakdown-addons-price">$0.00</strong></li>
                <li><span>Shipping:</span> <strong id="breakdown-shipping-price">$0.00</strong></li>
              </ul>
            </div>
            
            <!-- Total -->
            <div style="text-align: right; font-size: 22px; font-weight: bold; border-top: 2px solid #333; padding-top: 10px;">
              Total: <strong id="totalAmount">$0.00</strong>
            </div>
            <input type="hidden" id="totalInput" name="total" value="0">
            <br>

            <!-- Buttons -->
            <div class="back-continue-button-wrap">
              <a href="index.php"><button type="button" class="first-btn-cicle">Back</button></a>
              <button type="submit" name="step2_submit" class="btn secondary-btn-circle">Verify & Continue</button>
            </div>
          </form>
        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>
      </div>
    </div>
  </div>
 <script>
document.addEventListener("DOMContentLoaded", function () {
  const countrySelect = document.getElementById("drive_country");
  const licenseIssueSelect = document.getElementById("license_issue_label");

  // Load countries dynamically
  fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
      countries.forEach((c, index) => {
        const option1 = new Option(c.name, c.code);
        licenseIssueSelect.appendChild(option1);

        const option2 = new Option(c.name, c.code);
        countrySelect.appendChild(option2);

        // Pre-select based on session data
        const savedLicenseCountry = "<?= htmlspecialchars($_SESSION['step2']['license_country'] ?? '') ?>";
        if (savedLicenseCountry && c.code === savedLicenseCountry) {
            licenseIssueSelect.value = savedLicenseCountry;
        }
        
        const savedDriveCountry = "<?= htmlspecialchars($_SESSION['step2']['drive_country'] ?? '') ?>";
        if (savedDriveCountry && c.code === savedDriveCountry) {
            countrySelect.value = savedDriveCountry;
        }
      });
      
      // If no session data, select first country
      if (!licenseIssueSelect.value && countries.length > 0) {
          licenseIssueSelect.value = countries[0].code;
      }
      if (!countrySelect.value && countries.length > 0) {
          countrySelect.value = countries[0].code;
      }

      // Ensure initial price calculation and urgent availability check
      updateTotal();
      checkUrgentAvailability(); 
    })
    .catch(err => console.error("Error loading countries:", err));
});
</script>

  <?php include('footer.php'); ?>
  <?php include('footerscript.php'); ?>
</body>

</html>