<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include('db.php');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// --- Start of AJAX Promo Validation Handler ---
if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest' && isset($_POST['promo_code'])) {
    $promo_code_to_validate = trim($_POST['promo_code']);
    $response = ['valid' => false, 'discount_value' => 0, 'discount_type' => '', 'promo_id' => null, 'error' => 'Invalid or expired promo code.'];

    if (!empty($promo_code_to_validate)) {
        $stmt = $conn->prepare("SELECT id, promo, discount_type, discount_value FROM addon_promo WHERE promo=? AND (expiry_date IS NULL OR expiry_date >= CURDATE()) LIMIT 1");
        $stmt->bind_param("s", $promo_code_to_validate);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            $response['valid'] = true;
            $response['discount_value'] = (float)$row['discount_value'];
            $response['discount_type'] = $row['discount_type'];
            $response['promo_id'] = $row['id'];
            $response['error'] = ''; // Clear error if valid
        }
    }
    header('Content-Type: application/json');
    echo json_encode($response);
    exit; // Stop further execution
}
// --- End of AJAX Promo Validation Handler ---


if (!isset($_SESSION['step1']) && isset($_POST['first_name'])) {
    $_SESSION['step1'] = $_POST;

    $full_name = $_POST['first_name'] . ' ' . $_POST['last_name'];
    $email = $_POST['email'];
    $phone = $_POST['whatsapp'];
    $dob = $_POST['dob_year'] . '-' . $_POST['dob_month'] . '-' . $_POST['dob_day'];
    $gender = $_POST['gender'];
    $residence = $_POST['residence'];
    $place_of_birth = $_POST['birth_place'];

    $sql = "INSERT INTO applications (full_name, email, phone, dob, gender, place_of_birth, nationality)
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssss", $full_name, $email, $phone, $dob, $gender, $place_of_birth, $residence);
    $stmt->execute();

    $_SESSION['application_id'] = $stmt->insert_id;
    $stmt->close();

    generateOrderId($conn, $_SESSION['application_id']);
} elseif (isset($_SESSION['application_id']) && !isset($_SESSION['order_id'])) {
    generateOrderId($conn, $_SESSION['application_id']);
}

if (isset($_POST['step2_submit'])) {
    $_SESSION['step2'] = $_POST;

    $copy_type_selected = $_POST['plan'] ?? '';
    $prefix = '';
    if ($copy_type_selected === 'Soft Copy') {
        $prefix = 'GRN200-569-';
    } elseif ($copy_type_selected === 'Hard Copy') {
        $prefix = 'GRN202-569-';
    }

    if (!empty($prefix)) {
        if (!isset($_SESSION['generated_order_ids'])) {
            $_SESSION['generated_order_ids'] = [];
        }

        $next_sequence = count($_SESSION['generated_order_ids']) + 1;
        $sequence_str = str_pad($next_sequence, 4, '0', STR_PAD_LEFT);

        $order_id = $prefix . $sequence_str;

        $_SESSION['order_id'] = $order_id;
        $_SESSION['generated_order_ids'][] = $order_id;
    } else {
        error_log("Invalid copy type selected. Cannot generate order ID.");
    }

    $_SESSION['copy_type'] = ($copy_type_selected === 'Soft Copy') ? 'soft' : 'hard';
    $_SESSION['totalAmount'] = $_POST['total'] ?? '0.00';

    $validityOptions = ['10'=>'1 year','20'=>'2 years','30'=>'3 years'];
    $_SESSION['step2']['validity'] = $_POST['validity'] ?? '';
    $_SESSION['step2']['license_country'] = $_POST['license_country'] ?? '';
    $_SESSION['step2']['drive_country'] = $_POST['drive_country'] ?? '';
    $_SESSION['step2']['license_class'] = $_POST['license_class'] ?? [];
    $_SESSION['step2']['productbooklet'] = $_POST['productbooklet'] ?? '';
    $_SESSION['step2']['addons'] = $_POST['addons'] ?? [];

    header("Location: step3.php");
    exit;
}

$sql = "SELECT * FROM form_controll ORDER BY id DESC LIMIT 1";
$result = $conn->query($sql);
$prices = $result->fetch_assoc();

$promo_code_from_session = trim($_SESSION['step2']['promo'] ?? '');
$promo_discount = 0;
$promo_type = '';
$promo_id = null;
$promo_error_message = '';

if (!empty($promo_code_from_session)) {
    $stmt = $conn->prepare("SELECT id, promo, discount_type, discount_value FROM addon_promo WHERE promo=? AND (expiry_date IS NULL OR expiry_date >= CURDATE()) LIMIT 1");
    $stmt->bind_param("s", $promo_code_from_session);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        $promo_discount = (float)$row['discount_value'];
        $promo_type = $row['discount_type'];
        $promo_id = $row['id'];
    } else {
        $promo_error_message = "Invalid or expired promo code.";
    }
}
$_SESSION['step2']['promo_error'] = $promo_error_message; // Store error in session for display

?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title>Step 2 - Choose Plan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

 <script>
const prices = {
  normal_type_price: <?= (float)($prices['normal_type_price'] ?? 0) ?>,
  urgent_type_price: <?= (float)($prices['urgent_type_price'] ?? 0) ?>,
  soft_copy_price: <?= (float)($prices['soft_copy_price'] ?? 0) ?>,
  hard_copy_price: <?= (float)($prices['hard_copy_price'] ?? 0) ?>,
  motorcyle_price: <?= (float)($prices['motorcyle_price'] ?? 0) ?>,
  passenger_car_price: <?= (float)($prices['passenger_car_price'] ?? 0) ?>,
  vehicle_over_price: <?= (float)($prices['vehicle_over_price'] ?? 0) ?>,
  vehicle_over_seats_price: <?= (float)($prices['vehicle_over_seats_price'] ?? 0) ?>,
  ebc_price: <?= (float)($prices['ebc_price'] ?? 0) ?>
};

let promoInfo = {
    code: '<?= htmlspecialchars($promo_code_from_session) ?>',
    type: '<?= htmlspecialchars($promo_type) ?>',
    value: <?= (float)($promo_discount) ?>,
    promo_id: <?= $promo_id ?? 'null' ?>,
    error: '<?= htmlspecialchars($_SESSION['step2']['promo_error'] ?? '') ?>'
};

function getUkTime() {
    const options = { timeZone: 'Europe/London', hour: 'numeric', hour12: false };
    const formatter = new Intl.DateTimeFormat('en-GB', options);
    const parts = formatter.formatToParts(new Date());

    let hour = -1;
    let weekday = '';

    parts.forEach(part => {
        if (part.type === 'hour') hour = parseInt(part.value, 10);
        if (part.type === 'weekday') weekday = part.value;
    });

    const isWeekend = (weekday === 'Saturday' || weekday === 'Sunday');
    const isBusinessHours = (hour >= 10 && hour < 17);

    return { hour, weekday, isWeekend, isWeekday: !isWeekend, isBusinessHours };
}

function checkUrgentAvailability() {
    const ukTime = getUkTime();
    const copyType = document.querySelector('input[name="plan"]:checked')?.value;
    const urgentRadio = document.getElementById('urgentRadio');
    const normalRadio = document.querySelector('input[name="type"][value="Normal"]');
    const urgentLabel = urgentRadio ? urgentRadio.closest('label') : null;

    if (!urgentRadio || !normalRadio) return;

    if (copyType === 'Hard Copy' && (ukTime.isWeekend || !ukTime.isBusinessHours)) {
        urgentRadio.disabled = true;
        if (urgentLabel) urgentLabel.style.color = '#999';
        if (urgentRadio.checked) {
            normalRadio.checked = true;
        }
    } else {
        urgentRadio.disabled = false;
        if (urgentLabel) urgentLabel.style.color = '';
    }
    updateTotal();
}

function applyPromoCode() {
    const promoInput = document.querySelector('input[name="promo"]');
    const enteredPromo = promoInput.value.trim();
    const promoErrorDiv = document.getElementById('promoError');

    // If input is empty, reset promoInfo and clear error
    if (!enteredPromo) {
        promoInfo = { code: '', type: '', value: 0, promo_id: null, error: '' };
        promoErrorDiv.innerText = '';
        updateTotal();
        return;
    }

    fetch("step2.php", {
        method: "POST",
        headers: {
            "X-Requested-With": "XMLHttpRequest",
            "Content-Type": "application/x-www-form-urlencoded",
        },
        body: "promo_code=" + encodeURIComponent(enteredPromo)
    })
    .then(response => response.json())
    .then(data => {
        if (data.valid) {
            promoInfo = {
                code: enteredPromo,
                type: data.discount_type,
                value: data.discount_value,
                promo_id: data.id,
                error: ''
            };
            promoErrorDiv.innerText = ''; // Clear error if valid
        } else {
            // Reset to default and show error if invalid
            promoInfo = { code: enteredPromo, type: '', value: 0, promo_id: null, error: data.error };
            promoErrorDiv.innerText = data.error;
        }
        updateTotal();
    })
    .catch(error => {
        console.error("Error applying promo code:", error);
        // Reset to default and show general error
        promoInfo = { code: enteredPromo, type: '', value: 0, promo_id: null, error: 'An error occurred. Please try again.' };
        promoErrorDiv.innerText = 'An error occurred. Please try again.';
        updateTotal();
    });
}


function updateTotal() {
  let typePrice = 0;
  let validityPrice = 0;
  let copyTypePrice = 0;
  let productPrice = 0;
  let addOnsPrice = 0;
  let shippingPrice = 0;
  let discountAmount = 0;

  const copyType = document.querySelector('input[name="plan"]:checked')?.value;
  copyTypePrice = (copyType === 'Soft Copy') ? prices.soft_copy_price : prices.hard_copy_price;

  const type = document.querySelector('input[name="type"]:checked')?.value;
  typePrice = (type === 'Urgent') ? prices.urgent_type_price : prices.normal_type_price;

  const validitySelect = document.getElementById('validity');
  validityPrice = validitySelect ? parseFloat(validitySelect.selectedOptions[0].dataset.price || 0) : 0;

  const product = document.querySelector('input[name="productbooklet"]:checked')?.value;
  productPrice = (product === 'Booklet') ? prices.motorcyle_price : prices.passenger_car_price;

  const addOns = document.querySelectorAll('input[name="addons[]"]:checked');
  addOnsPrice = addOns.length * prices.ebc_price;

  // Calculate discount only if promoInfo has valid data
  if (promoInfo.value > 0 && promoInfo.type) {
      let subtotalBeforeDiscount = typePrice + validityPrice + copyTypePrice + productPrice + addOnsPrice + shippingPrice;
      if (promoInfo.type === 'percent') {
          discountAmount = (subtotalBeforeDiscount * promoInfo.value) / 100;
      } else { // fixed
          discountAmount = promoInfo.value;
      }
      // Ensure discount doesn't exceed subtotal
      if (discountAmount > subtotalBeforeDiscount) {
          discountAmount = subtotalBeforeDiscount;
      }
  } else {
      discountAmount = 0; // Explicitly set to 0 if no valid promo
  }


  let total = typePrice + validityPrice + copyTypePrice + productPrice + addOnsPrice + shippingPrice - discountAmount;

  document.getElementById("breakdown-type-price").innerText = "$" + typePrice.toFixed(2);
  document.getElementById("breakdown-copy-price").innerText = "$" + copyTypePrice.toFixed(2);
  document.getElementById("breakdown-product-price").innerText = "$" + productPrice.toFixed(2);
  document.getElementById("breakdown-validity-price").innerText = "$" + validityPrice.toFixed(2);
  document.getElementById("breakdown-addons-price").innerText = "$" + addOnsPrice.toFixed(2);
  document.getElementById("breakdown-shipping-price").innerText = "$" + shippingPrice.toFixed(2);
  document.getElementById("breakdown-discount").innerText = "-$" + discountAmount.toFixed(2);

  document.getElementById("totalAmount").innerText = "$" + total.toFixed(2);

  const totalInput = document.getElementById("totalInput");
  if (totalInput) {
    totalInput.value = total.toFixed(2);
  }
}

document.addEventListener('DOMContentLoaded', function() {
  document.querySelectorAll('input[name="type"]').forEach(e => e.addEventListener('change', updateTotal));
  const validitySelect = document.getElementById('validity');
  if (validitySelect) validitySelect.addEventListener('change', updateTotal);

  document.querySelectorAll('input[name="plan"]').forEach(e => {
      e.addEventListener('change', checkUrgentAvailability);
      e.addEventListener('change', updateTotal);
  });
  document.querySelectorAll('input[name="productbooklet"]').forEach(e => e.addEventListener('change', updateTotal));
  document.querySelectorAll('input[name="addons[]"]').forEach(e => e.addEventListener('change', updateTotal));

  const promoInput = document.querySelector('input[name="promo"]');
  const promoErrorDiv = document.getElementById('promoError');

  // Set initial error message from session data
  if (promoInfo.error) {
      promoErrorDiv.innerText = promoInfo.error;
  }

  if (promoInput) {
      promoInput.addEventListener('input', debounce(function() {
          applyPromoCode();
      }, 500));
  }

  updateTotal(); // Initial calculation
  checkUrgentAvailability(); // Check urgent availability on load
});

function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}
</script>

  <?php include('link.php'); ?>
  <style>
    .price-breakdown { border: 1px solid #eee; padding: 15px; margin-bottom: 20px; border-radius: 8px; background-color: #f9f9f9; }
    .price-breakdown h4 { margin-top: 0; color: #333; border-bottom: 1px solid #ddd; padding-bottom: 10px; }
    .price-breakdown ul { list-style: none; padding: 0; margin: 0; }
    .price-breakdown li { display: flex; justify-content: space-between; padding: 5px 0; font-size: 15px; }
    .price-breakdown li span { color: #555; }
    input[type="radio"]:disabled + label { color: #999; }
    input[type="radio"]:disabled ~ div label { color: #999; }
    .promo-error { color: red; font-size: 13px; margin-top: 5px; }
  </style>
</head>

<body>
  <?php include('header.php'); ?>
 
  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>
    <div class="step-progress">
      <div class="step"><span class="number">01</span><span class="label">Applicant's Details</span></div>
      <div class="step active"><span class="number">02</span><span class="label">Choose Plan</span></div>
      <div class="step"><span class="number">03</span><span class="label">Add Document</span></div>
      <div class="step"><span class="number">04</span><span class="label">Review</span></div>
      <div class="step"><span class="number">05</span><span class="label">Payment</span></div>
    </div>
  </section>

  <div class="licenceform">
    <div class="container">
      <div class="main-form-container">
        <div class="form-container">
          <h2>Choose Plan</h2>
          <form method="post" action="step2.php">

            <div class="formfield">
              <label class="softhard-copy">
                <div class="span-soft">
                  <input type="radio" name="plan" value="Soft Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan'] === 'Soft Copy') ? 'checked' : 'checked' ?>>
                  <img src="assets/images/back.svg" alt="Soft">
                </div>
                <div><b>Soft Copy</b><br><small>Email delivery</small></div>
              </label>
             
              <label class="softhard-copy">
                <div class="span-soft">
                  <input type="radio" name="plan" value="Hard Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan'] === 'Hard Copy') ? 'checked' : '' ?>>
                  <img src="assets/images/back.svg" alt="Hard">
                </div>
                <div><b>Hard Copy</b><br><small>Home delivery</small></div>
              </label>
            </div>
            

            <label>Type *</label><br>
            <label><input type="radio" name="type" value="Normal" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type'] === 'Normal') ? 'checked' : 'checked' ?>> Normal</label>
            <label><input type="radio" id="urgentRadio" name="type" value="Urgent" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type'] === 'Urgent') ? 'checked' : '' ?>> Urgent</label>
            <br><br>

            <label>Where your license was issued *</label>
            <select id="license_issue_label" name="license_country" required>
                 <option value="">Select Country</option>
            </select><br><br>
            
            <label>Where do you intend to drive? *</label>
            <select id="drive_country" name="drive_country" required>
                 <option value="">Select Country</option>
            </select><br><br>

            <div class="pillbtn-wrap">
              <label class="pillbtn">Classes of Driving License *</label>
              <?php
              $classesMap = [
                  'A. Motorcycle' => ['icon' => 'Vector.svg', 'label' => 'A. Motorcycle'],
                  'B. Passenger car' => ['icon' => 'Vector-1.svg', 'label' => 'B. Passenger car'],
                  'C. Vehicle over 7,000 Pound' => ['icon' => '7000.svg', 'label' => 'C. Vehicle over 7,000 Pound'],
                  'D. Vehicle over 10 seats' => ['icon' => 'Vector-2.svg', 'label' => 'D. Vehicle over 10 seats'],
                  'E. B.C, or Class vehicle with trailer' => ['icon' => 'veh.svg', 'label' => 'E. B.C, or Class vehicle with trailer'],
              ];
              foreach ($classesMap as $key => $details) {
                  $checked = '';
                  if (isset($_SESSION['step2']['license_class']) && is_array($_SESSION['step2']['license_class'])) {
                      if (in_array($details['label'], $_SESSION['step2']['license_class'])) {
                          $checked = 'checked';
                      }
                  }
                  echo "<label><input type='checkbox' name='license_class[]' value='{$details['label']}' {$checked}> <img src='assets/images/{$details['icon']}' alt='{$details['label']}' style='vertical-align: middle; margin-right: 5px;'>&nbsp;{$details['label']}</label>";
              }
              ?>
            </div><br>

            <div class="productcard">
              <label>Products</label>
              <div class="productcard-wrap">
                <div class="formfield">
                  <label class="softhard-copy">
                    <div class="span-soft">
                      <input type="radio" name="productbooklet" value="Booklet" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet'] === 'Booklet') ? 'checked' : 'checked' ?>>
                      <img src="assets/card.png" height="200px" alt="Booklet">
                    </div>
                    <div><b>Booklet</b></div>
                  </label>
                </div>
                <div class="formfield">
                  <label class="softhard-copy">
                    <div class="span-soft">
                      <input type="radio" name="productbooklet" value="Booklet + Card" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet'] === 'Booklet + Card') ? 'checked' : '' ?>>
                      <img src="assets/slide.png" height="200px" alt="Booklet Plus Card">
                    </div>
                    <div><b>Booklet + Card</b></div>
                  </label>
                </div>
              </div>
            </div>

            <div class="productcard-validity">
              <div class="col-lg-12">
                  <label>Validity</label>
                  <select id="validity" name="validity" required>
                    <option value="">-- Select Validity --</option>
                    <?php
                        $selectedValidity = $_SESSION['step2']['validity'] ?? '';
                        $validityQuery = $conn->query("SELECT id, validity, price FROM addon_validity ORDER BY id ASC");
                        if ($validityQuery && $validityQuery->num_rows > 0) {
                            while ($row = $validityQuery->fetch_assoc()) {
                                $id = (int)$row['id'];
                                $validity = htmlspecialchars($row['validity']);
                                $price = (float)$row['price'];
                                $isSelected = ($selectedValidity == $id) ? 'selected' : '';
                                echo "<option value=\"$id\" data-price=\"$price\" $isSelected>$validity - \$$price</option>";
                            }
                        } else {
                            echo '<option value="">No validities available</option>';
                        }
                        ?>
                </select>
              </div><br>
            </div>

                <label>Add-ons</label>
                <div class="add-ons">
                <?php
                $addon_query = $conn->query("SELECT id, name, price FROM addon_products ORDER BY id ASC");
                if ($addon_query) {
                    while ($row = $addon_query->fetch_assoc()) {
                        $addon_name = htmlspecialchars($row['name']);
                        $addon_price = number_format((float)$row['price'], 2);
                        $checked = '';
                        
                        if (isset($_SESSION['step2']['addons']) && is_array($_SESSION['step2']['addons'])) {
                            if (in_array($addon_name, $_SESSION['step2']['addons'])) {
                                $checked = 'checked';
                            }
                        }
                
                        echo "<label><input type='checkbox' name='addons[]' value='{$addon_name}' {$checked}> {$addon_name} - \${$addon_price}</label>";
                    }
                } else {
                    echo "<p>No add-ons available</p>";
                }
                ?>
                </div><br>

            <label>Apply Promo Code</label><br>
            <input type="text" name="promo" placeholder="Promo code" value="<?= htmlspecialchars($promo_code_from_session) ?>">
            <div id="promoError" class="promo-error"><?= htmlspecialchars($_SESSION['step2']['promo_error'] ?? '') ?></div>
            <br>

            <div class="price-breakdown">
              <h4>Price Summary</h4>
              <ul>
                <li><span>Copy Type (Soft/Hard):</span> <strong id="breakdown-copy-price">$0.00</strong></li>
                <li><span>Processing Type (Normal/Urgent):</span> <strong id="breakdown-type-price">$0.00</strong></li>
                <li><span>Product Booklet/Card:</span> <strong id="breakdown-product-price">$0.00</strong></li>
                <li><span>Validity:</span> <strong id="breakdown-validity-price">$0.00</strong></li>
                <li><span>Add-ons:</span> <strong id="breakdown-addons-price">$0.00</strong></li>
                <li><span>Shipping:</span> <strong id="breakdown-shipping-price">$0.00</strong></li>
                <li><span>Discount:</span> <strong id="breakdown-discount">$0.00</strong></li>
              </ul>
            </div>
            
            <div style="text-align: right; font-size: 22px; font-weight: bold; border-top: 2px solid #333; padding-top: 10px;">
              Total: <strong id="totalAmount">$0.00</strong>
            </div>
            <input type="hidden" id="totalInput" name="total" value="0">
            <br>

            <div class="back-continue-button-wrap">
              <a href="index.php"><button type="button" class="first-btn-cicle">Back</button></a>
              <button type="submit" name="step2_submit" class="btn secondary-btn-circle">Verify & Continue</button>
            </div>
          </form>
        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>
      </div>
    </div>
  </div>
 <script>
document.addEventListener("DOMContentLoaded", function () {
  const countrySelect = document.getElementById("drive_country");
  const licenseIssueSelect = document.getElementById("license_issue_label");

  fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
      countries.forEach((c, index) => {
        const option1 = new Option(c.name, c.code);
        licenseIssueSelect.appendChild(option1);

        const option2 = new Option(c.name, c.code);
        countrySelect.appendChild(option2);

        const savedLicenseCountry = "<?= htmlspecialchars($_SESSION['step2']['license_country'] ?? '') ?>";
        if (savedLicenseCountry && c.code === savedLicenseCountry) {
            licenseIssueSelect.value = savedLicenseCountry;
        }
        
        const savedDriveCountry = "<?= htmlspecialchars($_SESSION['step2']['drive_country'] ?? '') ?>";
        if (savedDriveCountry && c.code === savedDriveCountry) {
            countrySelect.value = savedDriveCountry;
        }
      });
      
      if (!licenseIssueSelect.value && countries.length > 0) {
          licenseIssueSelect.value = countries[0].code;
      }
      if (!countrySelect.value && countries.length > 0) {
          countrySelect.value = countries[0].code;
      }

      updateTotal();
      checkUrgentAvailability(); 
    })
    .catch(err => console.error("Error loading countries:", err));
});
</script>

  <?php include('footer.php'); ?>
  <?php include('footerscript.php'); ?>
</body>

</html>