<?php include 'session.php'; ?>
<!DOCTYPE html>
<html>
<head>
    <title>Step 1 - Applicant's Details</title>
    <!-- <link rel="stylesheet" href="assets/css/style.css"> -->
    <link rel="stylesheet" href="styles.css">
    
</head>
<body>


<div class="topbar">
    <div class="topbar-left">
      UN Convention Approved | Urgent 15 -30 Mins Processing (Business Hours Only) | Recognized worldwide | No Test Required
    </div>
    <div class="topbar-right">
      <img src="https://flagcdn.com/gb.svg" alt="UK Flag" class="flag-icon">
      <span>English</span>
      <span class="arrow">&#9662;</span>
    </div>
  </div>

  <header class="navbar">
    <div class="navbar-container">
      <div class="logo">
        <img src="logo.png" alt="ITCA Logo">
      </div>

      <button class="hamburger" id="hamburger">
        ☰
      </button>

      <nav class="nav-links" id="navLinks">
        <a href="#">Home</a>
        <a href="#">Shipping & Fees</a>
        <a href="#">Countries</a>
        <a href="#">About</a>
        <a href="#">Contact Us</a>
        <a href="#">FAQ</a>
        <a href="#">Travel Guides</a>
        <div class="nav-buttons-mobile disable">
          <a href="#" class="btn orange">Get 20% Off</a>
          <a href="#" class="btn blue">Get Your IDP - €39</a>
        </div>
      </nav>

      <div class="nav-buttons desktop-only">
        <a href="#" class="btn orange">Get 20% Off</a>
        <a href="#" class="btn blue">Get Your IDP - €39</a>
      </div>
    </div>
  </header>
  <section class="step-section">
  <div class="step-header">
    <h1>Apply for International Driving License</h1>
    <p>Most accepted at the global level & trusted by travellers all around the world</p>
  </div>

  <div class="step-progress">
    <div class="step active">
      <span class="number">01</span>
      <span class="label">Applicant’s Details</span>
    </div>
    <div class="step">
      <span class="number">02</span>
      <span class="label">Choose Plan</span>
    </div>
    <div class="step">
      <span class="number">03</span>
      <span class="label">Add Document</span>
    </div>
    <div class="step">
      <span class="number">04</span>
      <span class="label">Shipping</span>
    </div>
    <div class="step">
      <span class="number">05</span>
      <span class="label">Review</span>
    </div>
    <div class="step">
      <span class="number">06</span>
      <span class="label">Payment</span>
    </div>
  </div>
</section>


<div class="container">
    <h2>Applicant’s Details</h2>
    <form method="post" action="save_step1.php">
        <div class="row">
            <div>
                <label>First Name *</label>
                <input type="text" name="first_name" required>
            </div>
            <div>
                <label>Last Name *</label>
                <input type="text" name="last_name" required>
            </div>
            <div>
                <label>Email *</label>
                <input type="email" name="email" required>
            </div>
            <div>
                <label>WhatsApp Number *</label>
                <input type="text" name="whatsapp" required>
            </div>
            <div style="flex: 1 1 100%;">
                <label>Date of Birth *</label>
                <div style="display: flex; gap: 10px;">
                    <input type="text" name="dob_month" placeholder="Month" required>
                    <input type="text" name="dob_day" placeholder="Day" required>
                    <input type="text" name="dob_year" placeholder="Year" required>
                </div>
            </div>
            <div>
                <label>Place of Birth *</label>
                <select name="birth_place" required>
                    <option value="India">India</option>
                    <option value="USA">USA</option>
                    <option value="UK">UK</option>
                </select>
            </div>
            <div style="flex: 1 1 100%;">
                <label>Permanent Place of Residence *</label>
                <select name="residence" required>
                    <option value="India">India</option>
                    <option value="USA">USA</option>
                    <option value="UK">UK</option>
                </select>
            </div>
            <div style="flex: 1 1 100%;">
                <label>Gender *</label>
                <div class="gender-group">
                    <label class="gender-box active" onclick="selectGender(this)">
                        <input type="radio" name="gender" value="Male" checked>
                        ♂ Male
                    </label>
                    <label class="gender-box" onclick="selectGender(this)">
                        <input type="radio" name="gender" value="Female">
                        ♀ Female
                    </label>
                </div>
            </div>
        </div>
        <button type="submit">Save & Continue ➜</button>
    </form>
</div>
<footer class="footer">
  <div class="footer-container">
    <div class="footer-top">
      <div class="footer-brand">
        <img src="https://i.ibb.co/3rgXfnf/itca-logo.png" alt="ITCA Logo">
        <p>Specialized in Translating Driver's Licenses</p>
        <p><span class="footer-icon">✉️</span> Email: support@e-itca.org</p>
      </div>

      <div class="footer-contact">
        <h4>CONTACT</h4>
        <ul>
          <li><img src="https://flagcdn.com/in.svg" alt=""> India: +91 98676 22637</li>
          <li><img src="https://flagcdn.com/us.svg" alt=""> USA: +1-587-288-3761</li>
          <li><img src="https://flagcdn.com/my.svg" alt=""> Malaysia: +60 102225401</li>
          <li><img src="https://flagcdn.com/tr.svg" alt=""> Turkey: +90 5385437764</li>
          <li><img src="https://flagcdn.com/mt.svg" alt=""> Malta: +356 9959 2634</li>
          <li><img src="https://flagcdn.com/fr.svg" alt=""> France: +33 758738498</li>
          <li><img src="https://flagcdn.com/ca.svg" alt=""> Canada: +1-587-288-3761</li>
        </ul>
        <div class="social-icons">
          <a href="#"><i>🌐</i></a>
          <a href="#"><i>📸</i></a>
          <a href="#"><i>💬</i></a>
          <a href="#"><i>🕊️</i></a>
          <a href="#"><i>▶️</i></a>
        </div>
      </div>

      <div class="footer-agents">
        <h4>AGENTS</h4>
        <ul>
          <li>USA</li>
          <li>Australia</li>
          <li>Canada</li>
          <li>Turkey</li>
          <li>Bulgaria</li>
          <li>UAE</li>
          <li>Chile</li>
          <li>Lithuania</li>
          <li>Thailand</li>
          <li>Russia</li>
          <li>India</li>
          <li>Italy</li>
        </ul>
      </div>

      <div class="footer-affiliates">
        <h4>OUR AFFILIATES</h4>
        <div class="affiliate-logos">
          <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Visa.svg" alt="Visa">
          <img src="https://upload.wikimedia.org/wikipedia/commons/b/b5/MasterCard_Logo.svg" alt="MasterCard">
          <img src="https://upload.wikimedia.org/wikipedia/commons/3/39/Paypal_logo.svg" alt="PayPal">
          <img src="https://1000logos.net/wp-content/uploads/2021/04/UPS-logo.png" alt="UPS">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1d/DHL_Logo.svg/2560px-DHL_Logo.svg.png" alt="DHL">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Hertz-Logo.png" alt="Hertz">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Alamo_Rent_A_Car_logo.svg/1280px-Alamo_Rent_A_Car_logo.svg.png" alt="Alamo">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Avis-logo.png" alt="Avis">
        </div>
        <div class="qr-section">
          <img src="https://i.ibb.co/fN8h6Lh/qr.png" alt="QR Code">
          <p>📱 SCAN TO CHAT</p>
        </div>
      </div>
    </div>

    <div class="footer-bottom">
      <p class="disclaimer">
        <strong>Disclaimer:</strong> International Driving Permit issued by ITCA is a translation of your driver’s license into 15 languages and we make no claim to be a government agency. An International Driving Permit is not a replacement for a driving license.
        The association issues the IDP based on the international united design of the UN Convention 1968 or 1949 to prevent any illegal situation while you are driving abroad.
      </p>
      <div class="footer-links">
        <a href="#">Terms of Use</a> |
        <a href="#">Privacy Policy</a> |
        <a href="#">Refund Policy</a> |
        <a href="#">Legal Notice</a>
      </div>
      <p>©2022 by ITCA - VAT NO 7690748865</p>
    </div>
  </div>
</footer>


<script>
  function selectGender(el) {
    document.querySelectorAll('.gender-box').forEach(box => box.classList.remove('active'));
    el.classList.add('active');
    el.querySelector('input').checked = true;
  }
</script>


<script>
  // Hamburger Toggle
  document.addEventListener('DOMContentLoaded', function () {
    const hamburger = document.querySelector('.hamburger');
    const navLinks = document.querySelector('.nav-links');

    if (hamburger && navLinks) {
      hamburger.addEventListener('click', function () {
        navLinks.classList.toggle('active');
      });
    }
  });
</script>






</body>
</html>
