<?php
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);

	session_start();
	include 'session.php';
	include 'db.php';


	if (!isset($_SESSION['order_id'])) {
            $_SESSION['order_id'] = 'GRN' . rand(100000, 999999);
        }
        $order_id = $_SESSION['order_id'];

	if (!isset($_SESSION['step1'])) {
    header("Location: step1.php");
    exit;
    } elseif (!isset($_SESSION['step2'])) {
        header("Location: step2.php");
        exit;
    } elseif (!isset($_SESSION['step3'])) {
        header("Location: step3.php");
        exit;
    } elseif (!isset($_SESSION['step4'])) {
        header("Location: step4.php");
        exit;
    }

	if (!isset($_SESSION['shipping_rate']) || !isset($_SESSION['product_price']) || !isset($_SESSION['total_price'])) {
		$_SESSION['shipping_error'] = "Please select a shipping method again.";
		header("Location: step4.php");
		exit;
	}

	$step1 = $_SESSION['step1'] ?? [];
	$step2 = $_SESSION['step2'] ?? [];
	$step3 = $_SESSION['step3'] ?? [];
	$step4 = $_SESSION['step4'] ?? [];

	$full_name       = $step1['full_name'] ?? 'N/A';
	$dob             = $step1['dob'] ?? 'N/A';
	$gender          = $step1['gender'] ?? 'N/A';
	$email           = $step1['email'] ?? 'N/A';
	$phone           = $step1['phone'] ?? 'N/A';
	$nationality     = $step1['nationality'] ?? 'N/A';
	$license_number  = $step1['license_number'] ?? 'N/A';
	$step1_birth_place = $step1['birth_place'] ?? 'N/A';
	$step1_permanent_place = $step1['permanent_place'] ?? 'N/A';

	$plan            = $step2['plan'] ?? 'N/A';
	$type            = $step2['type'] ?? 'N/A';
	$license_country = $step2['license_country'] ?? 'N/A';
	$drive_country   = $step2['drive_country'] ?? 'N/A';
	$license_class_arr = $step2['license_class'] ?? [];
	$license_class_str = !empty($license_class_arr) ? implode(',', $license_class_arr) : 'N/A';

	$addons_arr      = $step2['addons'] ?? [];
	$addons_str      = !empty($addons_arr) ? implode(',', $addons_arr) : 'None';
	$promo           = $step2['promo'] ?? 'N/A';
	$product         = $step2['productbooklet'] ?? 'N/A';
	$validity        = $step2['validity'] ?? '1 year';

	$passport_photo  = $step3['passport_photo'] ?? null;
	$license_front   = $step3['license_front'] ?? null;
	$license_back    = $step3['license_back'] ?? null;

	$ship_fname      = $step4['first_name'] ?? 'N/A';
	$ship_lname      = $step4['last_name'] ?? 'N/A';
	$ship_house      = $step4['ship_house'] ?? 'N/A';
	$ship_street     = $step4['ship_street'] ?? 'N/A';
	$ship_state      = $step4['state'] ?? 'N/A';
	$ship_zip        = $step4['zip'] ?? 'N/A';
	$ship_city       = $step4['city'] ?? 'N/A';
	$ship_country    = $step4['country_code'] ?? 'N/A';

	$productPrice  = floatval($_SESSION['product_price'] ?? 0.0);
	$shippingPrice = floatval($_SESSION['shipping_rate'] ?? 0.0);
	$total         = floatval($_SESSION['total_price'] ?? 0.0); 
	 

	if ($_SERVER['REQUEST_METHOD'] === 'POST') {
		if (!$conn) {
			die("Database connection failed in step5.");
		}

		$sql = "INSERT INTO applications (
		order_id, full_name, dob, gender, email, phone, nationality, license_number,
		plan, type, license_country, drive_country, license_class, addons, promo,
		passport_photo, license_front, license_back,
		ship_fname, ship_lname, street, state, zip, city, country,
		created_at, product, validity, status, shipping_price, total_price, ship_house
	) VALUES (
		?, ?, ?, ?, ?, ?, ?, ?,
		?, ?, ?, ?, ?, ?, ?,
		?, ?, ?,
		?, ?, ?, ?, ?, ?, ?,
		?, ?, ?, ?, ?, ?, ?
	)";

		$stmt = $conn->prepare($sql);

		if (!$stmt) {
			die("Prepare failed: (" . $conn->errno . ") " . $conn->error);
		}

		$created_at = date('Y-m-d H:i:s');
		$status = 'active';
		 

		$stmt->bind_param(
			"ssssssssssssssssssssssssssssssdd", 
			$order_id, // added
			$full_name, $dob, $gender, $email, $phone, $nationality, $license_number,
			$plan, $type, $license_country, $drive_country, $license_class_str, $addons_str, $promo,
			$passport_photo, $license_front, $license_back,
			$ship_fname, $ship_lname, $ship_street, $ship_state, $ship_zip, $ship_city, $ship_country,
			$created_at,
			$product, $validity, $status,
			$shippingPrice, $total,
			$ship_house
		);

		if (!$stmt->execute()) {
			die("Insert failed: " . $stmt->error);
		}

		$stmt->close();
		$conn->close();

		unset($_SESSION['step1'], $_SESSION['step2'], $_SESSION['step3'], $_SESSION['step4']);
		unset($_SESSION['product_price'], $_SESSION['shipping_rate'], $_SESSION['total_price'], $_SESSION['totalAmount']);

		header('Location: thankyou.php');
		exit;
	}


	$classesLabels = [
		'A' => 'Motorcycle', 'B' => 'Car', 'C' => 'Truck', 'D' => 'Bus',
	];
	$icons = [
		'A' => 'motorcycle.png', 'B' => 'car.png', 'C' => 'truck.png', 'D' => 'bus.png',
	];
	$iconsPath = 'assets/images/';

	 
	 
	?>



	<!DOCTYPE html>
	<html>

	<head>
	  <title>Step 5 - Review Details</title>
	  <meta name="viewport" content="width=device-width, initial-scale=1.0">

	  <?php include('link.php'); ?>

	  <style>
		.section {
			margin-bottom: 25px;
			padding: 15px;
			background-color: #f9f9f9;
			border: 1px solid #e0e0e0;
			border-radius: 8px;
		}
		.section h4 {
			margin-top: 0;
			color: #333;
			border-bottom: 2px solid #eee;
			padding-bottom: 5px;
			margin-bottom: 15px;
		}
		.section .value {
			margin-bottom: 12px;
			font-size: 15px;
			line-height: 1.5;
			color: #555;
		}
		.section .value .label {
			font-weight: bold;
			color: #222;
			margin-right: 8px;
			display: inline-block;
			min-width: 180px;
		}

		.uploaded-images img, .uploaded img {
			max-width: 100px;
			height: auto;
			border: 1px solid #ccc;
			border-radius: 4px;
			margin-top: 5px;
			margin-right: 10px;
			vertical-align: top;
		}
		.uploaded-images .value {
			display: flex;
			flex-direction: column;
		}
		.uploaded-images .label {
			 min-width: auto;
			 margin-bottom: 5px;
		}

		.suggestion-box {
		  margin-top: 30px;
		  padding: 20px;
		  background-color: #e0f7fa;
		  border-radius: 8px;
		  border-left: 5px solid #00bcd4;
		  text-align: center;
		}
		.suggestion-box img { margin-bottom: 15px; }
		.suggestion-box p { font-size: 16px; color: #333; margin-bottom: 20px; }
		.suggestion-box a {
		  display: inline-block;
		  padding: 12px 25px;
		  background-color: #007BFF;
		  color: white;
		  text-decoration: none;
		  border-radius: 5px;
		  font-weight: bold;
		  transition: background-color 0.3s ease;
		}
		.suggestion-box a:hover { background-color: #0056b3; }

		.stats-card.marg {
			margin-top: 20px;
			padding: 15px;
			font-size: 12px !important;
		}
		.stats-card.marg .uploaded {
			position: relative;
			text-align: left;
		}
		.username, .username2, .username3, .username4 {
			position: absolute;
			left: 80px;
			font-size: 10px;
			color: #444;
		}
		 .username4 {
			left: 80px;
			top: 55px;
		}
		.username4 img {
			max-width: 80px;
			height: auto;
			border: 1px solid #aaa;
			position: absolute;
			top: 50px;
			left: 10px;
		}

		.review .value span.label { min-width: 150px; }
		.review .uploaded-images img { max-width: 120px; margin-right: 15px; }
		.review .uploaded-images .value { margin-bottom: 15px; }

		.order-summary-shipping-price {
			font-size: 15px;
			line-height: 1.5;
			color: #555;
			margin-bottom: 12px;
		}
		.order-summary-shipping-price .label {
			font-weight: bold;
			color: #222;
			margin-right: 8px;
			display: inline-block;
			min-width: 180px;
		}
	  </style>
	</head>

	<body>
	  <?php include('header.php'); ?>

	  <section class="step-section steplicence">
		<div class="step-header">
		  <h1>Apply for International Driving License</h1>
		  <p>Most accepted at the global level & trusted by travellers all around the world</p>
		</div>

		<div class="step-progress">
		  <div class="step ">
			<span class="number">01</span>
			<span class="label">Applicant’s Details</span>
		  </div>
		  <div class="step ">
			<span class="number">02</span>
			<span class="label">Choose Plan</span>
		  </div>
		  <div class="step ">
			<span class="number">03</span>
			<span class="label">Add Document</span>
		  </div>
		  <div class="step ">
			<span class="number">04</span>
			<span class="label">Shipping</span>
		  </div>
		  <div class="step active">
			<span class="number">05</span>
			<span class="label">Review</span>
		  </div>
		  <div class="step">
			<span class="number">06</span>
			<span class="label">Payment</span>
		  </div>
		</div>
	  </section>

	  <div class="licenceform">
		<div class="container">
		  <div class="main-form-container">
			<div class="form-container review">

			  <h2>Review Details</h2>
			  <p>Please confirm the information you entered before submitting.</p>

			  <div class="section">
				<h4>Applicant’s Details</h4>
				
				
				
				<div class="value"><span class="label">Full Name:</span> <?= htmlspecialchars($full_name) ?></div>
				<div class="value"><span class="label">Date of Birth:</span> <?= htmlspecialchars($dob) ?></div>
				<div class="value"><span class="label">Gender:</span> <?= htmlspecialchars($gender) ?></div>
				<div class="value"><span class="label">Email:</span> <?= htmlspecialchars($email) ?></div>
				<div class="value"><span class="label">Phone:</span> <?= htmlspecialchars($phone) ?></div>
				<div class="value"><span class="label">Nationality:</span> <?= htmlspecialchars($nationality) ?></div>
				<div class="value"><span class="label">License Number:</span> <?= htmlspecialchars($license_number) ?></div>
				<div class="value"><span class="label">Country of License:</span> <?= htmlspecialchars($license_country) ?></div>
				<div class="value"><span class="label">Birth Place:</span> <?= htmlspecialchars($step1_birth_place) ?></div>
				<div class="value"><span class="label">Permanent Place of Residence:</span> <?= htmlspecialchars($step1_permanent_place) ?></div>
				<div class="value"><span class="label">Current Address - Street:</span> <?= htmlspecialchars($ship_street) ?></div>
				<div class="value"><span class="label">Current Address - State:</span> <?= htmlspecialchars($ship_state) ?></div>
				<div class="value"><span class="label">Current Address - ZIP:</span> <?= htmlspecialchars($ship_zip) ?></div>
				<div class="value"><span class="label">Current Address - City:</span> <?= htmlspecialchars($ship_city) ?></div>
				<div class="value"><span class="label">Current Address - Country:</span> <?= htmlspecialchars($ship_country) ?></div>
			  </div>

			  <div class="section">
				<h4>Choose Plan</h4>
				<div class="value"><span class="label">Plan:</span> <?= htmlspecialchars($plan) ?></div>
				<div class="value"><span class="label">Type:</span> <?= htmlspecialchars($type) ?></div>
				<div class="value"><span class="label">Country of License Issuance:</span> <?= htmlspecialchars($license_country) ?></div>
				<div class="value"><span class="label">Intended Country to Drive:</span> <?= htmlspecialchars($drive_country) ?></div>

				<div class="value"><span class="label">License Classes:</span>
				  <?php
				  if (!empty($license_class_arr)) {
					  $displayedClasses = [];
					  foreach ($license_class_arr as $cls) {
						  $label = isset($classesLabels[$cls]) ? $classesLabels[$cls] : $cls;
						  $iconFile = $icons[$cls] ?? '';
						  $iconHtml = '';
						  if ($iconFile && file_exists($iconsPath . $iconFile)) {
							  $iconHtml = '<img src="' . htmlspecialchars($iconsPath . $iconFile) . '" alt="' . htmlspecialchars($label) . '" style="width: 24px; height: 24px; vertical-align: middle; margin-right: 5px;">';
						  }
						  $displayedClasses[] = $iconHtml . htmlspecialchars($label);
					  }
					  echo implode(' | ', $displayedClasses);
				  } else {
					  echo "N/A";
				  }
				  ?>
				</div>

				<div class="value"><span class="label">Add-ons:</span>
                  <div style="display: flex; gap: 15px;">
                    <?php
                    foreach ($addons_arr as $addon) {
                        list($addonName, $addonImage) = explode('|', $addon);
                        echo '<div style="text-align:center;">';
                        echo '<img src="/dhl/admin/uploads/' . htmlspecialchars($addonImage) . '" width="60" alt="' . htmlspecialchars($addonName) . '"><br>';
                        echo '<span>' . htmlspecialchars($addonName) . '</span>';
                        echo '</div>';
                    }
                    ?>
                  </div>
                </div>

				<div class="value"><span class="label">Promo Code:</span> <?= htmlspecialchars($promo) ?></div>
				<div class="value"><span class="label">Product:</span> <?= htmlspecialchars($product) ?></div>
				<div class="value"><span class="label">Validity:</span> <?= htmlspecialchars($validity) ?></div>
			  </div>

			  <div class="section uploaded-images-wrap">
				<h4>Uploaded Documents</h4>
				<div class="uploaded-images">
				  <div class="value">
					<span class="label">Passport Photo:</span>
					<?php if (!empty($passport_photo) && file_exists('uploads/' . $passport_photo)): ?>
					  <img src="uploads/<?= htmlspecialchars($passport_photo) ?>" alt="Passport Photo">
					<?php else: ?>
					  N/A
					<?php endif; ?>
				  </div>
				  <div class="value">
					<span class="label">License Front:</span>
					<?php if (!empty($license_front) && file_exists('uploads/' . $license_front)): ?>
					  <img src="uploads/<?= htmlspecialchars($license_front) ?>" alt="License Front">
					<?php else: ?>
					  N/A
					<?php endif; ?>
				  </div>
				  <div class="value">
					<span class="label">License Back:</span>
					<?php if (!empty($license_back) && file_exists('uploads/' . $license_back)): ?>
					  <img src="uploads/<?= htmlspecialchars($license_back) ?>" alt="License Back">
					<?php else: ?>
					  N/A
					<?php endif; ?>
				  </div>
				</div>
			  </div>
			  
			  <div class="section">
				<h4>Tracking ID</h4>
				<div class="value">
					<span class="label">Order ID:</span>
					<span class="order-id">
                        <?= htmlspecialchars($order_id) ?>
                    </span>
				</div>
			</div>

			  <div class="section">
				<h4>Shipping Address</h4>
				<div class="value"><span class="label">Recipient Name:</span> <?= htmlspecialchars($ship_fname . ' ' . $ship_lname) ?></div>
				<div class="value"><span class="label">House/Flat/Block No.:</span> <?= htmlspecialchars($ship_house) ?></div>
				<div class="value"><span class="label">Street/Area:</span> <?= htmlspecialchars($ship_street) ?></div>
				<div class="value"><span class="label">City:</span> <?= htmlspecialchars($ship_city) ?></div>
				<div class="value"><span class="label">State/Region/Province:</span> <?= htmlspecialchars($ship_state) ?></div>
				<div class="value"><span class="label">ZIP/Postal Code:</span> <?= htmlspecialchars($ship_zip) ?></div>
				<div class="value"><span class="label">Country:</span> <?= htmlspecialchars($ship_country) ?></div>
			  </div>

			  <?php if (($step2['productbooklet'] ?? '') === 'Booklet') : ?>
				<div class="section bookletwithcard">
				  <h4>Booklet Only Product</h4>
				  <p>You have selected the <strong>Booklet Only</strong> product.</p>
				</div>
			  <?php endif; ?>

			  <div class="section">
				<h4>Order Summary</h4>
				<div class="order-summary-shipping-price"><span class="label">Product Price:</span> £<?= number_format($productPrice, 2) ?></div>
				<div class="order-summary-shipping-price">
					<span class="order-summary-shipping-price">Shipping Price:</span> £<?= number_format($shippingPrice, 2) ?>
				</div>
				<div class="order-summary-shipping-price"><strong><span class="label">Total Amount:</span> £<?= number_format($total, 2) ?></strong></div>
			  </div>

			  <form method="post" action="">
				<div class="back-continue-button-wrap">
				  <button type="button" class="first-btn-cicle" onclick="window.location.href='step4.php'">Back</button>

				  <input type="hidden" name="product_price_hidden" value="<?= number_format($productPrice, 2, '.', '') ?>">
				  <input type="hidden" name="shipping_price_hidden" value="<?= number_format($shippingPrice, 2, '.', '') ?>">
				  <input type="hidden" name="total_price_hidden" value="<?= number_format($total, 2, '.', '') ?>">

				  <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
				</div>
			  </form>

			</div>

			<div class="global-container">
			  <?php include('stats-card.php'); ?>

			  <?php if (($step2['productbooklet'] ?? '') === 'Booklet') : ?>
				<div class="suggestion-box">
				  <img src="assets/slide.png" alt="Upgrade offer" width="70%">
				  <p>Want more value? Switch to our premium <strong>Booklet + Card</strong> combo for a complete experience!</p>
				  <a href="step2.php?upgrade=booklet">Upgrade Your Product</a>
				</div>
			  <?php endif; ?>

			  <div class="stats-card marg uploaded-images-wrap">
				<h4>Uploaded Documents</h4>
				<div class="uploaded">
				  <div class="username"><?= htmlspecialchars($step1['full_name'] ?? '') ?></div>
				  <div class="username2"><?= htmlspecialchars($step1['nationality'] ?? '') ?></div>
				  <div class="username3"><?= htmlspecialchars($step1['dob'] ?? '') ?></div>
				  <?php if (!empty($passport_photo) && file_exists('uploads/' . $passport_photo)): ?>
					  <div class="username4"><img src="uploads/<?= htmlspecialchars($passport_photo) ?>" alt="Passport Photo Preview"></div>
				  <?php endif; ?>
				  <img src="certificate.jpg" alt="Sample Certificate" width="100%">
				</div>
			  </div>

			  <style>
				.marg { margin-top: 20px; display: flex; flex-direction: column; font-size: 8px !important; padding: 15px; }
				.uploaded { position: relative; text-align: left; }
				.username, .username2, .username3 { position: absolute; left: 80px; font-size: 10px; color: #444; }
				.username2 { top: 21.5px; } .username3 { top: 28px; }
				.username4 { position: absolute; left: 80px; top: 55px; font-size: 10px; }
				.username4 img { max-width: 80px; height: auto; border: solid 1px #aaa; position: absolute; top: -45px; left: 10px;}
			  </style>
			</div>
		  </div>
		</div>
	  </div>

	  <?php include('footer.php'); ?>
	  <?php include('footerscript.php'); ?>

	  <script>
		document.addEventListener("DOMContentLoaded", function () {
			const productPriceValue = parseFloat("<?= $productPrice ?>") || 0;
			let shippingPriceValue = parseFloat("<?= $shippingPrice ?>") || 0;

			const shippingInput = document.querySelector('input[name="shipping_price_hidden"]');
			const totalInput = document.querySelector('input[name="total_price_hidden"]');

			if (shippingInput) shippingInput.value = shippingPriceValue.toFixed(2);
			if (totalInput) totalInput.value = (productPriceValue + shippingPriceValue).toFixed(2);
		});
	  </script>
	</body>
	</html>