<?php
include 'session.php';
session_start();

// DHL credentials
$authToken = "Basic YXBKOG1ONHhONXlZNXI6QSQwc1UhMWdTJDd3TiE2bg==";
$endpoint = "https://express.api.dhl.com/mydhlapi/test/rates";

// Shipper data from session (step1), fallback to working values
$shipperPostal  = $_SESSION['step1']['zip'] ?? 'SL3 0BB';
$shipperCity    = $_SESSION['step1']['city'] ?? 'Colnbrook';
$shipperCountry = strtoupper(substr($_SESSION['step1']['country'] ?? 'GB', 0, 2));
$shipperStreet  = $_SESSION['step1']['street'] ?? '123 Main Street';

// Read receiver data from JS fetch
$rawData = file_get_contents("php://input");
$data = json_decode($rawData, true);

if (!$data || !isset($data['receiverDetails'])) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid or missing receiver data"]);
    exit;
}

$receiver = $data['receiverDetails'];
$receiverPostal  = $receiver['postalCode'] ?? '14800';
$receiverCity    = $receiver['cityName'] ?? 'Prague';
$receiverCountry = strtoupper(substr($receiver['countryCode'] ?? 'CZ', 0, 2));
$receiverStreet  = $receiver['addressLine1'] ?? '1 Champs Elysees';
$receiverStreet2 = $receiver['addressLine2'] ?? 'Floor 2';
$receiverStreet3 = $receiver['addressLine3'] ?? 'Building B';

// Build DHL request payload
$requestData = [
    'customerDetails' => [
        'shipperDetails' => [
            'postalCode'    => $shipperPostal,
            'cityName'      => $shipperCity,
            'countryCode'   => $shipperCountry,
            'addressLine1'  => $shipperStreet,
            'addressLine2'  => 'Address 2',
            'addressLine3'  => 'Address 3',
        ],
        'receiverDetails' => [
            'postalCode'    => $receiverPostal,
            'cityName'      => $receiverCity,
            'countryCode'   => $receiverCountry,
            'addressLine1'  => $receiverStreet,
            'addressLine2'  => $receiverStreet2,
            'addressLine3'  => $receiverStreet3,
        ]
    ],
    'accounts' => [
        [
            'typeCode' => 'shipper',
            'number'   => '425959129'
        ]
    ],
    'productCode' => 'P',
    'plannedShippingDateAndTime' => date('c'), // Current ISO date
    'unitOfMeasurement' => 'metric',
    'isCustomsDeclarable' => true, 
    'monetaryAmount' => [
        [
            'typeCode' => 'declaredValue',
            'value'    => 100,
            'currency' => 'USD'
        ]
    ],
    'packages' => [
        [
            'weight' => 10.5,
            'dimensions' => [
                'length' => 25,
                'width'  => 35,
                'height' => 15
            ]
        ]
    ]
];

// Call DHL API
try {
    $response = getDhlRates($requestData, $endpoint, $authToken);
    echo json_encode($response);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => $e->getMessage()]);
}


// -------------------------
// DHL Request Function
// -------------------------
function getDhlRates(array $data, string $endpoint, string $authToken): array {
    $ch = curl_init();

    curl_setopt_array($ch, [
        CURLOPT_URL => $endpoint,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => [
            "Authorization: $authToken",
            "Content-Type: application/json"
        ]
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception("cURL Error: " . curl_error($ch));
    }

    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200) {
        throw new Exception("DHL API returned HTTP code $httpCode. Response: $response");
    }

    return json_decode($response, true);
}
