<?php include 'session.php'; ?>
 
<!DOCTYPE html>
<html>

<head>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Step 1 - Applicant's Details</title>
  <?php include('link.php'); ?>
</head>

<body>
  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step active">
        <span class="number">01</span>
        <span class="label">Applicant’s Details</span>
      </div>
      <div class="step">
        <span class="number">02</span>
        <span class="label">Choose Plan</span>
      </div>
      <div class="step">
        <span class="number">03</span>
        <span class="label">Add Document</span>
      </div>
      <div class="step">
        <span class="number">04</span>
        <span class="label">Shipping</span>
      </div>
      <div class="step">
        <span class="number">05</span>
        <span class="label">Review</span>
      </div>
      <div class="step">
        <span class="number">06</span>
        <span class="label">Payment</span>
      </div>
    </div>
  </section>

  <div class="licenceform">
    <div class="container">
      <div class="main-form-container">
        <div class="form-container">
          <h2>Applicant’s Details</h2>
          <form method="post" action="save_step1.php">
            <div class="licenceform-row">
              <div class="formfield">
                <label>First Name *</label>
                <input type="text" name="first_name" required>
              </div>
              <div class="formfield">
                <label>Last Name *</label>
                <input type="text" name="last_name" required>
              </div>
              <div class="formfield">
                <label>Email *</label>
                <input type="email" name="email" required>
              </div>
              <div class="formfield">
                <label>WhatsApp Number *</label>
                <input type="text" name="whatsapp" required>
              </div>
              <div class="formfield">
                <label>Date of Birth *</label>
                <div style="display: flex; gap: 10px;">
                  <input type="text" name="dob_month" placeholder="Month" required>
                  <input type="text" name="dob_day" placeholder="Day" required>
                  <input type="text" name="dob_year" placeholder="Year" required>
                </div>
              </div>

              <!-- Dynamic Place of Birth -->
              <div class="formfield">
                <label>Place of Birth *</label>
                <input type="text" id="birth_place" name="birth_place" required placeholder="Start typing country...">
              </div>

              <!-- Dynamic Country -->
              <div class="formfield full-field">
                <label>Country *</label>
                <input type="text" id="country" name="country" required placeholder="Start typing country...">
              </div>

              <div class="formfield full-field">
                <label>Street Address *</label>
                <input type="text" name="street" required>
              </div>

              <div class="formfield full-field">
                <label>State / Region / Province *</label>
                <input type="text" name="state" required>
              </div>

              <!-- Google Maps Autocomplete for ZIP and City -->
              <div class="formfield full-field">
                <label>Search City / Address *</label>
                <input id="autocomplete" placeholder="Start typing your address..." type="text" />
              </div>

              <div class="formfield" style="display: flex; gap: 10px;">
                <div style="flex: 1;">
                  <label>ZIP *</label>
                  <input type="text" id="zip" name="zip" required readonly>
                </div>
                <div style="flex: 1;">
                  <label>City *</label>
                  <input type="text" id="city" name="city" required readonly>
                </div>
              </div>

              <div class="formfield full-field">
                <label>Permanent Place of Residence *</label>
                <select name="residence" required>
                  <option value="India">India</option>
                  <option value="USA">USA</option>
                  <option value="UK">UK</option>
                </select>
              </div>
              <div class="formfield">
                <label>Gender *</label>
                <div class="gender-group">
                  <label class="gender-box active" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Male" checked>
                    <img style="margin-bottom:6px;" src="assets/images/male.svg"><br> Male
                  </label>
                  <label class="gender-box" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Female">
                    <img style="margin-bottom:6px;" src="assets/images/female.svg"><br> Female
                  </label>
                </div>
              </div>
            </div>

            <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
          </form>
        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>
      </div>
    </div>
  </div>

  <?php include('footer.php'); ?>

  <script>
    function selectGender(el) {
      document.querySelectorAll('.gender-box').forEach(box => box.classList.remove('active'));
      el.classList.add('active');
      el.querySelector('input').checked = true;
    }
  </script>

  <script>
    // Hamburger Toggle
    document.addEventListener('DOMContentLoaded', function() {
      const hamburger = document.querySelector('.hamburger');
      const navLinks = document.querySelector('.nav-links');

      if (hamburger && navLinks) {
        hamburger.addEventListener('click', function() {
          navLinks.classList.toggle('active');
        });
      }
    });
  </script>

  <!-- Google Maps Autocomplete Script -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAvmSTf_7Az2bvice485L7FNMwiJ4D2l-4&libraries=places"></script>

  <script>
    let autocomplete, countryAutocomplete, birthPlaceAutocomplete;

    function initAutocomplete() {
      // City + ZIP autocomplete
      autocomplete = new google.maps.places.Autocomplete(
        document.getElementById('autocomplete'),
        { types: ['geocode'] }
      );

      autocomplete.setFields(['address_component']);
      autocomplete.addListener('place_changed', fillCityZip);

      // Country field
      countryAutocomplete = new google.maps.places.Autocomplete(
        document.getElementById('country'),
        { types: ['(regions)'] }
      );
      countryAutocomplete.setFields(['address_component']);
      countryAutocomplete.addListener('place_changed', function () {
        const place = countryAutocomplete.getPlace();
        const countryComp = place.address_components.find(comp => comp.types.includes('country'));
        if (countryComp) {
          document.getElementById('country').value = countryComp.long_name;
        }
      });

      // Birth Place field
      birthPlaceAutocomplete = new google.maps.places.Autocomplete(
        document.getElementById('birth_place'),
        { types: ['(regions)'] }
      );
      birthPlaceAutocomplete.setFields(['address_component']);
      birthPlaceAutocomplete.addListener('place_changed', function () {
        const place = birthPlaceAutocomplete.getPlace();
        const countryComp = place.address_components.find(comp => comp.types.includes('country'));
        if (countryComp) {
          document.getElementById('birth_place').value = countryComp.long_name;
        }
      });
    }

    function fillCityZip() {
      const place = autocomplete.getPlace();
      let zip = '', city = '';

      for (const component of place.address_components) {
        const types = component.types;
        if (types.includes('postal_code')) {
          zip = component.long_name;
        }
        if (types.includes('locality') || types.includes('sublocality')) {
          city = component.long_name;
        }
      }

      document.getElementById('zip').value = zip;
      document.getElementById('city').value = city;
    }

    document.addEventListener("DOMContentLoaded", function () {
      initAutocomplete();
    });
  </script>

  <?php include('footerscript.php'); ?>
</body>

</html>
