<!DOCTYPE html>
<html lang="en">

<head>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Step 1 - Applicant's Details</title>

</head>

<body>
  <?php include('header.php'); ?>
  <!-- Topbar -->
  <div class="topbar">
    <div class="topbar-left">
      UN Convention Approved | Urgent 15 -30 Mins Processing (Business Hours Only) | Recognized worldwide | No Test Required
    </div>
    <div class="topbar-right">
      <img src="https://flagcdn.com/gb.svg" alt="UK Flag" class="flag-icon">
      <span>English</span>
      <span class="arrow">&#9662;</span>
    </div>
  </div>

  <!-- Navbar -->
  <header class="navbar">
    <div class="navbar-container">
      <div class="logo">
        <img src="logo.png" alt="ITCA Logo">
      </div>

      <button class="hamburger" id="hamburger">
        ☰
      </button>

      <nav class="nav-links" id="navLinks">
        <a href="#">Home</a>
        <a href="#">Shipping & Fees</a>
        <a href="#">Countries</a>
        <a href="#">About</a>
        <a href="#">Contact Us</a>
        <a href="#">FAQ</a>
        <a href="#">Travel Guides</a>
        <div class="nav-buttons-mobile disable">
          <a href="#" class="btn orange">Get 20% Off</a>
          <a href="#" class="btn blue">Get Your IDP - €39</a>
        </div>
      </nav>

      <div class="nav-buttons desktop-only">
        <a href="#" class="btn orange">Get 20% Off</a>
        <a href="#" class="btn blue">Get Your IDP - €39</a>
      </div>
    </div>
  </header>

  <!-- template -->
  <section class="step-section">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step active">
        <span class="number">01</span>
        <span class="label">Applicant’s Details</span>
      </div>
      <div class="step">
        <span class="number">02</span>
        <span class="label">Choose Plan</span>
      </div>
      <div class="step">
        <span class="number">03</span>
        <span class="label">Add Document</span>
      </div>
      <div class="step">
        <span class="number">04</span>
        <span class="label">Shipping</span>
      </div>
      <div class="step">
        <span class="number">05</span>
        <span class="label">Review</span>
      </div>
      <div class="step">
        <span class="number">06</span>
        <span class="label">Payment</span>
      </div>
    </div>
  </section>

  <div class="content">

    <div class="leftcontent">


      <div class="form-step step-1">
        <section class="form-section">
          <h2>Applicant’s Details</h2>
          <form class="form-grid">
            <div class="form-group">
              <label>First Name *</label>
              <input type="text" required>
            </div>
            <div class="form-group">
              <label>Last Name *</label>
              <input type="text" required>
            </div>
            <div class="form-group">
              <label>Email *</label>
              <input type="email" required>
            </div>
            <div class="form-group">
              <label>WhatsApp Number *</label>
              <input type="text" required>
            </div>
            <div class="form-group dob-group">
              <label>Date of Birth *</label>
              <div class="dob-fields">
                <input type="text" placeholder="Month" required>
                <input type="text" placeholder="Day" required>
                <input type="text" placeholder="Year" required>
              </div>
            </div>
            <div class="form-group">
              <label>Place of Birth *</label>
              <select required>
                <option>🇮🇳 India</option>
                <option>🇺🇸 USA</option>
                <option>🇬🇧 UK</option>
              </select>
            </div>
            <div class="form-group full-width">
              <label>Permanent Place of Residence *</label>
              <select required>
                <option>🇮🇳 India</option>
                <option>🇺🇸 USA</option>
                <option>🇬🇧 UK</option>
              </select>
            </div>

            <div class="form-group full-width">
              <label>Gender *</label>
              <div class="gender-options">
                <label class="gender-box active">
                  <input type="radio" name="gender" value="male" checked hidden>
                  <div class="gender-icon">♂️</div>
                  <div>Male</div>
                </label>
                <label class="gender-box">
                  <input type="radio" name="gender" value="female" hidden>
                  <div class="gender-icon">♀️</div>
                  <div>Female</div>
                </label>
              </div>
            </div>

            <div class="form-group full-width">
              <button type="submit" class="continue-btn">Save & Continue →</button>
            </div>
          </form>
        </section>
      </div>

      <div class="form-step step-2" style="display:none;">


        <form method="post" action="step2_save.php">
          <div class="container">
            <!-- Form Section -->
            <div class="form-section">
              <h2>Choose Plan</h2>

              <!-- Plans -->
              <div class="plans">
                <div class="plan">
                  <input type="radio" id="soft" name="plan_type" value="soft" checked>
                  <label for="soft">
                    <img src="soft-copy.jpg" alt="Soft Copy" width="100">
                    <p><strong>Soft Copy</strong><br>We will email your IDP</p>
                  </label>
                </div>
                <div class="plan">
                  <input type="radio" id="hard" name="plan_type" value="hard">
                  <label for="hard">
                    <img src="hard-copy.jpg" alt="Hard Copy" width="100">
                    <p><strong>Hard Copy</strong><br>Delivered at your doorstep</p>
                  </label>
                </div>
              </div>

              <!-- Type -->
              <label><strong>Type *</strong></label><br>
              <input type="radio" name="urgency" value="normal" checked> Normal
              <input type="radio" name="urgency" value="urgent"> Urgent

              <!-- Country Dropdown -->
              <div>
                <label for="country-issued">Where your license was issued *</label><br>
                <select id="country-issued" class="dropdown" name="country_issued" required>
                  <option value="in">India</option>
                  <option value="us">USA</option>
                  <option value="uk">UK</option>
                  <option value="ca">Canada</option>
                  <option value="au">Australia</option>
                  <option value="ae">UAE</option>
                  <option value="de">Germany</option>
                  <option value="fr">France</option>
                  <option value="it">Italy</option>
                  <option value="es">Spain</option>
                  <option value="my">Malaysia</option>
                  <option value="sg">Singapore</option>
                </select>
              </div>

              <!-- Classes -->
              <label><strong>Classes of Driving License *</strong></label>
              <div class="classes">
                <div class="class-option">A. Motorcycle</div>
                <div class="class-option">B. Passenger car</div>
                <div class="class-option">C. Vehicle over 7,000 lbs</div>
                <div class="class-option">D. Over 10 seats</div>
              </div>

              <!-- Add-ons -->
              <div class="addons">
                <div class="addon"><input type="checkbox" class="addon-check" name="addons[]" value="product1" data-price="24"> Product One <span>$24</span></div>
                <div class="addon"><input type="checkbox" class="addon-check" name="addons[]" value="product2" data-price="24"> Product Two <span>$24</span></div>
                <div class="addon"><input type="checkbox" class="addon-check" name="addons[]" value="product3" data-price="24"> Product Three <span>$24</span></div>
                <div class="addon"><input type="checkbox" class="addon-check" name="addons[]" value="product4" data-price="24"> Product Four <span>$24</span></div>
              </div>

              <!-- Promo -->
              <input type="text" class="dropdown" name="promo_code" placeholder="Apply promo code">

              <!-- Total -->
              <div class="total">Total: $<span id="total-amount">24</span></div>

              <!-- Buttons -->
              <div class="buttons">
                <button type="button" class="btn back" onclick="history.back()">Back</button>
                <button type="submit" class="btn">Save & Continue</button>
              </div>
            </div>

            <!-- Sidebar -->

          </div>
        </form>

      </div>



    </div>

    <div class="rightcontent">
      <div class="stats-card">

        <div class="stats-list">

          <div class="stat-item">
            <div class="icon">🌐</div>
            <div>
              <div class="stat-number">150+</div>
              <div class="stat-label">Countries</div>
            </div>
          </div>
          <div class="stat-item">
            <div class="icon">👍</div>
            <div>
              <div class="stat-number">85k+</div>
              <div class="stat-label">Happy Clients</div>
            </div>
          </div>
          <div class="stat-item">
            <div class="icon">✅</div>
            <div>
              <div class="stat-number">8500+</div>
              <div class="stat-label">IDP Issued</div>
            </div>
          </div>
        </div>
        <div class="stats-image">
          <!-- Replace with an actual globe SVG/image if desired -->
          <img src="globe-placeholder.png" alt="Globe illustration">
        </div>
      </div>
    </div>


  </div>




  <!-- template closed -->

  <!-- Footer -->
  <footer class="footer">
    <div class="footer-container">
      <div class="footer-top">
        <div class="footer-brand">
          <img src="https://i.ibb.co/3rgXfnf/itca-logo.png" alt="ITCA Logo">
          <p>Specialized in Translating Driver's Licenses</p>
          <p><span class="footer-icon">✉️</span> Email: support@e-itca.org</p>
        </div>

        <div class="footer-contact">
          <h4>CONTACT</h4>
          <ul>
            <li><img src="https://flagcdn.com/in.svg" alt=""> India: +91 98676 22637</li>
            <li><img src="https://flagcdn.com/us.svg" alt=""> USA: +1-587-288-3761</li>
            <li><img src="https://flagcdn.com/my.svg" alt=""> Malaysia: +60 102225401</li>
            <li><img src="https://flagcdn.com/tr.svg" alt=""> Turkey: +90 5385437764</li>
            <li><img src="https://flagcdn.com/mt.svg" alt=""> Malta: +356 9959 2634</li>
            <li><img src="https://flagcdn.com/fr.svg" alt=""> France: +33 758738498</li>
            <li><img src="https://flagcdn.com/ca.svg" alt=""> Canada: +1-587-288-3761</li>
          </ul>
          <div class="social-icons">
            <a href="#"><i>🌐</i></a>
            <a href="#"><i>📸</i></a>
            <a href="#"><i>💬</i></a>
            <a href="#"><i>🕊️</i></a>
            <a href="#"><i>▶️</i></a>
          </div>
        </div>

        <div class="footer-agents">
          <h4>AGENTS</h4>
          <ul>
            <li>USA</li>
            <li>Australia</li>
            <li>Canada</li>
            <li>Turkey</li>
            <li>Bulgaria</li>
            <li>UAE</li>
            <li>Chile</li>
            <li>Lithuania</li>
            <li>Thailand</li>
            <li>Russia</li>
            <li>India</li>
            <li>Italy</li>
          </ul>
        </div>

        <div class="footer-affiliates">
          <h4>OUR AFFILIATES</h4>
          <div class="affiliate-logos">
            <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Visa.svg" alt="Visa">
            <img src="https://upload.wikimedia.org/wikipedia/commons/b/b5/MasterCard_Logo.svg" alt="MasterCard">
            <img src="https://upload.wikimedia.org/wikipedia/commons/3/39/Paypal_logo.svg" alt="PayPal">
            <img src="https://1000logos.net/wp-content/uploads/2021/04/UPS-logo.png" alt="UPS">
            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1d/DHL_Logo.svg/2560px-DHL_Logo.svg.png" alt="DHL">
            <img src="https://1000logos.net/wp-content/uploads/2017/03/Hertz-Logo.png" alt="Hertz">
            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Alamo_Rent_A_Car_logo.svg/1280px-Alamo_Rent_A_Car_logo.svg.png" alt="Alamo">
            <img src="https://1000logos.net/wp-content/uploads/2017/03/Avis-logo.png" alt="Avis">
          </div>
          <div class="qr-section">
            <img src="https://i.ibb.co/fN8h6Lh/qr.png" alt="QR Code">
            <p>📱 SCAN TO CHAT</p>
          </div>
        </div>
      </div>

      <div class="footer-bottom">
        <p class="disclaimer">
          <strong>Disclaimer:</strong> International Driving Permit issued by ITCA is a translation of your driver’s license into 15 languages and we make no claim to be a government agency. An International Driving Permit is not a replacement for a driving license.
          The association issues the IDP based on the international united design of the UN Convention 1968 or 1949 to prevent any illegal situation while you are driving abroad.
        </p>
        <div class="footer-links">
          <a href="#">Terms of Use</a> |
          <a href="#">Privacy Policy</a> |
          <a href="#">Refund Policy</a> |
          <a href="#">Legal Notice</a>
        </div>
        <p>©2022 by ITCA - VAT NO 7690748865</p>
      </div>
    </div>
  </footer>

  <script src="script.js"></script>
  <script>
    document.querySelector('.continue-btn').addEventListener('click', function(e) {
      e.preventDefault();

      const data = {
        first_name: document.querySelector('input[type="text"]:nth-of-type(1)').value,
        last_name: document.querySelector('input[type="text"]:nth-of-type(2)').value,
        email: document.querySelector('input[type="email"]').value,
        whatsapp: document.querySelector('input[type="text"]:nth-of-type(3)').value,
        dob_month: document.querySelector('.dob-fields input[placeholder="Month"]').value,
        dob_day: document.querySelector('.dob-fields input[placeholder="Day"]').value,
        dob_year: document.querySelector('.dob-fields input[placeholder="Year"]').value,
        place_of_birth: document.querySelectorAll('select')[0].value,
        residence: document.querySelectorAll('select')[1].value,
        gender: document.querySelector('input[name="gender"]:checked').value
      };

      fetch('save_step1.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify(data)
        })
        .then(res => res.json())
        .then(response => {
          if (response.status === 'success') {
            document.querySelector('.form-step.step-1').style.display = 'none';
            document.querySelector('.form-step.step-2').style.display = 'block';
            document.querySelector('.step-progress .step:nth-child(2)').classList.add('active');
          } else {
            alert("Error saving data: " + response.message);
          }
        });
    });

    const totalAmountSidebar = document.getElementById('total-amount-sidebar');

    function updateTotal() {
      let total = basePrice;
      console.log(total);
      addonCheckboxes.forEach(checkbox => {
        if (checkbox.checked) {
          total += parseFloat(checkbox.dataset.price);
        }
      });
      totalAmountSpan.textContent = total.toFixed(2);
      totalAmountSidebar.textContent = total.toFixed(2);
    }
  </script>

</body>

</html>