<?php
session_start();
include 'session.php';


$step1 = $_SESSION['step1'] ?? [];
$step2 = $_SESSION['step2'] ?? [];
$step3 = $_SESSION['step3'] ?? [];
$step4 = $_SESSION['step4'] ?? [];
$step5 = $_SESSION['step5'] ?? [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  include 'db.php';
  $validity = $step2['validity'] ?? '1 year';
  $stmt = $conn->prepare("INSERT INTO applications (
        full_name, dob, gender, email, phone, nationality, license_number,
        plan, type, license_country, drive_country, license_class, addons, promo,
        passport_photo, license_front, license_back,
        ship_fname, ship_lname, street, state, zip, city, country,
        product, validity
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

  $license_class = isset($step2['license_class']) ? implode(', ', $step2['license_class']) : '';
  $addons = isset($step2['addons']) ? implode(', ', $step2['addons']) : '';

  $stmt->bind_param(
    "ssssssssssssssssssssssssss",
    $step1['full_name'],
    $step1['dob'],
    $step1['gender'],
    $step1['email'],
    $step1['phone'],
    $step1['nationality'],
    $step1['license_number'],
    $step2['plan'],
    $step2['type'],
    $step2['license_country'],
    $step2['drive_country'],
    $license_class,
    $addons,
    $step2['promo'],
    $step3['passport_photo'],
    $step3['license_front'],
    $step3['license_back'],
    $step4['first_name'],
    $step4['last_name'],
    $step4['street'],
    $step4['state'],
    $step4['zip'],
    $step4['city'],
    $step4['country'],
    $step2['productbooklet'],
    $validity

  );

  $stmt->execute();
  $stmt->close();
  $conn->close();

  header('Location: thankyou.php');
  exit;
}
?>

<!DOCTYPE html>
<html>

<head>
  <title>Step 5 - Review Details</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <?php include('link.php'); ?>

  <style>
    .review-section {
      margin-bottom: 20px;
    }

    .review-section p {
      margin: 10px 0;
      font-size: 16px;
    }

    .suggestion-box {
      margin-top: 30px;
      padding: 20px;

      background-color: #fdfdfd;
      border-radius: 8px;
    }

    .suggestion-box h3 {
      margin-top: 0;
      color: #222;
    }

    .suggestion-box p {
      margin-bottom: 10px;
    }

    .suggestion-box a {
      display: inline-block;
      padding: 10px 15px;
      background-color: #007BFF;
      color: white;
      text-decoration: none;
      border-radius: 5px;
    }

    .suggestion-box a:hover {
      background-color: #0056b3;
    }
  </style>
</head>

<body>




  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step ">
        <span class="number">01</span>
        <span class="label">Applicant’s Details</span>
      </div>
      <div class="step ">
        <span class="number">02</span>
        <span class="label">Choose Plan</span>
      </div>
      <div class="step ">
        <span class="number">03</span>
        <span class="label">Add Document</span>
      </div>
      <div class="step ">
        <span class="number">04</span>
        <span class="label">Shipping</span>
      </div>
      <div class="step active">
        <span class="number">05</span>
        <span class="label">Review</span>
      </div>
      <div class="step">
        <span class="number">06</span>
        <span class="label">Payment</span>
      </div>
    </div>
  </section>



  <div class="licenceform">
    <div class="container">

      <div class="main-form-container">
        <div class="form-container review">

          <h2>Review Details</h2>
          <p>Please confirm the information you entered before submitting.</p>

          <!-- Step 1: Applicant Details -->
          <div class="section">
            <h4>Applicant’s Details</h4>
            <div class="value"><span class="label">Full Name:</span> <?= $step1['full_name'] ?? '' ?></div>
            <div class="value"><span class="label">DOB:</span> <?= $step1['dob'] ?? '' ?></div>
            <div class="value"><span class="label">Gender:</span> <?= $step1['gender'] ?? '' ?></div>
            <div class="value"><span class="label">Email:</span> <?= $step1['email'] ?? '' ?></div>
            <div class="value"><span class="label">Phone:</span> <?= $step1['phone'] ?? '' ?></div>
            <div class="value"><span class="label">Nationality:</span> <?= $step1['nationality'] ?? '' ?></div>
            <div class="value"><span class="label">License Number:</span> <?= $step1['license_number'] ?? '' ?></div>
          </div>

          <!-- Step 2: Plan Details -->
          <div class="section">
            <h4>Choose Plan</h4>
            <div class="value"><span class="label">Plan:</span> <?= $step2['plan'] ?? '' ?></div>
            <div class="value"><span class="label">Type:</span> <?= $step2['type'] ?? '' ?></div>
            <div class="value"><span class="label">Issued Country:</span> <?= $step2['license_country'] ?? '' ?></div>
            <div class="value"><span class="label">Intended Country:</span> <?= $step2['drive_country'] ?? '' ?></div>
            <div class="value"><span class="label">Classes:</span> <?= isset($step2['license_class']) ? implode(', ', $step2['license_class']) : '' ?></div>
            <div class="value"><span class="label">Add-ons:</span> <?= isset($step2['addons']) ? implode(', ', $step2['addons']) : 'None' ?></div>
            <div class="value"><span class="label">Promo Code:</span> <?= $step2['promo'] ?? 'N/A' ?></div>
          </div>

          <!-- Step 3: Documents -->
          <div class="section uploaded-images-wrap">
            <h4>Uploaded Documents</h4>
            <div class="uploaded-images">
              <div class="value"><span class="label">Passport Photo:</span>
                <img src="uploads/<?= $step3['passport_photo'] ?>">
              </div>
              <div class="value"><span class="label">License Front:</span>
                <img src="uploads/<?= $step3['license_front'] ?>">
              </div>
              <div class="value"><span class="label">License Back:</span>
                <img src="uploads/<?= $step3['license_back'] ?>">
              </div>
            </div>
          </div>



          <!-- Step 4: Shipping -->

          <!-- Booklet With Card Section (Conditional Display) -->
          <div class="section bookletwithcard" style="display: <?= (($step2['product'] ?? '') === 'Booklet') ? 'block' : 'none' ?>;">
            <h4>Booklet Only Information</h4>
            <p>This section is visible because you selected <strong>Booklet</strong> product.</p>
          </div>

          <div class="section">
            <h4>Shipping Address</h4>
            <div class="value"><span class="label">Name:</span> <?= $step4['first_name'] ?? '' ?> <?= $step4['last_name'] ?? '' ?></div>
            <div class="value"><span class="label">Street:</span> <?= $step4['street'] ?? '' ?></div>
            <div class="value"><span class="label">City:</span> <?= $step4['city'] ?? '' ?></div>
            <div class="value"><span class="label">State:</span> <?= $step4['state'] ?? '' ?></div>
            <div class="value"><span class="label">ZIP:</span> <?= $step4['zip'] ?? '' ?></div>
            <div class="value"><span class="label">Country:</span> <?= $step4['country'] ?? '' ?></div>
          </div>

          <!-- Buttons -->
          <form method="post" action="">
            <div class="back-continue-button-wrap">
              <button type="button" class="first-btn-cicle" onclick="goBack()">Back</button>
              <!-- Total -->
              <div style="text-align: right; font-size: 18px;">
                Total: <strong id="step4Total">$0</strong>
              </div><br>
              <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
            </div>
          </form>
        </div>
        <div class="global-container">
          <?php include('stats-card.php'); ?>

          <?php if (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet'] === 'Booklet') : ?>
            <div class="suggestion-box">
              <img src="assets/slide.png" width="70%">
              <p>Want more value? Switch to our premium <strong>Booklet + Card</strong> combo for a complete experience!</p>
              <a href="step2.php">Upgrade Your Product</a>
            </div>
          <?php endif; ?>
          <div class="stats-card marg uploaded-images-wrap">
            <h4>Uploaded Documents</h4>
            <div class="uploaded">
              <div class="username"><?= $step1['full_name'] ?? '' ?></div>
              <div class="username2"><?= $step1['nationality'] ?? '' ?></div>
              <div class="username3"><?= $step1['dob'] ?? '' ?></div>
              <div class="username4"> <img src="uploads/<?= $step3['passport_photo'] ?>"></div>
              <img src="certificate.jpg" width="100%">
            </div>
          </div>


          <style>
            .marg {
              margin-top: 10px;
              display: flex;
              flex-direction: column;
              font-size: 8px !important;
            }

            .username {
              position: absolute;
              top: 14px;
              left: 28px;
              font-size: 8px
            }

            .username2 {
              position: absolute;
              top: 21.5px;
              left: 28px;
              font-size: 8px
            }

            .username3 {
              position: absolute;
              top: 28px;
              left: 28px;
              font-size: 8px
            }

            .username4 {
              position: absolute;
              top: 55px;
              left: 84px;
              font-size: 10px
            }

            .uploaded {
              position: relative;
            }

            .username4 img {
              max-width: 60px;
              border: solid 1px black
            }
          </style>
        </div>

      </div>
    </div>




  </div>
  </div>

  <script>
    function goBack() {
      if (document.referrer !== "") {
        window.location.href = document.referrer;
      } else {
        window.history.back();
      }
    }
    // Hamburger Toggle
    document.addEventListener('DOMContentLoaded', function() {
      const hamburger = document.querySelector('.hamburger');
      const navLinks = document.querySelector('.nav-links');

      if (hamburger && navLinks) {
        hamburger.addEventListener('click', function() {
          navLinks.classList.toggle('active');
        });
      }
      // show the value from localStorage
      let savedTotal = localStorage.getItem("totalAmount");
      let savedPlan = localStorage.getItem("plan");

      let dhlRate = localStorage.getItem("dhl_rate");
      if (dhlRate) {
        dhlRate = JSON.parse(dhlRate);

        let totalAmount = parseFloat(savedTotal || 0) + parseFloat(dhlRate.price || 0);
        totalAmount = totalAmount.toFixed(2);
        document.getElementById("step4Total").innerText =
          "$" + totalAmount + " " + dhlRate.priceCurrency;

        localStorage.setItem("grandTotal", totalAmount);
      } else {
        console.log("No DHL rate found in localStorage");
        document.getElementById("step4Total").innerText = "$" + (savedTotal || 0);
      }

    });
  </script>
  <?php include('footer.php'); ?>
  <?php include('footerscript.php'); ?>
</body>

</html>