<?php
include 'session.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents("php://input"), true);

// Validate receiver data
$requiredFields = ['recFirstName', 'recLastName', 'postalCode', 'cityName', 'countryCode', 'recState', 'addressLine1'];
foreach ($requiredFields as $field) {
    if (empty($input['receiverDetails'][$field])) {
        echo json_encode(["status" => "error", "errors" => [$field => "This field is required."]]);
        exit;
    }
}

$receiver = $input['receiverDetails'];

// Check if session has origin address
if (!isset($_SESSION['step1'])) {
    echo json_encode(["status" => "error", "message" => "Missing origin address from session"]);
    exit;
}

$origin = $_SESSION['step1'];

// Prepare DHL API request (fixed)
$requestData = [
    "customerDetails" => [
        "shipperDetails" => [
            "postalCode"   => $origin['zip'],
            "cityName"     => $origin['city'],
            "countryCode"  => substr($origin['country'], 0, 2), // 2-letter code
            "addressLine1" => $origin['street']
        ],
        "receiverDetails" => [
            "postalCode"   => $receiver['postalCode'],
            "cityName"     => $receiver['cityName'],
            "countryCode"  => substr($receiver['countryCode'], 0, 2), // 2-letter code
            "addressLine1" => $receiver['addressLine1']
        ]
    ],
    "accounts" => [
        [
            "typeCode" => "shipper",
            "number"   => "425959129"  // your DHL test account number
        ]
    ],
    "productCode" => "P",
    "plannedShippingDateAndTime" => date('c', strtotime('+1 day')),
    "unitOfMeasurement" => "metric",
    "isCustomsDeclarable" => true,
    "monetaryAmount" => [
        [
            "typeCode" => "declaredValue",
            "value"    => 100,
            "currency" => "USD"
        ]
    ],
    "packages" => [
        [
            "weight" => 0.8,
            "dimensions" => [
                "length" => 30,
                "width"  => 22,
                "height" => 2
            ]
        ]
    ]
];

// Send request to DHL
try {
    $rates = getDhlRates($requestData);

    if (!isset($rates["products"]) || empty($rates["products"])) {
        echo json_encode([
            "status" => "error",
            "errors" => ["dhl" => "No products returned. Check your request."]
        ]);
        exit;
    }

    echo json_encode([
        "status" => "success",
        "data" => $rates
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}

// DHL API call function
function getDhlRates(array $data): array
{
    $endpoint = "https://express.api.dhl.com/mydhlapi/test/rates";
    $authToken = "Basic YXBKOG1ONHhONXlZNXI6QSQwc1UhMWdTJDd3TiE2bg=="; // your Basic Auth

    $payload = json_encode($data);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $endpoint,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => [
            "Authorization: $authToken",
            "Content-Type: application/json"
        ]
    ]);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        throw new Exception("cURL Error: " . curl_error($ch));
    }

    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200) {
        throw new Exception("DHL API returned HTTP code $httpCode. Response: $response");
    }

    return json_decode($response, true);
}
?>
