<?php
header('Content-Type: application/json');
include 'db.php'; // Your DB connection

// Get ZIP and country from query parameters
$zip = $_GET['zip'] ?? '';
$country = strtoupper($_GET['country'] ?? '');

if (!$zip || !$country) {
    echo json_encode(['error' => 'Missing ZIP or Country']);
    exit;
}

// --- DHL API settings for city only ---
$dhlKey = 'pAhLmsinCbAg43j0Cn7PKVkZZy4BO41l'; // Replace with your valid DHL key
$dhlEndpoint = "https://api.dhl.com/location-finder/v1/find-by-address?countryCode=$country&postalCode=$zip";

// Initialize cURL
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $dhlEndpoint,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "DHL-API-Key: $dhlKey",
        "Accept: application/json"
    ],
]);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Process DHL response
$city = '';
if ($httpCode === 200) {
    $data = json_decode($response, true);
    if (!empty($data['locations'])) {
        $location = $data['locations'][0]['place']['address'] ?? [];
        $city = $location['addressLocality'] ?? '';
    }
}

// --- Get state from DB based on country ---
$state = '';
$stmt = $conn->prepare("SELECT name FROM states WHERE country_id = ? LIMIT 1");
$stmt->bind_param("s", $country);
$stmt->execute();
$result = $stmt->get_result();
if ($row = $result->fetch_assoc()) {
    $state = $row['name'];
}

// Return JSON
echo json_encode([
    'city' => $city,
    'state' => $state
], JSON_PRETTY_PRINT);
