<?php
header('Content-Type: application/json');
include 'db.php';

$country_code = $_GET['country_id'] ?? '';
if (!$country_code) {
    echo json_encode([]);
    exit;
}

// Get numeric country id by ISO code
$stmt = $conn->prepare("SELECT id FROM countries WHERE shortname = ? LIMIT 1");
$stmt->bind_param("s", $country_code);
$stmt->execute();
$stmt->bind_result($country_id);
$stmt->fetch();
$stmt->close();

if (!$country_id) {
    echo json_encode([]);
    exit;
}

// Fetch states for this country
$stmt2 = $conn->prepare("SELECT id, name FROM states WHERE country_id = ?");
$stmt2->bind_param("i", $country_id);
$stmt2->execute();
$result = $stmt2->get_result();

$states = [];
while ($row = $result->fetch_assoc()) {
    $states[] = $row;
}

$stmt2->close();
echo json_encode($states);
?>
