<?php
session_start();

// Store Step 1 data
$_SESSION['step1'] = [
    'full_name' => trim($_POST['first_name'] . ' ' . $_POST['last_name']),
    'email' => $_POST['email'],
    'phone' => $_POST['whatsapp'],
    'dob' => $_POST['dob_year'] . '-' . $_POST['dob_month'] . '-' . $_POST['dob_day'],
    'gender' => $_POST['gender'],
    'nationality' => $_POST['residence'],
    'license_number' => $_POST['license_number'] ?? '',
    // Use hidden input for 2-letter ISO country code
    'country' => $_POST['country_code'] ?? '',
    'street' => $_POST['street'],
    'state' => $_POST['state'] ?? '',
    'zip' => $_POST['zip'],
    'city' => $_POST['city'],
    // Optional: store birth place code if needed
    'birth_place' => $_POST['birth_code'] ?? '',
    // Optional: store permanent place code if needed
    'permanent_place' => $_POST['permanent_code'] ?? ''
];

// Check if shipping fields are posted (Step 4)
if(isset($_POST['ship_street']) && isset($_POST['ship_house'])) {
    $_SESSION['step1']['shipping'] = [
        'first_name' => $_POST['ship_first_name'] ?? '',
        'last_name'  => $_POST['ship_last_name'] ?? '',
        'street'     => $_POST['ship_street'],
        'house'      => $_POST['ship_house'],
        'state'      => $_POST['ship_state'] ?? '',
        'zip'        => $_POST['ship_zip'] ?? '',
        'city'       => $_POST['ship_city'] ?? '',
        // Use hidden input for shipping 2-letter ISO country code
        'country'    => $_POST['ship_country_code'] ?? '',
    ];
}

// Optional: validate that country codes are set and 2 letters
if(empty($_SESSION['step1']['country']) || strlen($_SESSION['step1']['country']) !== 2) {
    die("Error: Invalid main country code.");
}
if(isset($_SESSION['step1']['shipping']) && 
   (empty($_SESSION['step1']['shipping']['country']) || strlen($_SESSION['step1']['shipping']['country']) !== 2)) {
    die("Error: Invalid shipping country code.");
}

// Redirect to next step
header("Location: step2.php");
exit;
