<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include('db.php');

// Enable exception reporting for mysqli
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
  // Step 1 Submission
  if (!isset($_SESSION['step1']) && isset($_POST['first_name'])) {
    $_SESSION['step1'] = $_POST;

    $full_name = $_POST['first_name'] . ' ' . $_POST['last_name'];
    $email = $_POST['email'];
    $phone = $_POST['whatsapp'];
    $dob = $_POST['dob_year'] . '-' . $_POST['dob_month'] . '-' . $_POST['dob_day'];
    $gender = $_POST['gender'];
    $country = $_POST['country'];
    $street = $_POST['street'];
    $state = $_POST['state'];
    $zip = $_POST['zip'];
    $city = $_POST['city'];

    $place_of_birth = $_POST['birth_place'];
    $residence = $_POST['residence'];
    $nationality = $residence;

    $sql = "INSERT INTO applications (full_name, email, phone, dob, gender, place_of_birth, nationality) 
                VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssss", $full_name, $email, $phone, $dob, $gender, $place_of_birth, $nationality);
    $stmt->execute();

    $_SESSION['application_id'] = $stmt->insert_id;
    $stmt->close();
  }

  // Step 2 Submission
  if (isset($_POST['step2_submit'])) {
    $_SESSION['step2'] = $_POST;

    if (isset($_POST['plan'])) {
      $_SESSION['copy_type'] = ($_POST['plan'] === 'Soft Copy') ? 'soft' : 'hard';
    }
    // Save total value in session
    if (isset($_POST['total'])) {
      $_SESSION['totalAmount'] = $_POST['total'];
    }

    header("Location: step3.php");
    exit;
  }

  if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $_SESSION['step2'] = $_POST;
  }

  // Get the latest row (or specific row if needed)
  $sql = "SELECT * FROM form_controll ORDER BY id DESC LIMIT 1";
  $result = $conn->query($sql);
  $prices = $result->fetch_assoc();
} catch (mysqli_sql_exception $e) {
  // Handle MySQLi error
  echo "Database error: " . $e->getMessage();
  exit;
}


?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title>Step 2 - Choose Plan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <script>
    const prices = {
      normal_type_price: <?= (float)$prices['normal_type_price'] ?>,
      urgent_type_price: <?= (float)$prices['urgent_type_price'] ?>,
      soft_copy_price: <?= (float)$prices['soft_copy_price'] ?>,
      hard_copy_price: <?= (float)$prices['hard_copy_price'] ?>,
      motorcyle_price: <?= (float)$prices['motorcyle_price'] ?>,
      passenger_car_price: <?= (float)$prices['passenger_car_price'] ?>,
      vehicle_over_price: <?= (float)$prices['vehicle_over_price'] ?>,
      vehicle_over_seats_price: <?= (float)$prices['vehicle_over_seats_price'] ?>,
      ebc_price: <?= (float)$prices['ebc_price'] ?>
    };

    function updateTotal() {
      let total = 0;

      // Type
      let type = document.querySelector('input[name="type"]:checked')?.value;
      total += (type === 'Normal') ? prices.normal_type_price : prices.urgent_type_price;


      // Validity
      let validity = parseInt(document.getElementById('validity')?.value || 0);
      total += validity;

      // Plan
      let copyType = document.querySelector('input[name="plan"]:checked')?.value;
      total += (copyType === 'Soft Copy') ? prices.soft_copy_price : prices.hard_copy_price;
        
      // Product Booklet
      let product = document.querySelector('input[name="productbooklet"]:checked')?.value;
      total += (product === 'Booklet') ? prices.motorcyle_price : prices.passenger_car_price;


      // Addons
      let addOns = document.querySelectorAll('input[name="addons[]"]:checked');
      total += addOns.length * prices.ebc_price;
     // Add DHL Rate from localStorage if available
    //  if(copyType==='Hard Copy'){
    //     let dhlRateData = localStorage.getItem("dhl_rate");
    //       if (dhlRateData) {
    //         try {
    //           let dhlRate = JSON.parse(dhlRateData);
    //           if (dhlRate && dhlRate.price) {
    //             total += parseFloat(dhlRate.price);
    //           }
    //         } catch (e) {
    //           console.error("Error parsing DHL Rate from localStorage:", e);
    //         }
    //       }    
        // document.getElementById("totalAmount").innerText = "$" + total.toFixed(2); 
    //  }
      
      document.getElementById("totalAmount").innerText = "$" + total.toFixed(2);     
      localStorage.setItem("totalAmount", total.toFixed(2));
      localStorage.setItem("plan", copyType);
    }

    document.addEventListener('DOMContentLoaded', function() {
      // Bind events
      document.querySelectorAll('input[name="type"]').forEach(e => e.addEventListener('change', updateTotal));
      document.getElementById('validity')?.addEventListener('change', updateTotal);
      document.querySelectorAll('input[name="plan"]').forEach(e => e.addEventListener('change', updateTotal));
      document.querySelectorAll('input[name="productbooklet"]').forEach(e => e.addEventListener('change', updateTotal));
      document.querySelectorAll('input[name="addons[]"]').forEach(e => e.addEventListener('change', updateTotal));

      // Disable Urgent on weekends
      const today = new Date();
      const day = today.getDay();
      if (day === 0 || day === 6) {
        const urgentRadio = document.getElementById('urgentRadio');
        if (urgentRadio) urgentRadio.disabled = true;
      }

      updateTotal();
    });
    

  </script>




  <?php include('link.php'); ?>
</head>

<body>
  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step"><span class="number">01</span><span class="label">Applicant's Details</span></div>
      <div class="step active"><span class="number">02</span><span class="label">Choose Plan</span></div>
      <div class="step"><span class="number">03</span><span class="label">Add Document</span></div>
      <!--<div class="step"><span class="number">04</span><span class="label">Shipping</span></div>-->
      <div class="step"><span class="number">04</span><span class="label">Review</span></div>
      <div class="step"><span class="number">05</span><span class="label">Payment</span></div>
    </div>
  </section>

  <div class="licenceform">
    <div class="container">
      <div class="main-form-container">
        <div class="form-container">
          <h2>Choose Plan</h2>
          <form method="post" action="step2.php">


            <!-- Copy Type -->
            <div class="productcard-wrap">
              <div class="formfield">
                <label class="softhard-copy">
                  <div class="span-soft">
                    <input type="radio" name="plan" value="Soft Copy" checked>
                    <img src="assets/images/back.svg" alt="Soft">
                  </div>
                  <div><b>Soft Copy</b><br><small>Email delivery</small></div>
                </label>
              </div>
              <div class="formfield">
                <label class="softhard-copy">
                  <div class="span-soft">
                    <input type="radio" name="plan" value="Hard Copy">
                    <img src="assets/images/back.svg" alt="Hard">
                  </div>
                  <div><b>Hard Copy</b><br><small>Home delivery</small></div>
                </label>
              </div>
            </div>

            <!-- Type -->
            <label>Type *</label><br>
            <input type="radio" name="type" value="Normal" checked> Normal
            <input type="radio" id="urgentRadio" name="type" value="Urgent"> Urgent
            <br><br>

            <!-- Country -->
            <label>Where your license was issued *</label>
            <select id="license_issue_label" name="license_country" required>
                 <option value="">Select Country</option>
            </select><br><br>
            
                <!-- Driving Destination -->
            <label>Where do you intend to drive? *</label>
            <select id="drive_country" name="drive_country" required>
                 <option value="">Select Country</option>
            </select><br><br>

            <!-- License Class -->
            <div class="pillbtn-wrap">
              <label class="pillbtn">Classes of Driving License *</label>
              <?php
              $classes = ['<img src="assets/images/Vector.svg">&nbsp;A. Motorcycle', '<img src="assets/images/Vector-1.svg">&nbsp;B. Passenger car', '<img src="assets/images/7000.svg">&nbsp;C. Vehicle over 7,000 Pound', '<img src="assets/images/Vector-2.svg">&nbsp;D. Vehicle over 10 seats', '<img src="assets/images/veh.svg">&nbsp;E. B.C, or Class vehicle with trailer'];
              foreach ($classes as $c) {
                echo "<label><input type='checkbox' name='license_class[]' value='$c'> $c</label>";
              }
              ?>
            </div><br>

            <!-- Product -->






            <div class="productcard">
              <label>Products</label>
              <div class="productcard-wrap">
                <div class="formfield">
                  <label class="softhard-copy">
                    <div class="span-soft">
                      <input type="radio" name="productbooklet" value="Booklet" checked>
                      <img src="assets/card.png" height="200px" alt="Booklet">
                    </div>
                    <?= (isset($_SESSION['productbooklet']) && $_SESSION['productbooklet'] === 'Booklet') ? 'checked' : '' ?>
                    <div><b>Booklet</b></div>
                  </label>
                </div>
                <div class="formfield">
                  <label class="softhard-copy">
                    <div class="span-soft">
                      <input type="radio" name="productbooklet" value="Booklet + Card">
                      <img src="assets/slide.png" height="200px" alt="Booklet Plus Card">
                    </div>
                    <?= (isset($_SESSION['productbooklet']) && $_SESSION['productbooklet'] === 'Booklet + Card') ? 'checked' : '' ?>
                    <div><b>Booklet + Card</b></div>
                  </label>
                </div>
              </div>
            </div>

            <!-- Validity -->
            <div class="productcard-validity">
              <div class="col-lg-12">
                <label>Validity</label>
                <select id="validity">
                  <option value="10">Validity 1 Year</option>
                  <option value="20">Validity 2 Years</option>
                  <option value="30">Validity 3 Years</option>
                </select>
              </div>
            </div><br>

            <!-- Add-ons -->
            <label>Add-ons</label>
            <div class="add-ons">
              <?php
              for ($i = 1; $i <= 4; $i++) {
                echo "<label><input type='checkbox' name='addons[]' value='Product $i'> Product $i - $24</label>";
              }
              ?>
            </div><br>

            <!-- Promo -->
            <label>Apply Promo Code</label><br>
            <input type="text" name="promo" placeholder="Promo code"><br><br>

            <!-- Total -->
            <div style="text-align: right; font-size: 18px;">
              Total: <strong id="totalAmount">$0</strong>
            </div>
            <input type="hidden" id="totalInput" name="total" value="0">
            <br>

            <!-- Buttons -->
            <div class="back-continue-button-wrap">
              <a href="index.php"><button type="button" class="first-btn-cicle">Back</button></a>
              <button type="submit" name="step2_submit" class="btn secondary-btn-circle">Verify & Continue</button>
            </div>
          </form>
        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>
      </div>
    </div>
  </div>
  <script>
//dynamic country
  const countrySelect = document.getElementById("drive_country");
  const license_issue_label = document.getElementById("license_issue_label");

  // Load countries on page load
  fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
      countries.forEach(c => {
        countrySelect.innerHTML += `<option value="${c.id}">${c.name}</option>`;
        license_issue_label.innerHTML += `<option value="${c.id}">${c.name}</option>`;
      });
    });
    

  </script>
  <?php include('footer.php'); ?>
  <?php include('footerscript.php'); ?>
</body>

</html>