<?php
include 'session.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $_SESSION['step4'] = $_POST;
    header('Location: step5.php');
    exit;
}
?>
<!DOCTYPE html>
<html>

<head>
  <title>Step 4 - Shipping Address</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php include('link.php'); ?>
</head>

<body>

<?php include('header.php'); ?>

<section class="step-section steplicence">
  <div class="step-header">
    <h1>Apply for International Driving License</h1>
    <p>Most accepted at the global level & trusted by travellers all around the world</p>
  </div>
  <div class="step-progress">
    <div class="step"><span class="number">01</span><span class="label">Applicant’s Details</span></div>
    <div class="step"><span class="number">02</span><span class="label">Choose Plan</span></div>
    <div class="step"><span class="number">03</span><span class="label">Add Document</span></div>
    <div class="step active"><span class="number">04</span><span class="label">Shipping</span></div>
    <div class="step"><span class="number">05</span><span class="label">Review</span></div>
    <div class="step"><span class="number">06</span><span class="label">Payment</span></div>
  </div>
</section>

<div class="licenceform">
  <div class="container">
    <div class="main-form-container">
      <div class="form-container">
        <h2>Shipping Address</h2>
        <form method="post" action="">
          <div class="formfield step-four" style="display: flex; gap: 10px;">
            <div style="flex: 1;">
              <label>First Name *</label><br>
              <input type="text" name="first_name" required>
            </div>
            <div style="flex: 1;">
              <label>Last Name *</label><br>
              <input type="text" name="last_name" required>
            </div>
          </div><br>

          <div class="formfield full-field">
            <label>House / Flat / Block No</label>
            <input type="text" name="ship_house" required>
          </div><br>

          <div class="formfield full-field">
            <label>Apartment / Road / Area (Street Address) *</label>
            <input type="text" name="ship_street" required>
          </div><br>
<div class="formfield full-field">
          <!-- Country -->
          <label>Country *</label>
         <select id="country" required>
    <option value="" disabled selected>Select Country</option>
</select>
          <input type="hidden" id="country_hidden" name="country_code">
          </div><br><br>
<div class="formfield full-field">
          <!-- State / Region -->
          <label>State/Region/Province *</label><br>
          <input type="text" id="state" name="state">
</div><br><br>
          <!-- ZIP & City -->
          <div class="formfield" style="display: flex; gap: 10px;">
            <div style="flex: 1;">
              <label>ZIP *</label><br>
              <input type="text" id="zip" name="zip" required>
            </div>
            <div style="flex: 1;">
              <label>City *</label><br>
              <input type="text" id="city" name="city" readonly required>
            </div>
          </div><br>

          <!-- Buttons -->
          <div class="back-continue-button-wrap">
            <a href="step3.php"><button type="button" class="first-btn-cicle">Back</button></a>
            <button type="submit" id="getRatesBtn" class="btn secondary-btn-circle">Verify & Continue</button>
          </div>
        </form>
      </div>
      <div class="global-container">
        <?php include('stats-card.php'); ?>
      </div>
    </div>
  </div>
</div>

<?php include('footer.php'); ?>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const countrySelect = document.getElementById("country");
    const countryHidden = document.getElementById("country_hidden");
    const zipInput = document.getElementById("zip");
    const cityInput = document.getElementById("city");
    const stateInput = document.getElementById("state");
    const rateBtn = document.getElementById("getRatesBtn");
    let isProcessing = false;

    // Load countries dynamically
    fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
        countries.forEach(c => {
            const option = document.createElement("option");
            option.value = c.code; // ISO 2-letter code
            option.textContent = c.name;
            countrySelect.appendChild(option);
        });
    })
    .catch(err => console.error("Error loading countries:", err));

    // Update hidden input whenever country changes
    countrySelect.addEventListener("change", () => {
        countryHidden.value = countrySelect.value;
    });

    // ZIP → City/State auto-fill with debounce
    let typingTimer;
    const typingDelay = 500;
    zipInput.addEventListener("input", function () {
        clearTimeout(typingTimer);
        const zip = zipInput.value.trim();
        const country = countrySelect.value;
        if (!zip || !country) {
            cityInput.value = '';
            stateInput.value = '';
            return;
        }
        typingTimer = setTimeout(() => {
            fetch(`https://bdma.co.in/dhl/get_location.php?zip=${zip}&country=${country}`)
            .then(res => res.json())
            .then(data => {
                if (data.city) {
                    cityInput.value = data.city;
                    stateInput.value = data.state || '';
                } else {
                    cityInput.value = '';
                    stateInput.value = '';
                    alert(data.error || "City/State not found for this ZIP code.");
                }
            })
            .catch(err => {
                console.error("Failed to fetch location:", err);
                cityInput.value = '';
                stateInput.value = '';
                alert("Failed to fetch location from DHL API.");
            });
        }, typingDelay);
    });

    // DHL Rate API click handler
    rateBtn.addEventListener("click", function (e) {
        e.preventDefault();
        if (isProcessing) return;
        isProcessing = true;

        const recFirstName = document.querySelector("input[name='first_name']").value.trim();
        const recLastName = document.querySelector("input[name='last_name']").value.trim();
        const postalCode = zipInput.value.trim();
        const city = cityInput.value.trim();
        const countryCode = countryHidden.value.trim();
        const address = document.querySelector("input[name='ship_street']").value.trim();
        const state = stateInput.value.trim();

        if (!recFirstName || !recLastName || !postalCode || !city || !countryCode || !address || !state) {
            alert("Please fill all required fields.");
            isProcessing = false;
            return;
        }

        const requestData = {
            receiverDetails: {
                recFirstName,
                recLastName,
                postalCode,
                cityName: city,
                countryCode: countryCode,
                addressLine1: address,
                recState: state
            }
        };

        fetch("dhl_rate.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(requestData)
        })
        .then(res => res.json())
        .then(data => {
            console.log("DHL Response:", data);

            if (data.status === "error") {
                const errorMsg = data.errors
                  ? Object.entries(data.errors).map(([f, msg]) => `${f}: ${msg}`).join("\n")
                  : data.message || "Unknown error";
                alert("Validation Error:\n" + errorMsg);
                return;
            }

            const products = data.data.products || [];
            const totalPrices = products[0]?.totalPrice || [];

            // Find the BILLC rate
            const billcRate = totalPrices.find(p => p.currencyType === "BILLC");

            if (billcRate) {
                 
                localStorage.setItem("shipping_address", JSON.stringify(requestData));
                localStorage.setItem("dhl_rate", JSON.stringify(billcRate));
 
                alert(`
Shipping Details:
Name: ${recFirstName} ${recLastName}
Address: ${address}
City: ${city}
State: ${state}
ZIP: ${postalCode}
Country: ${countryCode}

Rate:
BILLC Rate Found: ${billcRate.price} ${billcRate.currencyType}
                `);

                window.location.href = "step5.php";
            } else {
                alert("No BILLC rate found.");
            }
        })
        .catch(err => {
            console.error("DHL API fetch error:", err);
            alert("Something went wrong with DHL API.");
        })
        .finally(() => { isProcessing = false; });
    });
});
</script>

 

</body>
</html>
