<!DOCTYPE html>
<html>
<head>
<link rel="stylesheet" href="styles.css">
<?php
session_start();

// DB connection
$conn = new mysqli("localhost", "root", "", "multistep_form");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}


if (!isset($_SESSION['step1']) && isset($_POST['first_name'])) {
    $_SESSION['step1'] = $_POST;

    $full_name = $_POST['first_name'] . ' ' . $_POST['last_name'];
    $email = $_POST['email'];
    $phone = $_POST['whatsapp'];
    $dob = $_POST['dob_year'] . '-' . $_POST['dob_month'] . '-' . $_POST['dob_day'];
    $gender = $_POST['gender'];
    $place_of_birth = $_POST['birth_place'];
    $residence = $_POST['residence'];
    $nationality = $residence;

    $sql = "INSERT INTO applications (full_name, email, phone, dob, gender, place_of_birth, nationality) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        die("SQL Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("sssssss", $full_name, $email, $phone, $dob, $gender, $place_of_birth, $nationality);

    if (!$stmt->execute()) {
        die("Insert failed: " . $stmt->error);
    }

    $_SESSION['application_id'] = $stmt->insert_id;
    $stmt->close();
}

// ✅ STEP 2 submission
if (isset($_POST['step2_submit'])) {
    $_SESSION['step2'] = $_POST;
    header("Location: step3.php");
    exit;
}
?>


<div class="topbar">
    <div class="topbar-left">
      UN Convention Approved | Urgent 15 -30 Mins Processing (Business Hours Only) | Recognized worldwide | No Test Required
    </div>
    <div class="topbar-right">
      <img src="https://flagcdn.com/gb.svg" alt="UK Flag" class="flag-icon">
      <span>English</span>
      <span class="arrow">&#9662;</span>
    </div>
  </div>

  <header class="navbar">
    <div class="navbar-container">
      <div class="logo">
        <img src="logo.png" alt="ITCA Logo">
      </div>

      <button class="hamburger" id="hamburger">
        ☰
      </button>

      <nav class="nav-links" id="navLinks">
        <a href="#">Home</a>
        <a href="#">Shipping & Fees</a>
        <a href="#">Countries</a>
        <a href="#">About</a>
        <a href="#">Contact Us</a>
        <a href="#">FAQ</a>
        <a href="#">Travel Guides</a>
        <div class="nav-buttons-mobile disable">
          <a href="#" class="btn orange">Get 20% Off</a>
          <a href="#" class="btn blue">Get Your IDP - €39</a>
        </div>
      </nav>

      <div class="nav-buttons desktop-only">
        <a href="#" class="btn orange">Get 20% Off</a>
        <a href="#" class="btn blue">Get Your IDP - €39</a>
      </div>
    </div>
  </header>
  <section class="step-section">
  <div class="step-header">
    <h1>Apply for International Driving License</h1>
    <p>Most accepted at the global level & trusted by travellers all around the world</p>
  </div>

  <div class="step-progress">
    <div class="step active">
      <span class="number">01</span>
      <span class="label">Applicant’s Details</span>
    </div>
    <div class="step">
      <span class="number">02</span>
      <span class="label">Choose Plan</span>
    </div>
    <div class="step">
      <span class="number">03</span>
      <span class="label">Add Document</span>
    </div>
    <div class="step">
      <span class="number">04</span>
      <span class="label">Shipping</span>
    </div>
    <div class="step">
      <span class="number">05</span>
      <span class="label">Review</span>
    </div>
    <div class="step">
      <span class="number">06</span>
      <span class="label">Payment</span>
    </div>
  </div>
</section>

    <title>Step 2 - Choose Plan</title>
   
    <script>
        function updateTotal() {
            let base = 24; // Base price
            let addOns = document.querySelectorAll('input[name="addons[]"]:checked');
            let total = base + addOns.length * 24;
            document.getElementById("totalAmount").innerText = "$" + total;
        }
    </script>
</head>
<body>
<div class="container-fluid">
    <h2>Choose Plan</h2>
    <form method="post" action="step2.php">

        <!-- Plan -->
        <div class="row" style="margin-bottom: 15px;">
            <div style="flex: 1 1 45%;">
                <label>
                    <input type="radio" name="plan" value="Soft Copy" checked>
                    <img src="soft.jpg" alt="Soft" style="width:100%;border:1px solid #ccc;border-radius:8px;">
                    <div><b>Soft Copy</b><br><small>Email delivery</small></div>
                </label>
            </div>
            <div style="flex: 1 1 45%;">
                <label>
                    <input type="radio" name="plan" value="Hard Copy">
                    <img src="hard.jpg" alt="Hard" style="width:100%;border:1px solid #ccc;border-radius:8px;">
                    <div><b>Hard Copy</b><br><small>Home delivery</small></div>
                </label>
            </div>
        </div>

        <!-- Type -->
        <label>Type *</label><br>
        <input type="radio" name="type" value="Normal" checked> Normal
        <input type="radio" name="type" value="Urgent"> Urgent <br><br>

        <!-- Country -->
        <label>Where your license was issued *</label>
        <select name="license_country" required>
            <option value="India">India</option>
            <option value="USA">USA</option>
            <option value="UK">UK</option>
        </select><br><br>

        <!-- Driving Destination -->
        <label>Where do you intend to drive? *</label>
        <select name="drive_country" required>
            <option value="India">India</option>
            <option value="USA">USA</option>
            <option value="UK">UK</option>
        </select><br><br>

        <!-- License Class -->
        <label>Classes of Driving License *</label><br>
        <?php
        $classes = ['A. Motorcycle', 'B. Passenger car', 'C. Vehicle over 7,000 Pound', 'D. Vehicle over 10 seats', 'E, B.C, or Class vehicle with trailer'];
        foreach ($classes as $c) {
            echo "<label><input type='checkbox' name='license_class[]' value='$c'> $c</label><br>";
        }
        ?>
        <br>

        <!-- Addons -->
        <label>Add-ons</label>
        <div style="border:1px solid #ddd; border-radius: 6px; padding: 15px;">
            <?php
            for ($i = 1; $i <= 4; $i++) {
                echo "<label><input type='checkbox' name='addons[]' value='Product $i' onchange='updateTotal()'> Product $i - \$24</label><br><br>";
            }
            ?>
        </div><br>

        <!-- Promo -->
        <label>Apply Promo Code</label><br>
        <input type="text" name="promo" placeholder="Promo code"><br><br>

        <!-- Total -->
        <div style="text-align: right; font-size: 18px;">
            Total: <strong id="totalAmount">$24</strong>
        </div><br>

        <!-- Buttons -->
        <div style="display: flex; justify-content: space-between;">
            <a href="step1.php"><button type="button" style="background:#00264d;">⬅ Back</button></a>
            <button type="submit" name="step2_submit">Save & Continue ➜</button>
        </div>
    </form>
</div>


<footer class="footer">
  <div class="footer-container">
    <div class="footer-top">
      <div class="footer-brand">
        <img src="https://i.ibb.co/3rgXfnf/itca-logo.png" alt="ITCA Logo">
        <p>Specialized in Translating Driver's Licenses</p>
        <p><span class="footer-icon">✉️</span> Email: support@e-itca.org</p>
      </div>

      <div class="footer-contact">
        <h4>CONTACT</h4>
        <ul>
          <li><img src="https://flagcdn.com/in.svg" alt=""> India: +91 98676 22637</li>
          <li><img src="https://flagcdn.com/us.svg" alt=""> USA: +1-587-288-3761</li>
          <li><img src="https://flagcdn.com/my.svg" alt=""> Malaysia: +60 102225401</li>
          <li><img src="https://flagcdn.com/tr.svg" alt=""> Turkey: +90 5385437764</li>
          <li><img src="https://flagcdn.com/mt.svg" alt=""> Malta: +356 9959 2634</li>
          <li><img src="https://flagcdn.com/fr.svg" alt=""> France: +33 758738498</li>
          <li><img src="https://flagcdn.com/ca.svg" alt=""> Canada: +1-587-288-3761</li>
        </ul>
        <div class="social-icons">
          <a href="#"><i>🌐</i></a>
          <a href="#"><i>📸</i></a>
          <a href="#"><i>💬</i></a>
          <a href="#"><i>🕊️</i></a>
          <a href="#"><i>▶️</i></a>
        </div>
      </div>

      <div class="footer-agents">
        <h4>AGENTS</h4>
        <ul>
          <li>USA</li>
          <li>Australia</li>
          <li>Canada</li>
          <li>Turkey</li>
          <li>Bulgaria</li>
          <li>UAE</li>
          <li>Chile</li>
          <li>Lithuania</li>
          <li>Thailand</li>
          <li>Russia</li>
          <li>India</li>
          <li>Italy</li>
        </ul>
      </div>

      <div class="footer-affiliates">
        <h4>OUR AFFILIATES</h4>
        <div class="affiliate-logos">
          <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Visa.svg" alt="Visa">
          <img src="https://upload.wikimedia.org/wikipedia/commons/b/b5/MasterCard_Logo.svg" alt="MasterCard">
          <img src="https://upload.wikimedia.org/wikipedia/commons/3/39/Paypal_logo.svg" alt="PayPal">
          <img src="https://1000logos.net/wp-content/uploads/2021/04/UPS-logo.png" alt="UPS">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1d/DHL_Logo.svg/2560px-DHL_Logo.svg.png" alt="DHL">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Hertz-Logo.png" alt="Hertz">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Alamo_Rent_A_Car_logo.svg/1280px-Alamo_Rent_A_Car_logo.svg.png" alt="Alamo">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Avis-logo.png" alt="Avis">
        </div>
        <div class="qr-section">
          <img src="https://i.ibb.co/fN8h6Lh/qr.png" alt="QR Code">
          <p>📱 SCAN TO CHAT</p>
        </div>
      </div>
    </div>

    <div class="footer-bottom">
      <p class="disclaimer">
        <strong>Disclaimer:</strong> International Driving Permit issued by ITCA is a translation of your driver’s license into 15 languages and we make no claim to be a government agency. An International Driving Permit is not a replacement for a driving license.
        The association issues the IDP based on the international united design of the UN Convention 1968 or 1949 to prevent any illegal situation while you are driving abroad.
      </p>
      <div class="footer-links">
        <a href="#">Terms of Use</a> |
        <a href="#">Privacy Policy</a> |
        <a href="#">Refund Policy</a> |
        <a href="#">Legal Notice</a>
      </div>
      <p>©2022 by ITCA - VAT NO 7690748865</p>
    </div>
  </div>
</footer>



<script>
  // Hamburger Toggle
  document.addEventListener('DOMContentLoaded', function () {
    const hamburger = document.querySelector('.hamburger');
    const navLinks = document.querySelector('.nav-links');

    if (hamburger && navLinks) {
      hamburger.addEventListener('click', function () {
        navLinks.classList.toggle('active');
      });
    }
  });
</script>

</body>
</html>
