<?php
session_start(); // ✅ Always start session before using $_SESSION

// For debug only, remove in production
// echo "<pre>";
// print_r($_SESSION);
// echo "</pre>";
// exit;

include 'session.php';

$step1 = $_SESSION['step1'] ?? [];
$step2 = $_SESSION['step2'] ?? [];
$step3 = $_SESSION['step3'] ?? [];
$step4 = $_SESSION['step4'] ?? [];
$step5 = $_SESSION['step5'] ?? [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include 'db.php';
    $stmt = $conn->prepare("INSERT INTO applications (
        full_name, dob, gender, email, phone, nationality, license_number,
        plan, type, license_country, drive_country, license_class, addons, promo,
        passport_photo, license_front, license_back,
        ship_fname, ship_lname, street, state, zip, city, country
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $license_class = isset($step2['license_class']) ? implode(', ', $step2['license_class']) : '';
    $addons = isset($step2['addons']) ? implode(', ', $step2['addons']) : '';

    $stmt->bind_param("ssssssssssssssssssssssss",
        $step1['full_name'], $step1['dob'], $step1['gender'], $step1['email'], $step1['phone'], $step1['nationality'], $step1['license_number'],
        $step2['plan'], $step2['type'], $step2['license_country'], $step2['drive_country'], $license_class, $addons, $step2['promo'],
        $step3['passport_photo'], $step3['license_front'], $step3['license_back'],
        $step4['first_name'], $step4['last_name'], $step4['street'], $step4['state'], $step4['zip'], $step4['city'], $step4['country']
    );
    $stmt->execute();
    $stmt->close();
    $conn->close();

    header('Location: thankyou.php');
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Step 5 - Review Details</title>

    
<link rel="stylesheet" href="styles.css">
    <style>
        .section {
            border: 1px solid #ddd;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 10px;
        }
        .section h3 {
            margin-top: 0;
        }
        .label {
            font-weight: bold;
        }
        .value {
            margin-bottom: 10px;
        }
    </style>
</head>
<body>



<div class="topbar">
    <div class="topbar-left">
      UN Convention Approved | Urgent 15 -30 Mins Processing (Business Hours Only) | Recognized worldwide | No Test Required
    </div>
    <div class="topbar-right">
      <img src="https://flagcdn.com/gb.svg" alt="UK Flag" class="flag-icon">
      <span>English</span>
      <span class="arrow">&#9662;</span>
    </div>
  </div>

  <header class="navbar">
    <div class="navbar-container">
      <div class="logo">
        <img src="logo.png" alt="ITCA Logo">
      </div>

      <button class="hamburger" id="hamburger">
        ☰
      </button>

      <nav class="nav-links" id="navLinks">
        <a href="#">Home</a>
        <a href="#">Shipping & Fees</a>
        <a href="#">Countries</a>
        <a href="#">About</a>
        <a href="#">Contact Us</a>
        <a href="#">FAQ</a>
        <a href="#">Travel Guides</a>
        <div class="nav-buttons-mobile disable">
          <a href="#" class="btn orange">Get 20% Off</a>
          <a href="#" class="btn blue">Get Your IDP - €39</a>
        </div>
      </nav>

      <div class="nav-buttons desktop-only">
        <a href="#" class="btn orange">Get 20% Off</a>
        <a href="#" class="btn blue">Get Your IDP - €39</a>
      </div>
    </div>
  </header>
  <section class="step-section">
  <div class="step-header">
    <h1>Apply for International Driving License</h1>
    <p>Most accepted at the global level & trusted by travellers all around the world</p>
  </div>

  <div class="step-progress">
    <div class="step active">
      <span class="number">01</span>
      <span class="label">Applicant’s Details</span>
    </div>
    <div class="step">
      <span class="number">02</span>
      <span class="label">Choose Plan</span>
    </div>
    <div class="step">
      <span class="number">03</span>
      <span class="label">Add Document</span>
    </div>
    <div class="step">
      <span class="number">04</span>
      <span class="label">Shipping</span>
    </div>
    <div class="step">
      <span class="number">05</span>
      <span class="label">Review</span>
    </div>
    <div class="step">
      <span class="number">06</span>
      <span class="label">Payment</span>
    </div>
  </div>
</section>
<div class="container-fluid">
    <h2>Review Details</h2>
    <p>Please confirm the information you entered before submitting.</p>

    <!-- Step 1: Applicant Details -->
    <div class="section">
        <h3>Applicant’s Details</h3>
        <div class="value"><span class="label">Full Name:</span> <?= $step1['full_name'] ?? '' ?></div>
        <div class="value"><span class="label">DOB:</span> <?= $step1['dob'] ?? '' ?></div>
        <div class="value"><span class="label">Gender:</span> <?= $step1['gender'] ?? '' ?></div>
        <div class="value"><span class="label">Email:</span> <?= $step1['email'] ?? '' ?></div>
        <div class="value"><span class="label">Phone:</span> <?= $step1['phone'] ?? '' ?></div>
        <div class="value"><span class="label">Nationality:</span> <?= $step1['nationality'] ?? '' ?></div>
        <div class="value"><span class="label">License Number:</span> <?= $step1['license_number'] ?? '' ?></div>
    </div>

    <!-- Step 2: Plan Details -->
    <div class="section">
        <h3>Choose Plan</h3>
        <div class="value"><span class="label">Plan:</span> <?= $step2['plan'] ?? '' ?></div>
        <div class="value"><span class="label">Type:</span> <?= $step2['type'] ?? '' ?></div>
        <div class="value"><span class="label">Issued Country:</span> <?= $step2['license_country'] ?? '' ?></div>
        <div class="value"><span class="label">Intended Country:</span> <?= $step2['drive_country'] ?? '' ?></div>
        <div class="value"><span class="label">Classes:</span> <?= isset($step2['license_class']) ? implode(', ', $step2['license_class']) : '' ?></div>
        <div class="value"><span class="label">Add-ons:</span> <?= isset($step2['addons']) ? implode(', ', $step2['addons']) : 'None' ?></div>
        <div class="value"><span class="label">Promo Code:</span> <?= $step2['promo'] ?? 'N/A' ?></div>
    </div>

    <!-- Step 3: Documents -->
    <div class="section">
        <h3>Uploaded Documents</h3>
        <div class="value"><span class="label">Passport Photo:</span><br>
            <img src="uploads/<?= $step3['passport_photo'] ?>" width="100">
        </div>
        <div class="value"><span class="label">License Front:</span><br>
            <img src="uploads/<?= $step3['license_front'] ?>" width="100">
        </div>
        <div class="value"><span class="label">License Back:</span><br>
            <img src="uploads/<?= $step3['license_back'] ?>" width="100">
        </div>
    </div>

    <!-- Step 4: Shipping -->
    <div class="section">
        <h3>Shipping Address</h3>
        <div class="value"><span class="label">Name:</span> <?= $step4['first_name'] ?? '' ?> <?= $step4['last_name'] ?? '' ?></div>
        <div class="value"><span class="label">Street:</span> <?= $step4['street'] ?? '' ?></div>
        <div class="value"><span class="label">City:</span> <?= $step4['city'] ?? '' ?></div>
        <div class="value"><span class="label">State:</span> <?= $step4['state'] ?? '' ?></div>
        <div class="value"><span class="label">ZIP:</span> <?= $step4['zip'] ?? '' ?></div>
        <div class="value"><span class="label">Country:</span> <?= $step4['country'] ?? '' ?></div>
    </div>

    <!-- Buttons -->
    <form method="post" action="">
        <div style="display: flex; justify-content: space-between;">
            <a href="step4.php"><button type="button" style="background:#00264d;">⬅ Back</button></a>
            <button type="submit">Verify & Continue ➜</button>
        </div>
    </form>
</div>
<footer class="footer">
  <div class="footer-container">
    <div class="footer-top">
      <div class="footer-brand">
        <img src="https://i.ibb.co/3rgXfnf/itca-logo.png" alt="ITCA Logo">
        <p>Specialized in Translating Driver's Licenses</p>
        <p><span class="footer-icon">✉️</span> Email: support@e-itca.org</p>
      </div>

      <div class="footer-contact">
        <h4>CONTACT</h4>
        <ul>
          <li><img src="https://flagcdn.com/in.svg" alt=""> India: +91 98676 22637</li>
          <li><img src="https://flagcdn.com/us.svg" alt=""> USA: +1-587-288-3761</li>
          <li><img src="https://flagcdn.com/my.svg" alt=""> Malaysia: +60 102225401</li>
          <li><img src="https://flagcdn.com/tr.svg" alt=""> Turkey: +90 5385437764</li>
          <li><img src="https://flagcdn.com/mt.svg" alt=""> Malta: +356 9959 2634</li>
          <li><img src="https://flagcdn.com/fr.svg" alt=""> France: +33 758738498</li>
          <li><img src="https://flagcdn.com/ca.svg" alt=""> Canada: +1-587-288-3761</li>
        </ul>
        <div class="social-icons">
          <a href="#"><i>🌐</i></a>
          <a href="#"><i>📸</i></a>
          <a href="#"><i>💬</i></a>
          <a href="#"><i>🕊️</i></a>
          <a href="#"><i>▶️</i></a>
        </div>
      </div>

      <div class="footer-agents">
        <h4>AGENTS</h4>
        <ul>
          <li>USA</li>
          <li>Australia</li>
          <li>Canada</li>
          <li>Turkey</li>
          <li>Bulgaria</li>
          <li>UAE</li>
          <li>Chile</li>
          <li>Lithuania</li>
          <li>Thailand</li>
          <li>Russia</li>
          <li>India</li>
          <li>Italy</li>
        </ul>
      </div>

      <div class="footer-affiliates">
        <h4>OUR AFFILIATES</h4>
        <div class="affiliate-logos">
          <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Visa.svg" alt="Visa">
          <img src="https://upload.wikimedia.org/wikipedia/commons/b/b5/MasterCard_Logo.svg" alt="MasterCard">
          <img src="https://upload.wikimedia.org/wikipedia/commons/3/39/Paypal_logo.svg" alt="PayPal">
          <img src="https://1000logos.net/wp-content/uploads/2021/04/UPS-logo.png" alt="UPS">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1d/DHL_Logo.svg/2560px-DHL_Logo.svg.png" alt="DHL">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Hertz-Logo.png" alt="Hertz">
          <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Alamo_Rent_A_Car_logo.svg/1280px-Alamo_Rent_A_Car_logo.svg.png" alt="Alamo">
          <img src="https://1000logos.net/wp-content/uploads/2017/03/Avis-logo.png" alt="Avis">
        </div>
        <div class="qr-section">
          <img src="https://i.ibb.co/fN8h6Lh/qr.png" alt="QR Code">
          <p>📱 SCAN TO CHAT</p>
        </div>
      </div>
    </div>

    <div class="footer-bottom">
      <p class="disclaimer">
        <strong>Disclaimer:</strong> International Driving Permit issued by ITCA is a translation of your driver’s license into 15 languages and we make no claim to be a government agency. An International Driving Permit is not a replacement for a driving license.
        The association issues the IDP based on the international united design of the UN Convention 1968 or 1949 to prevent any illegal situation while you are driving abroad.
      </p>
      <div class="footer-links">
        <a href="#">Terms of Use</a> |
        <a href="#">Privacy Policy</a> |
        <a href="#">Refund Policy</a> |
        <a href="#">Legal Notice</a>
      </div>
      <p>©2022 by ITCA - VAT NO 7690748865</p>
    </div>
  </div>
</footer>



<script>
  // Hamburger Toggle
  document.addEventListener('DOMContentLoaded', function () {
    const hamburger = document.querySelector('.hamburger');
    const navLinks = document.querySelector('.nav-links');

    if (hamburger && navLinks) {
      hamburger.addEventListener('click', function () {
        navLinks.classList.toggle('active');
      });
    }
  });
</script>

</body>
</html>
