<?php
include 'session.php';
/**
 * DHL Rate Request - Refactored Version
 */
// Defaults (from session)
$typeCode = "shipper";
$accNumber = "425959129";

$shipperPostal = $_SESSION['step1']['zip'] ?? '';
$shipperCity   = $_SESSION['step1']['city'] ?? '';
$shipperCountry = $_SESSION['step1']['country'] ?? '';
$shipperCountry2 = strtoupper(substr($shipperCountry, 0, 2));
$shipperStreet = $_SESSION['step1']['street'] ?? '';


// Read raw JSON body
$rawData = file_get_contents("php://input");
$data = json_decode($rawData, true);

if ($data && isset($data['receiverDetails'])) {
  // Extract receiver details
  $receiver = $data['receiverDetails'];
  $receiverPostal  = $receiver['postalCode'] ?? '';
  $receiverCity    = $receiver['cityName'] ?? '';
  $receiverCountry = $receiver['countryCode'] ?? '';
  $receiverCountry2 = strtoupper(substr($receiverCountry, 0, 2));
  $receiverStreet  = $receiver['addressLine1'] ?? '';
} else {
  echo "No valid JSON data received";
}

// $shipperPostal = "SL3 0BB";
// $shipperCity   = "Colnbrook";
// $shipperCountry2 = "GB";
// $shipperStreet = "addres1";

// echo '';
// print_r($receiverCity);
// echo ' ';
// print_r($receiverCountry2);
// echo ' ';
// print_r($receiverStreet);

// die('dsdsd');
// $receiverPostal  = "14800";
// $receiverCity    = "Prague";
// $receiverCountry2 = "CZ";
// $receiverStreet  = "addres1";


try {
  $requestData = [
    "customerDetails" => [
      "shipperDetails" => [
        "postalCode"    => $shipperPostal,
        "cityName"      => $shipperCity,
        "countryCode"   => $shipperCountry2,
        "addressLine1"  => $shipperStreet
      ],
      "receiverDetails" => [
        "postalCode"    => $receiverPostal,
        "cityName"      => $receiverCity,
        "countryCode"   => $receiverCountry2,
        "addressLine1"  => $receiverStreet
      ]
    ],
    "accounts" => [
      [
        "typeCode" => $typeCode,
        "number"   => $accNumber
      ]
    ],
    "productCode"                => "P",
    "plannedShippingDateAndTime" => "2025-08-22T13:00:00GMT+00:00",
    "unitOfMeasurement"          => "metric",
    "isCustomsDeclarable"        => true,
    "monetaryAmount" => [
      [
        "typeCode" => "declaredValue",
        "value"    => 100,
        "currency" => "GBP"
      ]
    ],
    "packages" => [
      [
        "weight" => 0.8,
        "dimensions" => [
          "length" => 30,
          "width"  => 22,
          "height" => 2
        ]
      ]
    ]
  ];

  try {
    $rates = getDhlRates($requestData);

    echo json_encode($rates);
    exit;
  } catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => $e->getMessage()]);
    exit;
  }
} catch (Exception $e) {
  echo "Error: " . $e->getMessage();
}

function getDhlRates(array $data): array
{
  $endpoint = "https://express.api.dhl.com/mydhlapi/test/rates";
  $authToken = "Basic YXBKOG1ONHhONXlZNXI6QSQwc1UhMWdTJDd3TiE2bg==";
  $timeout   = 30;

  $payload = json_encode($data);

  $ch = curl_init();

  curl_setopt_array($ch, [
    CURLOPT_URL            => $endpoint,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT        => $timeout,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST  => "POST",
    CURLOPT_POSTFIELDS     => $payload,
    CURLOPT_HTTPHEADER     => [
      "Authorization: $authToken",
      "Content-Type: application/json",
    ],
  ]);

  $response = curl_exec($ch);

  if (curl_errno($ch)) {
    throw new Exception("cURL Error: " . curl_error($ch));
  }

  $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if ($httpCode !== 200) {
    throw new Exception("DHL API returned HTTP code $httpCode. Response: $response");
  }

  return json_decode($response, true);
}

// -------------------------
// Example Usage
// -------------------------
