<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include $_SERVER['DOCUMENT_ROOT'] . '/dhlnew/db.php';

if ($conn->connect_error) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Handle AJAX request
if (isset($_GET['action'])) {
    header('Content-Type: application/json');

    if ($_GET['action'] === 'getApplications') {
        $result = $conn->query("SELECT * FROM applications");
        $rows   = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];
    
        // Format created_at if it exists
        foreach ($rows as &$row) {
            if (!empty($row['created_at'])) {
                $row['created_at'] = date('Y-m-d', strtotime($row['created_at']));
            }
        }
    //   print_r($rows); die('');
       echo json_encode([
        "status" => "success",
        "data"   => $rows?: []
    ]);
    exit;
    }

    if ($_GET['action'] === 'getApplicationById' && !empty($_GET['id'])) {
         
        $id = intval($_GET['id']);
        $stmt = $conn->prepare("SELECT * FROM applications WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $data = $result->fetch_assoc();

        echo json_encode([
            'status' => 'success',
            'data'   => $data ?: []
        ]);
        exit;
    }
}


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Itca Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-4Q6Gf2aSP4eDXB8Miphtr37CMZZQ5oXLH2yaXMJ2w8e2ZtHTl7GptT4jmndRuHDT" crossorigin="anonymous" />

    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.2/css/dataTables.dataTables.css" />

    <link href="assets/css/style.css" rel="stylesheet" />
    <link href="assets/css/responsive.css" rel="stylesheet" />
</head>

<body>
    <div class="dashboard_wrapper">
        <div class="left_panel">
            <div class="logo_box">
                <img src="assets/images/logo.png" alt="logo" class="img-fluid full_logo" />
                <img src="assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon" />
                <div class="button_wrapper">
                    <button class="btn mobile_btn" id="mobile_btn_wrap">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-x">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M18 6l-12 12"></path>
                            <path d="M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="menu_link">
                <ul>
                    <li>
                        <a href="index.html" class="active"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-clipboard-text">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" />
                                <path d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z" />
                                <path d="M9 12h6" />
                                <path d="M9 16h6" />
                            </svg><span onclick="homePage();">Permit Request</span></a>
                    </li>
                    <li>
                        <a href="#" onclick="openFormPage(); return false;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" ...></svg>
                            <span id="formControl">Form Controller</span>
                        </a>



                    </li>
                    <li>
                        <a href=""><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-settings">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z" />
                                <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                            </svg>
                            <span>Profile Setting</span></a>
                    </li>
                    <li>
                        <a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-logout">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M14 8v-2a2 2 0 0 0 -2 -2h-7a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h7a2 2 0 0 0 2 -2v-2" />
                                <path d="M9 12h12l-3 -3" />
                                <path d="M18 15l3 -3" />
                            </svg>
                            <span>Log Out</span></a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="right_body_panel">
            <div class="right_header_panel">
                <div class="left_toggle_button">
                    <button class="btn toggle_btn" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" viewBox="0 0 20 14" fill="currentColor">
                            <path d="M0 0.995C0 0.445 0.446 0 0.995 0H9.005C9.26889 7.86455e-09 9.52197 0.10483 9.70857 0.291429C9.89517 0.478027 10 0.731109 10 0.995C10 1.25889 9.89517 1.51197 9.70857 1.69857C9.52197 1.88517 9.26889 1.99 9.005 1.99H0.995C0.731109 1.99 0.478028 1.88517 0.291429 1.69857C0.10483 1.51197 0 1.25889 0 0.995ZM0 7C0 6.45 0.446 6.005 0.995 6.005H19.005C19.2689 6.005 19.522 6.10983 19.7086 6.29643C19.8952 6.48303 20 6.73611 20 7C20 7.26389 19.8952 7.51697 19.7086 7.70357C19.522 7.89017 19.2689 7.995 19.005 7.995H0.995C0.731109 7.995 0.478028 7.89017 0.291429 7.70357C0.10483 7.51697 0 7.26389 0 7ZM0.995 12.01C0.731109 12.01 0.478028 12.1148 0.291429 12.3014C0.10483 12.488 0 12.7411 0 13.005C0 13.2689 0.10483 13.522 0.291429 13.7086C0.478028 13.8952 0.731109 14 0.995 14H13.005C13.2689 14 13.522 13.8952 13.7086 13.7086C13.8952 13.522 14 13.2689 14 13.005C14 12.7411 13.8952 12.488 13.7086 12.3014C13.522 12.1148 13.2689 12.01 13.005 12.01H0.995Z" fill="currentColor" />
                        </svg>
                    </button>
                </div>

                <div class="right_user_box">
                    <div class="user_box_warp">
                        <span class="circle-name">Ad</span>
                        <div class="user_name">
                            <h4>Admin</h4>
                        </div>
                    </div>
                </div>
            </div>
            <!--body box wrapper start here -->
            <div class="body_wrapper_section">
                <div class="body_wrap">
                    <h3>Permit Request(s)</h3>
                    <div class="table-wrapper inner-wrapper">
                        <table id="myTable" class="display table-style">
                            <thead>
                                <tr>
                                    <th>Application ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Permit Type</th>
                                    <th>Urgent</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="applicationData">

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!--body box wrapper end here -->
        </div>
    </div>
    <!--body box start here -->
    <!-- Application Detail Modal -->
    <div class="modal fade" id="applicationModal" tabindex="-1" aria-labelledby="applicationModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="applicationModalLabel">Application ID: <span id="modalAppId"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="review">
                        <div class="section">
                            <h4>Applicant’s Details</h4>
                            <div class="value"><span class="label">Full Name:</span> <span id="modalFullName"></span></div>
                            <div class="value"><span class="label">DOB:</span> <span id="modalDOB"></span></div>
                            <div class="value"><span class="label">Gender:</span> <span id="modalGender"></span></div>
                            <div class="value"><span class="label">Email:</span> <span id="modalEmail"></span></div>
                            <div class="value"><span class="label">Phone:</span> <span id="modalPhone"></span></div>
                            <div class="value"><span class="label">Nationality:</span> <span id="modalNationality"></span></div>
                            <div class="value"><span class="label">License Number:</span> <span id="modalLicense"></span></div>
                        </div>
                        <!-- Uploaded Documents -->
                        <div class="section uploaded-images-wrap">
                            <div class="d-flex justify-content-between align-items-start">
                                <h4>Uploaded Documents</h4>
                                <button class="btn download_button">
                                    <!-- Icon -->
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-download" fill="none" viewBox="0 0 24 24">
                                        <path d="M0 0h24v24H0z" stroke="none" />
                                        <path d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2" />
                                        <path d="M7 11l5 5l5 -5" />
                                        <path d="M12 4v12" />
                                    </svg>Download
                                </button>
                            </div>

                            <div class="uploaded-images">
                                <div class="value"><span class="label">Passport Photo:</span>
                                    <img id="passportPhoto" src="" style="max-width: 150px;">
                                </div>

                                <div class="d-flex dl-images">
                                    <div class="value"><span class="label">License Front:</span>
                                        <img id="licenseFront" src="" style="max-width: 150px;">
                                    </div>
                                    <div class="value"><span class="label">License Back:</span>
                                        <img id="licenseBack" src="" style="max-width: 150px;">
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Plan Details -->
                        <div class="section">
                            <h4>Selected Plan</h4>
                            <div class="value"><span class="label">Plan:</span> <span id="modalPlan"></span></div>
                            <div class="value"><span class="label">Type:</span> <span id="modalType"></span></div>
                            <div class="value"><span class="label">Issued Country:</span> <span id='modalIssueCountry'></span></div>
                            <div class="value"><span class="label">Intended Country:</span> <span id='modalIntendCountry'></span></div>
                            <div class="value"><span class="label">Classes:</span><span id='modalClasses'></span></div>
                            <div class="value"><span class="label">Add-ons:</span> <span id="modalAddOn"></span></div>
                            <div class="value"><span class="label">Promo Code:</span> <span id="modalPromoCode"></span></div>
                        </div>

                        <!-- Conditional Section -->
                        <div class="section bookletwithcard" style="display: none;">
                            <h4>Booklet Only Information</h4>
                            <p>This section is visible because you selected <strong>Booklet</strong> product.</p>
                        </div>

                        <!-- Shipping -->
                        <div class="section">
                            <h4>Shipping Address</h4>
                            <div class="value"><span class="label">Name:</span><span id="modalName">Adam Smith</span></div>
                            <div class="value"><span class="label">Street:</span><span id="modalStreet">Street 1</span></div>
                            <div class="value"><span class="label">City:</span> <span id="modalCity">City</span></div>
                            <div class="value"><span class="label">State:</span><span id="modalState">State</span></div>
                            <div class="value"><span class="label">ZIP:</span> <span id="modalZip">ZIP</span></div>
                            <div class="value"><span class="label">Country:</span><span id="modalCountry">Country</span></div>
                        </div>

                        <!-- Payment -->
                        <div class="section">
                            <h4>Payment Details</h4>
                            <div class="value"><span class="label">Transaction ID:</span><span id="modalTransId"></span></div>
                            <div class="value"><span class="label">Amount:</span><span id="modalAmount"></span></div>
                            <div class="value"><span class="label">Payment Method:</span><span id="modalPaymentMethod"></span></div>
                            <div class="value"><span class="label">Payment Date & Time:</span><span id="modalPaymentDateTime"></span></div>
                        </div>

                        <!-- Status Form -->
                        <div class="section detail-action">
                            <form>
                                <div class="field_wrapper">
                                    <label class="label" for="status">Status:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="active">Active</option>
                                        <option value="progress">In Progress</option>
                                        <option value="complete">Complete</option>
                                    </select>
                                </div>
                                <button class="btn btn-primary" type="button" disabled>Save</button>
                            </form>
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!--<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js" integrity="sha384-j1CDi7MgGQ12Z7Qab0qlWQ/Qqz24Gc6BM0thvEMVjHnfYGF0rmFCozFSxQBxwHKO" crossorigin="anonymous"></script>-->
    <!--<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>-->
    <!--<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>-->
    <!--<script src="https://cdn.datatables.net/2.3.2/js/dataTables.js"></script>-->

    <script src="assets/js/scriptv1.js"></script>
    
 <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script>
        $(document).ready(function() {
            $.ajax({
                url: 'dashboard.php?action=getApplications',
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    alert('1');
                    if (response.status === 'success') {
                        
                        let html = '';
                        response.data.forEach(function(item) {
                            html += `
                                <tr>
                                    <td>${item.id}</td>
                                    <td>${item.full_name}</td>
                                    <td>${item.email}</td>
                                    <td>${item.phone}</td>
                                    <td>${item.plan}</td>
                                    <td>${item.type}</td>
                                    <td>${item.created_at}</td>
                                    <td class="active-pill status-pill">${item.status}</td>
                                    <td>
                                        <a href="#" class="action-btn" onclick="getDetail(${item.id})">View Detail</a>
                                    </td>
                                </tr>
                            `;
                        });
                        $('#applicationData').html(html);
                    } else {
                        $('#applicationData').html('<tr><td colspan="8">No data found</td></tr>');
                    }
                },
                error: function(xhr, status, error) {
                   
                    $('#applicationData').html('<tr><td colspan="8">AJAX error</td></tr>');
                }
            });
        });

        function getDetail(id) {
            $.ajax({
                url: 'dashboard.php?action=getApplicationById&id=' + id,
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        const data = response.data;
                        $('#modalAppId').text(data.id);
                        $('#modalFullName').text(data.full_name);
                        $('#modalDOB').text(data.dob || 'N/A');
                        $('#modalGender').text(data.gender || 'N/A');
                        $('#modalEmail').text(data.email || 'N/A');
                        $('#modalPhone').text(data.phone || 'N/A');
                        // ... Fill other modal fields similarly ...
                        // Show modal code here (assuming Bootstrap modal)
                        const modal = new bootstrap.Modal(document.getElementById('applicationModal'));
                        modal.show();
                    } else {
                        alert('Details not found');
                    }
                },
                error: function(xhr, status, error) {
                     alert('Could not fetch details');
                }
            });
        }
    </script>
</body>

</html>
