<?php
include 'session.php';
include 'db.php';
/**
 * DHL Rate Request - Refactored Version
 */
// Defaults (from session)
$typeCode = "shipper";
$accNumber = "425959129";


try {
    $errors = [];
   
    // Example validation
    if (empty($_SESSION['step1']['zip'])) $errors['shipper_zip'] = "Shipper postal code is required";
    if (empty($_SESSION['step1']['city'])) $errors['shipper_city'] = "Shipper city is required";
    if (empty($_SESSION['step1']['country'])) $errors['shipper_country'] = "Shipper country is required";
   
    $rawData = file_get_contents("php://input");
    $data = json_decode($rawData, true);

    if (!$data || !isset($data['receiverDetails'])) {
        $errors['receiver'] = "Receiver details missing";
    } else {
        $receiver = $data['receiverDetails'];
       // Extract IDs (coming from JS)
        $receiverFirstName = $receiver['recFirstName'] ?? '';
        $receiverLastName  = $receiver['recLastName'] ?? '';
        $receiverPostal    = $receiver['postalCode'] ?? '';
        $receiverStateId   = $receiver['recState'] ?? '';
        $receiverCityId    = $receiver['cityName'] ?? '';
        $receiverCountryId = $receiver['countryCode'] ?? '';
        $receiverStreet    = $receiver['addressLine1'] ?? '';
        
        $receiverCountry2 = '';
        if (!empty($receiverCountryId)) {
            $stmt = $conn->prepare("SELECT shortname FROM countries WHERE id = ?");
            $stmt->bind_param("i", $receiverCountryId);
            $stmt->execute();
            $stmt->bind_result($countryCode);
            $stmt->fetch();
            $stmt->close();
            $receiverCountry2 = strtoupper($countryCode ?? '');
        }
        
         if (!empty($receiverStateId)) {
            $stmt = $conn->prepare("SELECT name FROM states WHERE id = ?");
            $stmt->bind_param("i", $receiverStateId);
            $stmt->execute();
            $stmt->bind_result($stateName);
            $stmt->fetch();
            $stmt->close();
            $receiverState = $stateName ?? '';
        } else {
            $receiverState = '';
        }
        
        
        if (!empty($receiverCityId)) {
            $stmt = $conn->prepare("SELECT name FROM cities WHERE id = ?");
            $stmt->bind_param("i", $receiverCityId);
            $stmt->execute();
            $stmt->bind_result($cityName);
            $stmt->fetch();
            $stmt->close();
            $receiverCity = $cityName ?? '';
        } else {
            $receiverCity = '';
        }
       
         // Validate fields
        if (empty($receiverFirstName)) $errors['receiver_first_name'] = "Receiver first name is required";
        if (empty($receiverLastName))  $errors['receiver_last_name']  = "Receiver last name is required";
        if (empty($receiverPostal))    $errors['receiver_postal']     = "Receiver postal code is required";
        if (empty($receiverState))     $errors['receiver_state']      = "Receiver state is required";
        if (empty($receiverCity))      $errors['receiver_city']       = "Receiver city is required";
        if (empty($receiverCountry2))  $errors['receiver_country']    = "Receiver country is required";
        if (empty($receiverStreet)) {
            $errors['receiver_street'] = "Receiver street is required";
            } elseif (strlen($receiverStreet) > 45) {
                $errors['receiver_street'] = "Receiver street must not exceed 45 characters (currently " . strlen($receiverStreet) . ")";
            }

    }

    // If validation failed, send error response
    if (!empty($errors)) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "errors" => $errors
        ]);
        exit;
    }
    
     $_SESSION['step4'] = [
    'first_name' => $receiverFirstName,
    'last_name'  => $receiverLastName,
    'zip'     => $receiverPostal,
    'state'      => $receiverState,
    'city'       => $receiverCity,
    'country'    => $receiverCountry2,
    'street'     => $receiverStreet
  ];
$plannedDate = gmdate("Y-m-d\TH:i:s\G\M\T+00:00", strtotime("+12 hour"));
    // --- Build DHL request ---
    $requestData = [
        "customerDetails" => [
            "shipperDetails" => [
                "postalCode"   => $_SESSION['step1']['zip'],
                "cityName"     => $_SESSION['step1']['city'],
                "countryCode"  => strtoupper(substr($_SESSION['step1']['country'], 0, 2)),
                "addressLine1" => $_SESSION['step1']['street'] ?? ''
            ],
            "receiverDetails" => [
                "postalCode"   => $receiverPostal,
                "cityName"     => $receiverCity,
                "countryCode"  => $receiverCountry2,
                "addressLine1" => $receiverStreet
            ]
        ],
        "accounts" => [
            [
                "typeCode" => $typeCode,
                "number"   => $accNumber, 
            ]
        ],
        "productCode"                => "P",
        "plannedShippingDateAndTime" => $plannedDate,
        "unitOfMeasurement"          => "metric",
        "isCustomsDeclarable"        => true,
        "monetaryAmount" => [
            [
                "typeCode" => "declaredValue",
                "value"    => 100,
                "currency" => "GBP"
            ]
        ],
        "packages" => [
            [
                "weight" => 0.8,
                "dimensions" => [
                    "length" => 30,
                    "width"  => 22,
                    "height" => 2
                ]
            ]
        ]
    ];

    // --- Call DHL API (pseudo function) ---
    $rates = getDhlRates($requestData);
 
    // --- Handle DHL response ---
    if (!isset($rates['products']) || empty($rates['products'])) {
        echo json_encode([
            "status" => "error",
            "errors" => ["dhl" => "No products returned. Check your request."]
        ]);
        exit;
    }

    echo json_encode([
        "status" => "success",
        "data"   => $rates
    ]);
    exit;

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}


function getDhlRates(array $data): array
{
  $endpoint = "https://express.api.dhl.com/mydhlapi/test/rates";
  $authToken = "Basic YXBKOG1ONHhONXlZNXI6QSQwc1UhMWdTJDd3TiE2bg==";
  $timeout   = 30;

  $payload = json_encode($data);

  $ch = curl_init();

  curl_setopt_array($ch, [
    CURLOPT_URL            => $endpoint,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT        => $timeout,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST  => "POST",
    CURLOPT_POSTFIELDS     => $payload,
    CURLOPT_HTTPHEADER     => [
      "Authorization: $authToken",
      "Content-Type: application/json",
    ],
  ]);

  $response = curl_exec($ch);

  if (curl_errno($ch)) {
    throw new Exception("cURL Error: " . curl_error($ch));
  }

  $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if ($httpCode !== 200) {
    throw new Exception("DHL API returned HTTP code $httpCode. Response: $response");
  }

  return json_decode($response, true);
}
