<?php
include 'db.php';
header('Content-Type: application/json');

try {
    $state_id = intval($_GET['state_id'] ?? 0);

    if ($state_id <= 0) {
        echo json_encode(["error" => "Invalid state ID"]);
        exit;
    }

    $stmt = $conn->prepare("SELECT id, name FROM cities WHERE state_id = ?");
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("i", $state_id);

    if (!$stmt->execute()) {
        throw new Exception("Execution failed: " . $stmt->error);
    }

    $result = $stmt->get_result();
    $cities = [];
    while ($row = $result->fetch_assoc()) {
        $cities[] = $row;
    }

    echo json_encode($cities);

    $stmt->close();
    $conn->close();

} catch (Exception $e) {
    // Don’t expose DB error details to the user
    error_log("DB Error: " . $e->getMessage()); 
    echo json_encode(["error" => "Something went wrong. Please try again later."]);
}
