<?php
include 'db.php'; 

header('Content-Type: application/json');

try {
    $sql = "SELECT id, name FROM countries ORDER BY name ASC";
    $result = $conn->query($sql);

    if (!$result) {
        throw new Exception("Query failed: " . $conn->error);
    }

    $countries = [];
    while ($row = $result->fetch_assoc()) {
        $countries[] = $row;
    }

    echo json_encode($countries);

    $result->free();

} catch (Exception $e) {
    error_log("DB Error (getcountry.php): " . $e->getMessage()); // log actual error
    echo json_encode(["error" => "Unable to fetch countries"]);
}
