<?php
include 'db.php';

header('Content-Type: application/json');

try {
    $country_id = intval($_GET['country_id'] ?? 0);

    if ($country_id <= 0) {
        echo json_encode(["error" => "Invalid country ID"]);
        exit;
    }

    $stmt = $conn->prepare("SELECT id, name FROM states WHERE country_id = ? ORDER BY name ASC");
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("i", $country_id);

    if (!$stmt->execute()) {
        throw new Exception("Execute failed: " . $stmt->error);
    }

    $result = $stmt->get_result();
    $states = $result->fetch_all(MYSQLI_ASSOC);

    echo json_encode($states);

    $stmt->close();

} catch (Exception $e) {
    error_log("DB Error: " . $e->getMessage()); // log real error
    echo json_encode(["error" => "Database query failed"]);
}
