
<?php
include 'session.php';

?>
<!DOCTYPE html>
<html>

<head>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Step 1 - Applicant's Details</title>
  <?php include('link.php'); ?>
</head>

<body>
  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step active">
        <span class="number">01</span>
        <span class="label">Applicant’s Details</span>
      </div>
      <div class="step">
        <span class="number">02</span>
        <span class="label">Choose Plan</span>
      </div>
      <div class="step">
        <span class="number">03</span>
        <span class="label">Add Document</span>
      </div>
      <div class="step">
        <span class="number">04</span>
        <span class="label">Shipping</span>
      </div>
      <div class="step">
        <span class="number">05</span>
        <span class="label">Review</span>
      </div>
      <div class="step">
        <span class="number">06</span>
        <span class="label">Payment</span>
      </div>
    </div>
  </section>


  <div class="licenceform">
    <div class="container">


      <div class="main-form-container">

        <div class="form-container">
          <h2>Applicant’s Details</h2>
          <form method="post" action="save_step1.php">
            <div class="licenceform-row">
              <div class="formfield">
                <label>First Name *</label>
                <input type="text" name="first_name" required>
              </div>
              <div class="formfield">
                <label>Last Name *</label>
                <input type="text" name="last_name" required>
              </div>
              <div class="formfield">
                <label>Email *</label>
                <input type="email" name="email" required>
              </div>
              <div class="formfield">
                <label>WhatsApp Number *</label>
                <input type="text" name="whatsapp" required>
              </div>
              <div class="formfield">
                <label>Date of Birth *</label>
                <div style="display: flex; gap: 10px;">
                  <input type="text" name="dob_month" placeholder="Month" required>
                  <input type="text" name="dob_day" placeholder="Day" required>
                  <input type="text" name="dob_year" placeholder="Year" required>
                </div>
              </div>
              <div class="formfield">
                <label>Place of Birth *</label>
                <select id="birth" name="birth_place" required>
                    <option value="">Select Country</option>
                </select>
              </div>
             <div class="formfield full-field">
              <label>Country *</label>
               <select id="country" name="country" required>
                <option value="">Select Country</option>
                </select>

             </div>


              <div class="formfield full-field">
                <label>Street Address *</label>
                <input type="text" name="street" required>
              </div>

              <div class="formfield full-field">
                  <label>State / Region / Province *</label>
                  <select id="state" name="state" required>
                    <option value="">Select State</option>
                  </select>
               </div>

              <div class="formfield" style="display: flex; gap: 10px;">
                <div style="flex: 1;">
                  <label>ZIP *</label>
                  <input type="text" name="zip" required>
                </div>
                <div class="formfield full-field">
                  <label>City *</label>
                  <select id="city" name="city" required>
                    <option value="">Select City</option>
                  </select>
                </div>
              </div>
              <div class="formfield full-field">
                <label>Permanent Place of Residence *</label>
                <select id="permanent" name="residence" required>
                    <option value="">Select Place</option>
                </select>
              </div>
              <div class="formfield">
                <label>Gender *</label>
                <div class="gender-group">
                  <label class="gender-box active" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Male" checked>
                    <img style="margin-bottom:6px;" src="assets/images/male.svg"><br> Male
                  </label>
                  <label class="gender-box" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Female">
                    <img style="margin-bottom:6px;" src="assets/images/female.svg"><br> Female
                  </label>
                </div>
              </div>
            </div>

            <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
          </form>
        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>

      </div>


    </div>
  </div>





  <?php include('footer.php'); ?>



  <script>
    function selectGender(el) {
      document.querySelectorAll('.gender-box').forEach(box => box.classList.remove('active'));
      el.classList.add('active');
      el.querySelector('input').checked = true;
    }
  </script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  const countrySelect = document.getElementById("country");
  const placeSelect = document.getElementById("birth");
  const permanent = document.getElementById("permanent");
  const stateSelect = document.getElementById("state");
  const citySelect = document.getElementById("city");
  

  // Load countries on page load
  fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
      countries.forEach(c => {
        countrySelect.innerHTML += `<option value="${c.id}">${c.name}</option>`;
        placeSelect.innerHTML += `<option value="${c.id}">${c.name}</option>`;
        permanent.innerHTML += `<option value="${c.id}">${c.name}</option>`;
      });
    });

  // When country changes → load states
  countrySelect.addEventListener("change", function () {
    stateSelect.innerHTML = '<option value="">Select State</option>';
    citySelect.innerHTML = '<option value="">Select City</option>';

    if (this.value) {
      fetch("get_states.php?country_id=" + this.value)
        .then(res => res.json())
        .then(states => {
          states.forEach(s => {
            stateSelect.innerHTML += `<option value="${s.id}">${s.name}</option>`;
          });
        });
    }
  });

  // When state changes → load cities
  stateSelect.addEventListener("change", function () {
    citySelect.innerHTML = '<option value="">Select City</option>';

    if (this.value) {
      fetch("get_cities.php?state_id=" + this.value)
        .then(res => res.json())
        .then(cities => {
          cities.forEach(c => {
            citySelect.innerHTML += `<option value="${c.id}">${c.name}</option>`;
          });
        });
    }
  });
});
</script>



  <?php include('footerscript.php'); ?>



</body>

</html>