<?php
session_start();
include 'db.php';

$country_id = intval($_POST['country'] ?? 0);
$state_id   = intval($_POST['state'] ?? 0);
$city_id    = intval($_POST['city'] ?? 0);

$country_name = '';
$state_name   = '';
$city_name    = '';

if ($country_id) {
    $stmt = $conn->prepare("SELECT shortname FROM countries WHERE id = ?");
    $stmt->bind_param("i", $country_id);
    $stmt->execute();
    $stmt->bind_result($country_name);
    $stmt->fetch();
    $stmt->close();
}

if ($state_id) {
    $stmt = $conn->prepare("SELECT name FROM states WHERE id = ?");
    $stmt->bind_param("i", $state_id);
    $stmt->execute();
    $stmt->bind_result($state_name);
    $stmt->fetch();
    $stmt->close();
}

if ($city_id) {
    $stmt = $conn->prepare("SELECT name FROM cities WHERE id = ?");
    $stmt->bind_param("i", $city_id);
    $stmt->execute();
    $stmt->bind_result($city_name);
    $stmt->fetch();
    $stmt->close();
}

// Store in session
$_SESSION['step1'] = [
    'full_name' => $_POST['first_name'] . ' ' . $_POST['last_name'],
     'email'       => $_POST['email'] ?? '',
    'phone' => $_POST['whatsapp'],
    'dob' => $_POST['dob_year'] . '-' . $_POST['dob_month'] . '-' . $_POST['dob_day'],
    'gender' => $_POST['gender'],
    'nationality' => $_POST['residence'],
    'license_number' => $_POST['license_number'],
    'street'         => $_POST['street'],
    'zip'            => $_POST['zip'],
     
     'country_id'  => $country_id,
    'country'     => $country_name,
    'state_id'    => $state_id,
    'state'       => $state_name,
    'city_id'     => $city_id,
    'city'        => $city_name,
    
];

// Redirect to step2.php
header("Location: step2.php");
exit;


