<?php
include 'session.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  $_SESSION['step4'] = $_POST;
  header('Location: step5.php');
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>
  <title>Step 4 - Shipping Address</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php include('link.php'); ?>
</head>

<body>


  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step ">
        <span class="number">01</span>
        <span class="label">Applicant’s Details</span>
      </div>
      <div class="step ">
        <span class="number">02</span>
        <span class="label">Choose Plan</span>
      </div>
      <div class="step ">
        <span class="number">03</span>
        <span class="label">Add Document</span>
      </div>
      <div class="step active">
        <span class="number">04</span>
        <span class="label">Shipping</span>
      </div>
      <div class="step">
        <span class="number">05</span>
        <span class="label">Review</span>
      </div>
      <div class="step">
        <span class="number">06</span>
        <span class="label">Payment</span>
      </div>
    </div>
  </section>

  <div class="licenceform">
    <div class="container">

      <div class="main-form-container">
        <div class="form-container">
          <h2>Shipping Address</h2>
          <form method="post" action="">
            <!-- First Name / Last Name -->
            <div class="formfield step-four" style="display: flex; gap: 10px;">
              <div style="flex: 1;">
                <label>First Name *</label><br>
                <input type="text" name="first_name" required>
              </div>
              <div style="flex: 1;">
                <label>Last Name *</label><br>
                <input type="text" name="last_name" required>
              </div>
            </div><br>

            <!-- Country -->
            <label>Country *</label><br>
            <select id="country" name="country" required>
                <option value="">Select Country</option>
            </select><br><br>

            <!-- Street Address -->
            <label>Street Address *</label><br>
            <input type="text" name="street" required><br><br>

            <!-- State / Region -->
            <label>State/Region/Province *</label><br>
            <select id="state" name="state" required>
                <option value="">Select State</option>
            </select><br><br>

            <!-- ZIP & City -->
            <div class="formfield" style="display: flex; gap: 10px;">
              <div style="flex: 1;">
                <label>ZIP *</label><br>
                <input type="text" name="zip" required>
              </div>
              <div style="flex: 1;">
                <label>City *</label><br>
                 <select id="city" name="city" required>
                    <option value="">Select City</option>
                  </select>
              </div>
            </div><br>


            <!-- Buttons -->
            <div class="back-continue-button-wrap">
              <a href="step3.php"><button type="button" class="first-btn-cicle">Back</button></a>
              <button type="submit" id="getRatesBtn" class="btn secondary-btn-circle">Verify & Continue</button>
            </div>
          </form>
        </div>
        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>
      </div>

    </div>
  </div>


  <?php include('footer.php'); ?>



  <script>
    // Hamburger Toggle
    document.addEventListener('DOMContentLoaded', function() {
      const hamburger = document.querySelector('.hamburger');
      const navLinks = document.querySelector('.nav-links');

      if (hamburger && navLinks) {
        hamburger.addEventListener('click', function() {
          navLinks.classList.toggle('active');
        });
      }
    });

 //dynamic city, country and state

  const countrySelect = document.getElementById("country");
  const stateSelect = document.getElementById("state");
  const citySelect = document.getElementById("city");

  // Load countries on page load
  fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
      countries.forEach(c => {
        countrySelect.innerHTML += `<option value="${c.id}">${c.name}</option>`;
      });
    });

  // When country changes → load states
  countrySelect.addEventListener("change", function () {
    stateSelect.innerHTML = '<option value="">Select State</option>';
    citySelect.innerHTML = '<option value="">Select City</option>';

    if (this.value) {
      fetch("get_states.php?country_id=" + this.value)
        .then(res => res.json())
        .then(states => {
          states.forEach(s => {
            stateSelect.innerHTML += `<option value="${s.id}">${s.name}</option>`;
          });
        });
    }
  });

  // When state changes → load cities
  stateSelect.addEventListener("change", function () {
    citySelect.innerHTML = '<option value="">Select City</option>';

    if (this.value) {
      fetch("get_cities.php?state_id=" + this.value)
        .then(res => res.json())
        .then(cities => {
          cities.forEach(c => {
            citySelect.innerHTML += `<option value="${c.id}">${c.name}</option>`;
          });
        });
    }
  });


 // dhl api request
let isProcessing = false;
document.getElementById("getRatesBtn").addEventListener("click", function(event) {
  event.preventDefault();

//   if (isProcessing) {
//     console.log("Request already in progress...");
//     return;
//   }
  
  isProcessing = true;

  let recFirstName  = document.querySelector("input[name='first_name']").value.trim();
  let recLastName   = document.querySelector("input[name='last_name']").value.trim();
  let recPostalCode = document.querySelector("input[name='zip']").value.trim();
  let recCityName   = document.querySelector("select[name='city']").value.trim();
  let recCountryCode = document.querySelector("select[name='country']").value.trim();
  let recAddress    = document.querySelector("input[name='street']").value.trim();
  let recState      = document.querySelector("select[name='state']").value.trim();
  
  let requestData = {
    receiverDetails: {
      recFirstName: recFirstName,
      recLastName: recLastName,
      postalCode: recPostalCode,
      cityName: recCityName,
      countryCode: recCountryCode,
      recState: recState,
      addressLine1: recAddress
    }
  };

  fetch("dhl_rate.php", {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    },
    body: JSON.stringify(requestData)
  })
    .then(response => response.json())
    .then(data => {
      console.log("DHL Response:", data);

       if(data.status === "error") {
            if (data.errors) {
              let errorMessages = Object.entries(data.errors)
                .map(([field, msg]) => `${field}: ${msg}`)
                .join("\n");
              alert("Validation Errors:\n" + errorMessages);
            } else {
              alert("Error: " + (data.message || "Unknown error"));
            }
            isProcessing = false;
            return;
        }

      // find the billing currency (BILLC)
        let products = data.data.products || [];
        let totalPrices = products[0]?.totalPrice || [];
        let billcRate = totalPrices.find(p => p.currencyType === "BILLC");

      if (billcRate) {
        localStorage.setItem("dhl_rate", JSON.stringify(billcRate));
        let baseUrl = window.location.origin + "/dhlnew/";
        window.location.href = baseUrl + "step5.php";
      } else {
           let available = totalPrices.map(p => p.currencyType).join(", ");
           alert("No BILLC found. Available currencies: " + available);
           isProcessing = false;
      }
    })
    .catch(err => {
      console.error("Error fetching DHL rates:", err);
      alert("Something went wrong while contacting DHL API.");
    })
    .finally(() => {
      isProcessing = false; 
    });
});
  </script>

</body>

</html>